% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_attach_user_policy}
\alias{iam_attach_user_policy}
\title{Attaches the specified managed policy to the specified user}
\usage{
iam_attach_user_policy(UserName, PolicyArn)
}
\arguments{
\item{UserName}{[required] The name (friendly name, not ARN) of the IAM user to attach the policy
to.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}

\item{PolicyArn}{[required] The Amazon Resource Name (ARN) of the IAM policy you want to attach.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}
}
\description{
Attaches the specified managed policy to the specified user.

You use this API to attach a \emph{managed} policy to a user. To embed an
inline policy in a user, use PutUserPolicy.

For more information about policies, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html}{Managed Policies and Inline Policies}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$attach_user_policy(
  UserName = "string",
  PolicyArn = "string"
)
}
}

\examples{
\dontrun{
# The following command attaches the AWS managed policy named
# AdministratorAccess to the IAM user named Alice.
svc$attach_user_policy(
  PolicyArn = "arn:aws:iam::aws:policy/AdministratorAccess",
  UserName = "Alice"
)
}

}
\keyword{internal}
