% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_delete_byte_match_set}
\alias{waf_delete_byte_match_set}
\title{This is AWS WAF Classic documentation}
\usage{
waf_delete_byte_match_set(ByteMatchSetId, ChangeToken)
}
\arguments{
\item{ByteMatchSetId}{[required] The \code{ByteMatchSetId} of the ByteMatchSet that you want to delete.
\code{ByteMatchSetId} is returned by CreateByteMatchSet and by
ListByteMatchSets.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Permanently deletes a ByteMatchSet. You can't delete a \code{ByteMatchSet} if
it's still used in any \code{Rules} or if it still includes any
ByteMatchTuple objects (any filters).

If you just want to remove a \code{ByteMatchSet} from a \code{Rule}, use
UpdateRule.

To permanently delete a \code{ByteMatchSet}, perform the following steps:
\enumerate{
\item Update the \code{ByteMatchSet} to remove filters, if any. For more
information, see UpdateByteMatchSet.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{DeleteByteMatchSet} request.
\item Submit a \code{DeleteByteMatchSet} request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_byte_match_set(
  ByteMatchSetId = "string",
  ChangeToken = "string"
)
}
}

\examples{
\dontrun{
# The following example deletes a byte match set with the ID
# exampleIDs3t-46da-4fdb-b8d5-abc321j569j5.
svc$delete_byte_match_set(
  ByteMatchSetId = "exampleIDs3t-46da-4fdb-b8d5-abc321j569j5",
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f"
)
}

}
\keyword{internal}
