% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_delete_web_acl}
\alias{wafregional_delete_web_acl}
\title{This is AWS WAF Classic documentation}
\usage{
wafregional_delete_web_acl(WebACLId, ChangeToken)
}
\arguments{
\item{WebACLId}{[required] The \code{WebACLId} of the WebACL that you want to delete. \code{WebACLId} is
returned by CreateWebACL and by ListWebACLs.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Permanently deletes a WebACL. You can't delete a \code{WebACL} if it still
contains any \code{Rules}.

To delete a \code{WebACL}, perform the following steps:
\enumerate{
\item Update the \code{WebACL} to remove \code{Rules}, if any. For more information,
see UpdateWebACL.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{DeleteWebACL} request.
\item Submit a \code{DeleteWebACL} request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_web_acl(
  WebACLId = "string",
  ChangeToken = "string"
)
}
}

\examples{
\dontrun{
# The following example deletes a web ACL with the ID
# example-46da-4444-5555-example.
svc$delete_web_acl(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  WebACLId = "example-46da-4444-5555-example"
)
}

}
\keyword{internal}
