% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_list_directories}
\alias{clouddirectory_list_directories}
\title{Lists directories created within an account}
\usage{
clouddirectory_list_directories(NextToken, MaxResults, state)
}
\arguments{
\item{NextToken}{The pagination token.}

\item{MaxResults}{The maximum number of results to retrieve.}

\item{state}{The state of the directories in the list. Can be either Enabled,
Disabled, or Deleted.}
}
\value{
A list with the following syntax:\preformatted{list(
  Directories = list(
    list(
      Name = "string",
      DirectoryArn = "string",
      State = "ENABLED"|"DISABLED"|"DELETED",
      CreationDateTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists directories created within an account.
}
\section{Request syntax}{
\preformatted{svc$list_directories(
  NextToken = "string",
  MaxResults = 123,
  state = "ENABLED"|"DISABLED"|"DELETED"
)
}
}

\keyword{internal}
