% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_list_log_subscriptions}
\alias{directoryservice_list_log_subscriptions}
\title{Lists the active log subscriptions for the AWS account}
\usage{
directoryservice_list_log_subscriptions(DirectoryId, NextToken, Limit)
}
\arguments{
\item{DirectoryId}{If a \emph{DirectoryID} is provided, lists only the log subscription
associated with that directory. If no \emph{DirectoryId} is provided, lists
all log subscriptions associated with your AWS account. If there are no
log subscriptions for the AWS account or the directory, an empty list
will be returned.}

\item{NextToken}{The token for the next set of items to return.}

\item{Limit}{The maximum number of items returned.}
}
\value{
A list with the following syntax:\preformatted{list(
  LogSubscriptions = list(
    list(
      DirectoryId = "string",
      LogGroupName = "string",
      SubscriptionCreatedDateTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the active log subscriptions for the AWS account.
}
\section{Request syntax}{
\preformatted{svc$list_log_subscriptions(
  DirectoryId = "string",
  NextToken = "string",
  Limit = 123
)
}
}

\keyword{internal}
