% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_service.R
\name{secretsmanager}
\alias{secretsmanager}
\title{AWS Secrets Manager}
\usage{
secretsmanager(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
AWS Secrets Manager API Reference

AWS Secrets Manager provides a service to enable you to store, manage,
and retrieve, secrets.

This guide provides descriptions of the Secrets Manager API. For more
information about using this service, see the \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/}{AWS Secrets Manager User Guide}.

\strong{API Version}

This version of the Secrets Manager API Reference documents the Secrets
Manager API version 2017-10-17.

As an alternative to using the API, you can use one of the AWS SDKs,
which consist of libraries and sample code for various programming
languages and platforms such as Java, Ruby, .NET, iOS, and Android. The
SDKs provide a convenient way to create programmatic access to AWS
Secrets Manager. For example, the SDKs provide cryptographically signing
requests, managing errors, and retrying requests automatically. For more
information about the AWS SDKs, including downloading and installing
them, see \href{https://aws.amazon.com/tools/}{Tools for Amazon Web Services}.

We recommend you use the AWS SDKs to make programmatic API calls to
Secrets Manager. However, you also can use the Secrets Manager HTTP
Query API to make direct calls to the Secrets Manager web service. To
learn more about the Secrets Manager HTTP Query API, see \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/query-requests.html}{Making Query Requests}
in the \emph{AWS Secrets Manager User Guide}.

Secrets Manager API supports GET and POST requests for all actions, and
doesn't require you to use GET for some actions and POST for others.
However, GET requests are subject to the limitation size of a URL.
Therefore, for operations that require larger sizes, use a POST request.

\strong{Support and Feedback for AWS Secrets Manager}

We welcome your feedback. Send your comments to
\href{mailto:awssecretsmanager-feedback@amazon.com}{awssecretsmanager-feedback@amazon.com}, or post your feedback and
questions in the \href{https://forums.aws.amazon.com:443/forum.jspa?forumID=296}{AWS Secrets Manager Discussion Forum}. For
more information about the AWS Discussion Forums, see \href{https://forums.aws.amazon.com:443/help.jspa}{Forums Help}.

\strong{How examples are presented}

The JSON that AWS Secrets Manager expects as your request parameters and
the service returns as a response to HTTP query requests contain single,
long strings without line breaks or white space formatting. The JSON
shown in the examples displays the code formatted with both line breaks
and white space to improve readability. When example input parameters
can also cause long strings extending beyond the screen, you can insert
line breaks to enhance readability. You should always submit the input
as a single JSON text string.

\strong{Logging API Requests}

AWS Secrets Manager supports AWS CloudTrail, a service that records AWS
API calls for your AWS account and delivers log files to an Amazon S3
bucket. By using information that's collected by AWS CloudTrail, you can
determine the requests successfully made to Secrets Manager, who made
the request, when it was made, and so on. For more about AWS Secrets
Manager and support for AWS CloudTrail, see \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/monitoring.html#monitoring_cloudtrail}{Logging AWS Secrets Manager Events with AWS CloudTrail}
in the \emph{AWS Secrets Manager User Guide}. To learn more about CloudTrail,
including enabling it and find your log files, see the \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-user-guide.html}{AWS CloudTrail User Guide}.
}
\section{Service syntax}{
\preformatted{svc <- secretsmanager(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=secretsmanager_cancel_rotate_secret]{cancel_rotate_secret} \tab Disables automatic scheduled rotation and cancels the rotation of a secret if currently in progress\cr
\link[=secretsmanager_create_secret]{create_secret} \tab Creates a new secret\cr
\link[=secretsmanager_delete_resource_policy]{delete_resource_policy} \tab Deletes the resource-based permission policy attached to the secret\cr
\link[=secretsmanager_delete_secret]{delete_secret} \tab Deletes an entire secret and all of its versions\cr
\link[=secretsmanager_describe_secret]{describe_secret} \tab Retrieves the details of a secret\cr
\link[=secretsmanager_get_random_password]{get_random_password} \tab Generates a random password of the specified complexity\cr
\link[=secretsmanager_get_resource_policy]{get_resource_policy} \tab Retrieves the JSON text of the resource-based policy document attached to the specified secret\cr
\link[=secretsmanager_get_secret_value]{get_secret_value} \tab Retrieves the contents of the encrypted fields SecretString or SecretBinary from the specified version of a secret, whichever contains content\cr
\link[=secretsmanager_list_secrets]{list_secrets} \tab Lists all of the secrets that are stored by Secrets Manager in the AWS account\cr
\link[=secretsmanager_list_secret_version_ids]{list_secret_version_ids} \tab Lists all of the versions attached to the specified secret\cr
\link[=secretsmanager_put_resource_policy]{put_resource_policy} \tab Attaches the contents of the specified resource-based permission policy to a secret\cr
\link[=secretsmanager_put_secret_value]{put_secret_value} \tab Stores a new encrypted secret value in the specified secret\cr
\link[=secretsmanager_restore_secret]{restore_secret} \tab Cancels the scheduled deletion of a secret by removing the DeletedDate time stamp\cr
\link[=secretsmanager_rotate_secret]{rotate_secret} \tab Configures and starts the asynchronous process of rotating this secret\cr
\link[=secretsmanager_tag_resource]{tag_resource} \tab Attaches one or more tags, each consisting of a key name and a value, to the specified secret\cr
\link[=secretsmanager_untag_resource]{untag_resource} \tab Removes one or more tags from the specified secret\cr
\link[=secretsmanager_update_secret]{update_secret} \tab Modifies many of the details of the specified secret\cr
\link[=secretsmanager_update_secret_version_stage]{update_secret_version_stage} \tab Modifies the staging labels attached to a version of a secret\cr
\link[=secretsmanager_validate_resource_policy]{validate_resource_policy} \tab Validates the JSON text of the resource-based policy document attached to the specified secret
}
}

\examples{
\dontrun{
svc <- secretsmanager()
# The following example shows how to cancel rotation for a secret. The
# operation sets the RotationEnabled field to false and cancels all
# scheduled rotations. To resume scheduled rotations, you must re-enable
# rotation by calling the rotate-secret operation.
svc$cancel_rotate_secret(
  SecretId = "MyTestDatabaseSecret"
)
}

}
