% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_delete_geo_match_set}
\alias{wafregional_delete_geo_match_set}
\title{This is AWS WAF Classic documentation}
\usage{
wafregional_delete_geo_match_set(GeoMatchSetId, ChangeToken)
}
\arguments{
\item{GeoMatchSetId}{[required] The \code{GeoMatchSetID} of the GeoMatchSet that you want to delete.
\code{GeoMatchSetId} is returned by
\code{\link[=wafregional_create_geo_match_set]{create_geo_match_set}} and by
\code{\link[=wafregional_list_geo_match_sets]{list_geo_match_sets}}.}

\item{ChangeToken}{[required] The value returned by the most recent call to
\code{\link[=wafregional_get_change_token]{get_change_token}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ChangeToken = "string"
)
}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Permanently deletes a GeoMatchSet. You can't delete a \code{GeoMatchSet} if
it's still used in any \code{Rules} or if it still includes any countries.

If you just want to remove a \code{GeoMatchSet} from a \code{Rule}, use
\code{\link[=wafregional_update_rule]{update_rule}}.

To permanently delete a \code{GeoMatchSet} from AWS WAF, perform the
following steps:
\enumerate{
\item Update the \code{GeoMatchSet} to remove any countries. For more
information, see
\code{\link[=wafregional_update_geo_match_set]{update_geo_match_set}}.
\item Use \code{\link[=wafregional_get_change_token]{get_change_token}} to get the
change token that you provide in the \code{ChangeToken} parameter of a
\code{\link[=wafregional_delete_geo_match_set]{delete_geo_match_set}} request.
\item Submit a \code{\link[=wafregional_delete_geo_match_set]{delete_geo_match_set}}
request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_geo_match_set(
  GeoMatchSetId = "string",
  ChangeToken = "string"
)
}
}

\keyword{internal}
