% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_list_facet_attributes}
\alias{clouddirectory_list_facet_attributes}
\title{Retrieves attributes attached to the facet}
\usage{
clouddirectory_list_facet_attributes(SchemaArn, Name, NextToken,
  MaxResults)
}
\arguments{
\item{SchemaArn}{[required] The ARN of the schema where the facet resides.}

\item{Name}{[required] The name of the facet whose attributes will be retrieved.}

\item{NextToken}{The pagination token.}

\item{MaxResults}{The maximum number of results to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  Attributes = list(
    list(
      Name = "string",
      AttributeDefinition = list(
        Type = "STRING"|"BINARY"|"BOOLEAN"|"NUMBER"|"DATETIME"|"VARIANT",
        DefaultValue = list(
          StringValue = "string",
          BinaryValue = raw,
          BooleanValue = TRUE|FALSE,
          NumberValue = "string",
          DatetimeValue = as.POSIXct(
            "2015-01-01"
          )
        ),
        IsImmutable = TRUE|FALSE,
        Rules = list(
          list(
            Type = "BINARY_LENGTH"|"NUMBER_COMPARISON"|"STRING_FROM_SET"|"STRING_LENGTH",
            Parameters = list(
              "string"
            )
          )
        )
      ),
      AttributeReference = list(
        TargetFacetName = "string",
        TargetAttributeName = "string"
      ),
      RequiredBehavior = "REQUIRED_ALWAYS"|"NOT_REQUIRED"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves attributes attached to the facet.
}
\section{Request syntax}{
\preformatted{svc$list_facet_attributes(
  SchemaArn = "string",
  Name = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
