# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sts_service.R
NULL

#' Returns a set of temporary security credentials that you can use to
#' access AWS resources that you might not normally have access to
#'
#' Returns a set of temporary security credentials that you can use to
#' access AWS resources that you might not normally have access to. These
#' temporary credentials consist of an access key ID, a secret access key,
#' and a security token. Typically, you use `AssumeRole` within your
#' account or for cross-account access. For a comparison of `AssumeRole`
#' with other API operations that produce temporary credentials, see
#' [Requesting Temporary Security
#' Credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html)
#' and [Comparing the AWS STS API
#' operations](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison)
#' in the *IAM User Guide*.
#' 
#' You cannot use AWS account root user credentials to call `AssumeRole`.
#' You must use credentials for an IAM user or an IAM role to call
#' `AssumeRole`.
#' 
#' For cross-account access, imagine that you own multiple accounts and
#' need to access resources in each account. You could create long-term
#' credentials in each account to access those resources. However, managing
#' all those credentials and remembering which one can access which account
#' can be time consuming. Instead, you can create one set of long-term
#' credentials in one account. Then use temporary security credentials to
#' access all the other accounts by assuming roles in those accounts. For
#' more information about roles, see [IAM
#' Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html)
#' in the *IAM User Guide*.
#' 
#' By default, the temporary security credentials created by `AssumeRole`
#' last for one hour. However, you can use the optional `DurationSeconds`
#' parameter to specify the duration of your session. You can provide a
#' value from 900 seconds (15 minutes) up to the maximum session duration
#' setting for the role. This setting can have a value from 1 hour to 12
#' hours. To learn how to view the maximum value for your role, see [View
#' the Maximum Session Duration Setting for a
#' Role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session)
#' in the *IAM User Guide*. The maximum session duration limit applies when
#' you use the `AssumeRole*` API operations or the `assume-role*` CLI
#' commands. However the limit does not apply when you use those operations
#' to create a console URL. For more information, see [Using IAM
#' Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html)
#' in the *IAM User Guide*.
#' 
#' The temporary security credentials created by `AssumeRole` can be used
#' to make API calls to any AWS service with the following exception: You
#' cannot call the AWS STS `GetFederationToken` or `GetSessionToken` API
#' operations.
#' 
#' (Optional) You can pass inline or managed [session
#' policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' to this operation. You can pass a single JSON policy document to use as
#' an inline session policy. You can also specify up to 10 managed policies
#' to use as managed session policies. The plain text that you use for both
#' inline and managed session policies shouldn\'t exceed 2048 characters.
#' Passing policies to this operation returns new temporary credentials.
#' The resulting session\'s permissions are the intersection of the role\'s
#' identity-based policy and the session policies. You can use the role\'s
#' temporary credentials in subsequent AWS API calls to access resources in
#' the account that owns the role. You cannot use session policies to grant
#' more permissions than those allowed by the identity-based policy of the
#' role that is being assumed. For more information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' 
#' To assume a role from a different account, your AWS account must be
#' trusted by the role. The trust relationship is defined in the role\'s
#' trust policy when the role is created. That trust policy states which
#' accounts are allowed to delegate that access to users in the account.
#' 
#' A user who wants to access a role in a different account must also have
#' permissions that are delegated from the user account administrator. The
#' administrator must attach a policy that allows the user to call
#' `AssumeRole` for the ARN of the role in the other account. If the user
#' is in the same account as the role, then you can do either of the
#' following:
#' 
#' -   Attach a policy to the user (identical to the previous user in a
#'     different account).
#' 
#' -   Add the user as a principal directly in the role\'s trust policy.
#' 
#' In this case, the trust policy acts as an IAM resource-based policy.
#' Users in the same account as the role do not need explicit permission to
#' assume the role. For more information about trust policies and
#' resource-based policies, see [IAM
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html)
#' in the *IAM User Guide*.
#' 
#' **Using MFA with AssumeRole**
#' 
#' (Optional) You can include multi-factor authentication (MFA) information
#' when you call `AssumeRole`. This is useful for cross-account scenarios
#' to ensure that the user that assumes the role has been authenticated
#' with an AWS MFA device. In that scenario, the trust policy of the role
#' being assumed includes a condition that tests for MFA authentication. If
#' the caller does not include valid MFA information, the request to assume
#' the role is denied. The condition in a trust policy that tests for MFA
#' authentication might look like the following example.
#' 
#' `"Condition": \{"Bool": \{"aws:MultiFactorAuthPresent": true\}\}`
#' 
#' For more information, see [Configuring MFA-Protected API
#' Access](https://docs.aws.amazon.com/IAM/latest/UserGuide/MFAProtectedAPI.html)
#' in the *IAM User Guide* guide.
#' 
#' To use MFA with `AssumeRole`, you pass values for the `SerialNumber` and
#' `TokenCode` parameters. The `SerialNumber` value identifies the user\'s
#' hardware or virtual MFA device. The `TokenCode` is the time-based
#' one-time password (TOTP) that the MFA device produces.
#'
#' @usage
#' sts_assume_role(RoleArn, RoleSessionName, PolicyArns, Policy,
#'   DurationSeconds, ExternalId, SerialNumber, TokenCode)
#'
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the role to assume.
#' @param RoleSessionName &#91;required&#93; An identifier for the assumed role session.
#' 
#' Use the role session name to uniquely identify a session when the same
#' role is assumed by different principals or for different reasons. In
#' cross-account scenarios, the role session name is visible to, and can be
#' logged by the account that owns the role. The role session name is also
#' used in the ARN of the assumed role principal. This means that
#' subsequent cross-account API requests that use the temporary security
#' credentials will expose the role session name to the external account in
#' their AWS CloudTrail logs.
#' 
#' The regex used to validate this parameter is a string of characters
#' consisting of upper- and lower-case alphanumeric characters with no
#' spaces. You can also include underscores or any of the following
#' characters: =,.@-
#' @param PolicyArns The Amazon Resource Names (ARNs) of the IAM managed policies that you
#' want to use as managed session policies. The policies must exist in the
#' same account as the role.
#' 
#' This parameter is optional. You can provide up to 10 managed policy
#' ARNs. However, the plain text that you use for both inline and managed
#' session policies shouldn\'t exceed 2048 characters. For more information
#' about ARNs, see [Amazon Resource Names (ARNs) and AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the AWS General Reference.
#' 
#' The characters in this parameter count towards the 2048 character
#' session policy guideline. However, an AWS conversion compresses the
#' session policies into a packed binary format that has a separate limit.
#' This is the enforced limit. The `PackedPolicySize` response element
#' indicates by percentage how close the policy is to the upper size limit.
#' 
#' Passing policies to this operation returns new temporary credentials.
#' The resulting session\'s permissions are the intersection of the role\'s
#' identity-based policy and the session policies. You can use the role\'s
#' temporary credentials in subsequent AWS API calls to access resources in
#' the account that owns the role. You cannot use session policies to grant
#' more permissions than those allowed by the identity-based policy of the
#' role that is being assumed. For more information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' @param Policy An IAM policy in JSON format that you want to use as an inline session
#' policy.
#' 
#' This parameter is optional. Passing policies to this operation returns
#' new temporary credentials. The resulting session\'s permissions are the
#' intersection of the role\'s identity-based policy and the session
#' policies. You can use the role\'s temporary credentials in subsequent
#' AWS API calls to access resources in the account that owns the role. You
#' cannot use session policies to grant more permissions than those allowed
#' by the identity-based policy of the role that is being assumed. For more
#' information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' 
#' The plain text that you use for both inline and managed session policies
#' shouldn\'t exceed 2048 characters. The JSON policy characters can be any
#' ASCII character from the space character to the end of the valid
#' character list (`U+0020` through `U+00FF`). It can also include the tab
#' (`U+0009`), linefeed (`U+000A`), and carriage return (`U+000D`) characters.
#' 
#' The characters in this parameter count towards the 2048 character
#' session policy guideline. However, an AWS conversion compresses the
#' session policies into a packed binary format that has a separate limit.
#' This is the enforced limit. The `PackedPolicySize` response element
#' indicates by percentage how close the policy is to the upper size limit.
#' @param DurationSeconds The duration, in seconds, of the role session. The value can range from
#' 900 seconds (15 minutes) up to the maximum session duration setting for
#' the role. This setting can have a value from 1 hour to 12 hours. If you
#' specify a value higher than this setting, the operation fails. For
#' example, if you specify a session duration of 12 hours, but your
#' administrator set the maximum session duration to 6 hours, your
#' operation fails. To learn how to view the maximum value for your role,
#' see [View the Maximum Session Duration Setting for a
#' Role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session)
#' in the *IAM User Guide*.
#' 
#' By default, the value is set to `3600` seconds.
#' 
#' The `DurationSeconds` parameter is separate from the duration of a
#' console session that you might request using the returned credentials.
#' The request to the federation endpoint for a console sign-in token takes
#' a `SessionDuration` parameter that specifies the maximum length of the
#' console session. For more information, see [Creating a URL that Enables
#' Federated Users to Access the AWS Management
#' Console](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html)
#' in the *IAM User Guide*.
#' @param ExternalId A unique identifier that might be required when you assume a role in
#' another account. If the administrator of the account to which the role
#' belongs provided you with an external ID, then provide that value in the
#' `ExternalId` parameter. This value can be any string, such as a
#' passphrase or account number. A cross-account role is usually set up to
#' trust everyone in an account. Therefore, the administrator of the
#' trusting account might send an external ID to the administrator of the
#' trusted account. That way, only someone with the ID can assume the role,
#' rather than everyone in the account. For more information about the
#' external ID, see [How to Use an External ID When Granting Access to Your
#' AWS Resources to a Third
#' Party](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html)
#' in the *IAM User Guide*.
#' 
#' The regex used to validate this parameter is a string of characters
#' consisting of upper- and lower-case alphanumeric characters with no
#' spaces. You can also include underscores or any of the following
#' characters: =,.@:/-
#' @param SerialNumber The identification number of the MFA device that is associated with the
#' user who is making the `AssumeRole` call. Specify this value if the
#' trust policy of the role being assumed includes a condition that
#' requires MFA authentication. The value is either the serial number for a
#' hardware device (such as `GAHT12345678`) or an Amazon Resource Name
#' (ARN) for a virtual device (such as
#' `arn:aws:iam::123456789012:mfa/user`).
#' 
#' The regex used to validate this parameter is a string of characters
#' consisting of upper- and lower-case alphanumeric characters with no
#' spaces. You can also include underscores or any of the following
#' characters: =,.@-
#' @param TokenCode The value provided by the MFA device, if the trust policy of the role
#' being assumed requires MFA (that is, if the policy includes a condition
#' that tests for MFA). If the role being assumed requires MFA and if the
#' `TokenCode` value is missing or expired, the `AssumeRole` call returns
#' an \"access denied\" error.
#' 
#' The format for this parameter, as described by its regex pattern, is a
#' sequence of six numeric digits.
#'
#' @section Request syntax:
#' ```
#' svc$assume_role(
#'   RoleArn = "string",
#'   RoleSessionName = "string",
#'   PolicyArns = list(
#'     list(
#'       arn = "string"
#'     )
#'   ),
#'   Policy = "string",
#'   DurationSeconds = 123,
#'   ExternalId = "string",
#'   SerialNumber = "string",
#'   TokenCode = "string"
#' )
#' ```
#'
#' @examples
#' # 
#' \donttest{svc$assume_role(
#'   DurationSeconds = 3600L,
#'   ExternalId = "123ABC",
#'   Policy = "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Sid\":\"Stmt1\",\"Effect\":...",
#'   RoleArn = "arn:aws:iam::123456789012:role/demo",
#'   RoleSessionName = "Bob"
#' )}
#'
#' @keywords internal
#'
#' @rdname sts_assume_role
sts_assume_role <- function(RoleArn, RoleSessionName, PolicyArns = NULL, Policy = NULL, DurationSeconds = NULL, ExternalId = NULL, SerialNumber = NULL, TokenCode = NULL) {
  op <- new_operation(
    name = "AssumeRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sts$assume_role_input(RoleArn = RoleArn, RoleSessionName = RoleSessionName, PolicyArns = PolicyArns, Policy = Policy, DurationSeconds = DurationSeconds, ExternalId = ExternalId, SerialNumber = SerialNumber, TokenCode = TokenCode)
  output <- .sts$assume_role_output()
  config <- get_config()
  svc <- .sts$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$assume_role <- sts_assume_role

#' Returns a set of temporary security credentials for users who have been
#' authenticated via a SAML authentication response
#'
#' Returns a set of temporary security credentials for users who have been
#' authenticated via a SAML authentication response. This operation
#' provides a mechanism for tying an enterprise identity store or directory
#' to role-based AWS access without user-specific credentials or
#' configuration. For a comparison of `AssumeRoleWithSAML` with the other
#' API operations that produce temporary credentials, see [Requesting
#' Temporary Security
#' Credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html)
#' and [Comparing the AWS STS API
#' operations](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison)
#' in the *IAM User Guide*.
#' 
#' The temporary security credentials returned by this operation consist of
#' an access key ID, a secret access key, and a security token.
#' Applications can use these temporary security credentials to sign calls
#' to AWS services.
#' 
#' By default, the temporary security credentials created by
#' `AssumeRoleWithSAML` last for one hour. However, you can use the
#' optional `DurationSeconds` parameter to specify the duration of your
#' session. Your role session lasts for the duration that you specify, or
#' until the time specified in the SAML authentication response\'s
#' `SessionNotOnOrAfter` value, whichever is shorter. You can provide a
#' `DurationSeconds` value from 900 seconds (15 minutes) up to the maximum
#' session duration setting for the role. This setting can have a value
#' from 1 hour to 12 hours. To learn how to view the maximum value for your
#' role, see [View the Maximum Session Duration Setting for a
#' Role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session)
#' in the *IAM User Guide*. The maximum session duration limit applies when
#' you use the `AssumeRole*` API operations or the `assume-role*` CLI
#' commands. However the limit does not apply when you use those operations
#' to create a console URL. For more information, see [Using IAM
#' Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html)
#' in the *IAM User Guide*.
#' 
#' The temporary security credentials created by `AssumeRoleWithSAML` can
#' be used to make API calls to any AWS service with the following
#' exception: you cannot call the STS `GetFederationToken` or
#' `GetSessionToken` API operations.
#' 
#' (Optional) You can pass inline or managed [session
#' policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' to this operation. You can pass a single JSON policy document to use as
#' an inline session policy. You can also specify up to 10 managed policies
#' to use as managed session policies. The plain text that you use for both
#' inline and managed session policies shouldn\'t exceed 2048 characters.
#' Passing policies to this operation returns new temporary credentials.
#' The resulting session\'s permissions are the intersection of the role\'s
#' identity-based policy and the session policies. You can use the role\'s
#' temporary credentials in subsequent AWS API calls to access resources in
#' the account that owns the role. You cannot use session policies to grant
#' more permissions than those allowed by the identity-based policy of the
#' role that is being assumed. For more information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' 
#' Before your application can call `AssumeRoleWithSAML`, you must
#' configure your SAML identity provider (IdP) to issue the claims required
#' by AWS. Additionally, you must use AWS Identity and Access Management
#' (IAM) to create a SAML provider entity in your AWS account that
#' represents your identity provider. You must also create an IAM role that
#' specifies this SAML provider in its trust policy.
#' 
#' Calling `AssumeRoleWithSAML` does not require the use of AWS security
#' credentials. The identity of the caller is validated by using keys in
#' the metadata document that is uploaded for the SAML provider entity for
#' your identity provider.
#' 
#' Calling `AssumeRoleWithSAML` can result in an entry in your AWS
#' CloudTrail logs. The entry includes the value in the `NameID` element of
#' the SAML assertion. We recommend that you use a `NameIDType` that is not
#' associated with any personally identifiable information (PII). For
#' example, you could instead use the Persistent Identifier
#' (`urn:oasis:names:tc:SAML:2.0:nameid-format:persistent`).
#' 
#' For more information, see the following resources:
#' 
#' -   [About SAML 2.0-based
#'     Federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html)
#'     in the *IAM User Guide*.
#' 
#' -   [Creating SAML Identity
#'     Providers](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_saml.html)
#'     in the *IAM User Guide*.
#' 
#' -   [Configuring a Relying Party and
#'     Claims](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_saml_relying-party.html)
#'     in the *IAM User Guide*.
#' 
#' -   [Creating a Role for SAML 2.0
#'     Federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-idp_saml.html)
#'     in the *IAM User Guide*.
#'
#' @usage
#' sts_assume_role_with_saml(RoleArn, PrincipalArn, SAMLAssertion,
#'   PolicyArns, Policy, DurationSeconds)
#'
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the role that the caller is assuming.
#' @param PrincipalArn &#91;required&#93; The Amazon Resource Name (ARN) of the SAML provider in IAM that
#' describes the IdP.
#' @param SAMLAssertion &#91;required&#93; The base-64 encoded SAML authentication response provided by the IdP.
#' 
#' For more information, see [Configuring a Relying Party and Adding
#' Claims](https://docs.aws.amazon.com/IAM/latest/UserGuide/create-role-saml-IdP-tasks.html)
#' in the *IAM User Guide*.
#' @param PolicyArns The Amazon Resource Names (ARNs) of the IAM managed policies that you
#' want to use as managed session policies. The policies must exist in the
#' same account as the role.
#' 
#' This parameter is optional. You can provide up to 10 managed policy
#' ARNs. However, the plain text that you use for both inline and managed
#' session policies shouldn\'t exceed 2048 characters. For more information
#' about ARNs, see [Amazon Resource Names (ARNs) and AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the AWS General Reference.
#' 
#' The characters in this parameter count towards the 2048 character
#' session policy guideline. However, an AWS conversion compresses the
#' session policies into a packed binary format that has a separate limit.
#' This is the enforced limit. The `PackedPolicySize` response element
#' indicates by percentage how close the policy is to the upper size limit.
#' 
#' Passing policies to this operation returns new temporary credentials.
#' The resulting session\'s permissions are the intersection of the role\'s
#' identity-based policy and the session policies. You can use the role\'s
#' temporary credentials in subsequent AWS API calls to access resources in
#' the account that owns the role. You cannot use session policies to grant
#' more permissions than those allowed by the identity-based policy of the
#' role that is being assumed. For more information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' @param Policy An IAM policy in JSON format that you want to use as an inline session
#' policy.
#' 
#' This parameter is optional. Passing policies to this operation returns
#' new temporary credentials. The resulting session\'s permissions are the
#' intersection of the role\'s identity-based policy and the session
#' policies. You can use the role\'s temporary credentials in subsequent
#' AWS API calls to access resources in the account that owns the role. You
#' cannot use session policies to grant more permissions than those allowed
#' by the identity-based policy of the role that is being assumed. For more
#' information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' 
#' The plain text that you use for both inline and managed session policies
#' shouldn\'t exceed 2048 characters. The JSON policy characters can be any
#' ASCII character from the space character to the end of the valid
#' character list (`U+0020` through `U+00FF`). It can also include the tab
#' (`U+0009`), linefeed (`U+000A`), and carriage return (`U+000D`) characters.
#' 
#' The characters in this parameter count towards the 2048 character
#' session policy guideline. However, an AWS conversion compresses the
#' session policies into a packed binary format that has a separate limit.
#' This is the enforced limit. The `PackedPolicySize` response element
#' indicates by percentage how close the policy is to the upper size limit.
#' @param DurationSeconds The duration, in seconds, of the role session. Your role session lasts
#' for the duration that you specify for the `DurationSeconds` parameter,
#' or until the time specified in the SAML authentication response\'s
#' `SessionNotOnOrAfter` value, whichever is shorter. You can provide a
#' `DurationSeconds` value from 900 seconds (15 minutes) up to the maximum
#' session duration setting for the role. This setting can have a value
#' from 1 hour to 12 hours. If you specify a value higher than this
#' setting, the operation fails. For example, if you specify a session
#' duration of 12 hours, but your administrator set the maximum session
#' duration to 6 hours, your operation fails. To learn how to view the
#' maximum value for your role, see [View the Maximum Session Duration
#' Setting for a
#' Role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session)
#' in the *IAM User Guide*.
#' 
#' By default, the value is set to `3600` seconds.
#' 
#' The `DurationSeconds` parameter is separate from the duration of a
#' console session that you might request using the returned credentials.
#' The request to the federation endpoint for a console sign-in token takes
#' a `SessionDuration` parameter that specifies the maximum length of the
#' console session. For more information, see [Creating a URL that Enables
#' Federated Users to Access the AWS Management
#' Console](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html)
#' in the *IAM User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$assume_role_with_saml(
#'   RoleArn = "string",
#'   PrincipalArn = "string",
#'   SAMLAssertion = "string",
#'   PolicyArns = list(
#'     list(
#'       arn = "string"
#'     )
#'   ),
#'   Policy = "string",
#'   DurationSeconds = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sts_assume_role_with_saml
sts_assume_role_with_saml <- function(RoleArn, PrincipalArn, SAMLAssertion, PolicyArns = NULL, Policy = NULL, DurationSeconds = NULL) {
  op <- new_operation(
    name = "AssumeRoleWithSAML",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sts$assume_role_with_saml_input(RoleArn = RoleArn, PrincipalArn = PrincipalArn, SAMLAssertion = SAMLAssertion, PolicyArns = PolicyArns, Policy = Policy, DurationSeconds = DurationSeconds)
  output <- .sts$assume_role_with_saml_output()
  config <- get_config()
  svc <- .sts$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$assume_role_with_saml <- sts_assume_role_with_saml

#' Returns a set of temporary security credentials for users who have been
#' authenticated in a mobile or web application with a web identity
#' provider
#'
#' Returns a set of temporary security credentials for users who have been
#' authenticated in a mobile or web application with a web identity
#' provider. Example providers include Amazon Cognito, Login with Amazon,
#' Facebook, Google, or any OpenID Connect-compatible identity provider.
#' 
#' For mobile applications, we recommend that you use Amazon Cognito. You
#' can use Amazon Cognito with the [AWS SDK for iOS Developer
#' Guide](http://aws.amazon.com/sdkforios/) and the [AWS SDK for Android
#' Developer Guide](http://aws.amazon.com/sdkforandroid/) to uniquely
#' identify a user. You can also supply the user with a consistent identity
#' throughout the lifetime of an application.
#' 
#' To learn more about Amazon Cognito, see [Amazon Cognito
#' Overview](https://docs.aws.amazon.com/mobile/sdkforandroid/developerguide/cognito-auth.html#d0e840)
#' in *AWS SDK for Android Developer Guide* and [Amazon Cognito
#' Overview](https://docs.aws.amazon.com/mobile/sdkforios/developerguide/cognito-auth.html#d0e664)
#' in the *AWS SDK for iOS Developer Guide*.
#' 
#' Calling `AssumeRoleWithWebIdentity` does not require the use of AWS
#' security credentials. Therefore, you can distribute an application (for
#' example, on mobile devices) that requests temporary security credentials
#' without including long-term AWS credentials in the application. You also
#' don\'t need to deploy server-based proxy services that use long-term AWS
#' credentials. Instead, the identity of the caller is validated by using a
#' token from the web identity provider. For a comparison of
#' `AssumeRoleWithWebIdentity` with the other API operations that produce
#' temporary credentials, see [Requesting Temporary Security
#' Credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html)
#' and [Comparing the AWS STS API
#' operations](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison)
#' in the *IAM User Guide*.
#' 
#' The temporary security credentials returned by this API consist of an
#' access key ID, a secret access key, and a security token. Applications
#' can use these temporary security credentials to sign calls to AWS
#' service API operations.
#' 
#' By default, the temporary security credentials created by
#' `AssumeRoleWithWebIdentity` last for one hour. However, you can use the
#' optional `DurationSeconds` parameter to specify the duration of your
#' session. You can provide a value from 900 seconds (15 minutes) up to the
#' maximum session duration setting for the role. This setting can have a
#' value from 1 hour to 12 hours. To learn how to view the maximum value
#' for your role, see [View the Maximum Session Duration Setting for a
#' Role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session)
#' in the *IAM User Guide*. The maximum session duration limit applies when
#' you use the `AssumeRole*` API operations or the `assume-role*` CLI
#' commands. However the limit does not apply when you use those operations
#' to create a console URL. For more information, see [Using IAM
#' Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html)
#' in the *IAM User Guide*.
#' 
#' The temporary security credentials created by
#' `AssumeRoleWithWebIdentity` can be used to make API calls to any AWS
#' service with the following exception: you cannot call the STS
#' `GetFederationToken` or `GetSessionToken` API operations.
#' 
#' (Optional) You can pass inline or managed [session
#' policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' to this operation. You can pass a single JSON policy document to use as
#' an inline session policy. You can also specify up to 10 managed policies
#' to use as managed session policies. The plain text that you use for both
#' inline and managed session policies shouldn\'t exceed 2048 characters.
#' Passing policies to this operation returns new temporary credentials.
#' The resulting session\'s permissions are the intersection of the role\'s
#' identity-based policy and the session policies. You can use the role\'s
#' temporary credentials in subsequent AWS API calls to access resources in
#' the account that owns the role. You cannot use session policies to grant
#' more permissions than those allowed by the identity-based policy of the
#' role that is being assumed. For more information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' 
#' Before your application can call `AssumeRoleWithWebIdentity`, you must
#' have an identity token from a supported identity provider and create a
#' role that the application can assume. The role that your application
#' assumes must trust the identity provider that is associated with the
#' identity token. In other words, the identity provider must be specified
#' in the role\'s trust policy.
#' 
#' Calling `AssumeRoleWithWebIdentity` can result in an entry in your AWS
#' CloudTrail logs. The entry includes the
#' [Subject](http://openid.net/specs/openid-connect-core-1_0.html#Claims)
#' of the provided Web Identity Token. We recommend that you avoid using
#' any personally identifiable information (PII) in this field. For
#' example, you could instead use a GUID or a pairwise identifier, as
#' [suggested in the OIDC
#' specification](http://openid.net/specs/openid-connect-core-1_0.html#SubjectIDTypes).
#' 
#' For more information about how to use web identity federation and the
#' `AssumeRoleWithWebIdentity` API, see the following resources:
#' 
#' -   [Using Web Identity Federation API Operations for Mobile
#'     Apps](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc_manual.html)
#'     and [Federation Through a Web-based Identity
#'     Provider](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#api_assumerolewithwebidentity).
#' 
#' -   [Web Identity Federation
#'     Playground](https://web-identity-federation-playground.s3.amazonaws.com/index.html).
#'     Walk through the process of authenticating through Login with
#'     Amazon, Facebook, or Google, getting temporary security credentials,
#'     and then using those credentials to make a request to AWS.
#' 
#' -   [AWS SDK for iOS Developer Guide](http://aws.amazon.com/sdkforios/)
#'     and [AWS SDK for Android Developer
#'     Guide](http://aws.amazon.com/sdkforandroid/). These toolkits contain
#'     sample apps that show how to invoke the identity providers, and then
#'     how to use the information from these providers to get and use
#'     temporary security credentials.
#' 
#' -   [Web Identity Federation with Mobile
#'     Applications](http://aws.amazon.com/articles/web-identity-federation-with-mobile-applications).
#'     This article discusses web identity federation and shows an example
#'     of how to use web identity federation to get access to content in
#'     Amazon S3.
#'
#' @usage
#' sts_assume_role_with_web_identity(RoleArn, RoleSessionName,
#'   WebIdentityToken, ProviderId, PolicyArns, Policy, DurationSeconds)
#'
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the role that the caller is assuming.
#' @param RoleSessionName &#91;required&#93; An identifier for the assumed role session. Typically, you pass the name
#' or identifier that is associated with the user who is using your
#' application. That way, the temporary security credentials that your
#' application will use are associated with that user. This session name is
#' included as part of the ARN and assumed role ID in the `AssumedRoleUser`
#' response element.
#' 
#' The regex used to validate this parameter is a string of characters
#' consisting of upper- and lower-case alphanumeric characters with no
#' spaces. You can also include underscores or any of the following
#' characters: =,.@-
#' @param WebIdentityToken &#91;required&#93; The OAuth 2.0 access token or OpenID Connect ID token that is provided
#' by the identity provider. Your application must get this token by
#' authenticating the user who is using your application with a web
#' identity provider before the application makes an
#' `AssumeRoleWithWebIdentity` call.
#' @param ProviderId The fully qualified host component of the domain name of the identity
#' provider.
#' 
#' Specify this value only for OAuth 2.0 access tokens. Currently
#' `www.amazon.com` and `graph.facebook.com` are the only supported
#' identity providers for OAuth 2.0 access tokens. Do not include URL
#' schemes and port numbers.
#' 
#' Do not specify this value for OpenID Connect ID tokens.
#' @param PolicyArns The Amazon Resource Names (ARNs) of the IAM managed policies that you
#' want to use as managed session policies. The policies must exist in the
#' same account as the role.
#' 
#' This parameter is optional. You can provide up to 10 managed policy
#' ARNs. However, the plain text that you use for both inline and managed
#' session policies shouldn\'t exceed 2048 characters. For more information
#' about ARNs, see [Amazon Resource Names (ARNs) and AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the AWS General Reference.
#' 
#' The characters in this parameter count towards the 2048 character
#' session policy guideline. However, an AWS conversion compresses the
#' session policies into a packed binary format that has a separate limit.
#' This is the enforced limit. The `PackedPolicySize` response element
#' indicates by percentage how close the policy is to the upper size limit.
#' 
#' Passing policies to this operation returns new temporary credentials.
#' The resulting session\'s permissions are the intersection of the role\'s
#' identity-based policy and the session policies. You can use the role\'s
#' temporary credentials in subsequent AWS API calls to access resources in
#' the account that owns the role. You cannot use session policies to grant
#' more permissions than those allowed by the identity-based policy of the
#' role that is being assumed. For more information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' @param Policy An IAM policy in JSON format that you want to use as an inline session
#' policy.
#' 
#' This parameter is optional. Passing policies to this operation returns
#' new temporary credentials. The resulting session\'s permissions are the
#' intersection of the role\'s identity-based policy and the session
#' policies. You can use the role\'s temporary credentials in subsequent
#' AWS API calls to access resources in the account that owns the role. You
#' cannot use session policies to grant more permissions than those allowed
#' by the identity-based policy of the role that is being assumed. For more
#' information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' 
#' The plain text that you use for both inline and managed session policies
#' shouldn\'t exceed 2048 characters. The JSON policy characters can be any
#' ASCII character from the space character to the end of the valid
#' character list (`U+0020` through `U+00FF`). It can also include the tab
#' (`U+0009`), linefeed (`U+000A`), and carriage return (`U+000D`) characters.
#' 
#' The characters in this parameter count towards the 2048 character
#' session policy guideline. However, an AWS conversion compresses the
#' session policies into a packed binary format that has a separate limit.
#' This is the enforced limit. The `PackedPolicySize` response element
#' indicates by percentage how close the policy is to the upper size limit.
#' @param DurationSeconds The duration, in seconds, of the role session. The value can range from
#' 900 seconds (15 minutes) up to the maximum session duration setting for
#' the role. This setting can have a value from 1 hour to 12 hours. If you
#' specify a value higher than this setting, the operation fails. For
#' example, if you specify a session duration of 12 hours, but your
#' administrator set the maximum session duration to 6 hours, your
#' operation fails. To learn how to view the maximum value for your role,
#' see [View the Maximum Session Duration Setting for a
#' Role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session)
#' in the *IAM User Guide*.
#' 
#' By default, the value is set to `3600` seconds.
#' 
#' The `DurationSeconds` parameter is separate from the duration of a
#' console session that you might request using the returned credentials.
#' The request to the federation endpoint for a console sign-in token takes
#' a `SessionDuration` parameter that specifies the maximum length of the
#' console session. For more information, see [Creating a URL that Enables
#' Federated Users to Access the AWS Management
#' Console](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html)
#' in the *IAM User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$assume_role_with_web_identity(
#'   RoleArn = "string",
#'   RoleSessionName = "string",
#'   WebIdentityToken = "string",
#'   ProviderId = "string",
#'   PolicyArns = list(
#'     list(
#'       arn = "string"
#'     )
#'   ),
#'   Policy = "string",
#'   DurationSeconds = 123
#' )
#' ```
#'
#' @examples
#' # 
#' \donttest{svc$assume_role_with_web_identity(
#'   DurationSeconds = 3600L,
#'   Policy = "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Sid\":\"Stmt1\",\"Effect\":...",
#'   ProviderId = "www.amazon.com",
#'   RoleArn = "arn:aws:iam::123456789012:role/FederatedWebIdentityRole",
#'   RoleSessionName = "app1",
#'   WebIdentityToken = "Atza%7CIQEBLjAsAhRFiXuWpUXuRvQ9PZL3GMFcYevydwIUFAHZwXZXXXXXXXXJnrulxKD..."
#' )}
#'
#' @keywords internal
#'
#' @rdname sts_assume_role_with_web_identity
sts_assume_role_with_web_identity <- function(RoleArn, RoleSessionName, WebIdentityToken, ProviderId = NULL, PolicyArns = NULL, Policy = NULL, DurationSeconds = NULL) {
  op <- new_operation(
    name = "AssumeRoleWithWebIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sts$assume_role_with_web_identity_input(RoleArn = RoleArn, RoleSessionName = RoleSessionName, WebIdentityToken = WebIdentityToken, ProviderId = ProviderId, PolicyArns = PolicyArns, Policy = Policy, DurationSeconds = DurationSeconds)
  output <- .sts$assume_role_with_web_identity_output()
  config <- get_config()
  svc <- .sts$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$assume_role_with_web_identity <- sts_assume_role_with_web_identity

#' Decodes additional information about the authorization status of a
#' request from an encoded message returned in response to an AWS request
#'
#' Decodes additional information about the authorization status of a
#' request from an encoded message returned in response to an AWS request.
#' 
#' For example, if a user is not authorized to perform an operation that he
#' or she has requested, the request returns a
#' `Client.UnauthorizedOperation` response (an HTTP 403 response). Some AWS
#' operations additionally return an encoded message that can provide
#' details about this authorization failure.
#' 
#' Only certain AWS operations return an encoded authorization message. The
#' documentation for an individual operation indicates whether that
#' operation returns an encoded message in addition to returning an HTTP
#' code.
#' 
#' The message is encoded because the details of the authorization status
#' can constitute privileged information that the user who requested the
#' operation should not see. To decode an authorization status message, a
#' user must be granted permissions via an IAM policy to request the
#' `DecodeAuthorizationMessage` (`sts:DecodeAuthorizationMessage`) action.
#' 
#' The decoded message includes the following type of information:
#' 
#' -   Whether the request was denied due to an explicit deny or due to the
#'     absence of an explicit allow. For more information, see [Determining
#'     Whether a Request is Allowed or
#'     Denied](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-denyallow)
#'     in the *IAM User Guide*.
#' 
#' -   The principal who made the request.
#' 
#' -   The requested action.
#' 
#' -   The requested resource.
#' 
#' -   The values of condition keys in the context of the user\'s request.
#'
#' @usage
#' sts_decode_authorization_message(EncodedMessage)
#'
#' @param EncodedMessage &#91;required&#93; The encoded message that was returned with the response.
#'
#' @section Request syntax:
#' ```
#' svc$decode_authorization_message(
#'   EncodedMessage = "string"
#' )
#' ```
#'
#' @examples
#' # 
#' \donttest{svc$decode_authorization_message(
#'   EncodedMessage = "<encoded-message>"
#' )}
#'
#' @keywords internal
#'
#' @rdname sts_decode_authorization_message
sts_decode_authorization_message <- function(EncodedMessage) {
  op <- new_operation(
    name = "DecodeAuthorizationMessage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sts$decode_authorization_message_input(EncodedMessage = EncodedMessage)
  output <- .sts$decode_authorization_message_output()
  config <- get_config()
  svc <- .sts$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$decode_authorization_message <- sts_decode_authorization_message

#' Returns details about the IAM identity whose credentials are used to
#' call the API
#'
#' Returns details about the IAM identity whose credentials are used to
#' call the API.
#'
#' @usage
#' sts_get_caller_identity()
#'
#' @section Request syntax:
#' ```
#' svc$get_caller_identity()
#' ```
#'
#' @examples
#' # This example shows a request and response made with the credentials for
#' # a user named Alice in the AWS account 123456789012.
#' \donttest{svc$get_caller_identity()}
#' 
#' # This example shows a request and response made with temporary
#' # credentials created by AssumeRole. The name of the assumed role is
#' # my-role-name, and the RoleSessionName is set to my-role-session-name.
#' \donttest{svc$get_caller_identity()}
#' 
#' # This example shows a request and response made with temporary
#' # credentials created by using GetFederationToken. The Name parameter is
#' # set to my-federated-user-name.
#' \donttest{svc$get_caller_identity()}
#'
#' @keywords internal
#'
#' @rdname sts_get_caller_identity
sts_get_caller_identity <- function() {
  op <- new_operation(
    name = "GetCallerIdentity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sts$get_caller_identity_input()
  output <- .sts$get_caller_identity_output()
  config <- get_config()
  svc <- .sts$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$get_caller_identity <- sts_get_caller_identity

#' Returns a set of temporary security credentials (consisting of an access
#' key ID, a secret access key, and a security token) for a federated user
#'
#' Returns a set of temporary security credentials (consisting of an access
#' key ID, a secret access key, and a security token) for a federated user.
#' A typical use is in a proxy application that gets temporary security
#' credentials on behalf of distributed applications inside a corporate
#' network. You must call the `GetFederationToken` operation using the
#' long-term security credentials of an IAM user. As a result, this call is
#' appropriate in contexts where those credentials can be safely stored,
#' usually in a server-based application. For a comparison of
#' `GetFederationToken` with the other API operations that produce
#' temporary credentials, see [Requesting Temporary Security
#' Credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html)
#' and [Comparing the AWS STS API
#' operations](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison)
#' in the *IAM User Guide*.
#' 
#' You can create a mobile-based or browser-based app that can authenticate
#' users using a web identity provider like Login with Amazon, Facebook,
#' Google, or an OpenID Connect-compatible identity provider. In this case,
#' we recommend that you use [Amazon
#' Cognito](http://aws.amazon.com/cognito/) or `AssumeRoleWithWebIdentity`.
#' For more information, see [Federation Through a Web-based Identity
#' Provider](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#api_assumerolewithwebidentity).
#' 
#' You can also call `GetFederationToken` using the security credentials of
#' an AWS account root user, but we do not recommend it. Instead, we
#' recommend that you create an IAM user for the purpose of the proxy
#' application. Then attach a policy to the IAM user that limits federated
#' users to only the actions and resources that they need to access. For
#' more information, see [IAM Best
#' Practices](https://docs.aws.amazon.com/IAM/latest/UserGuide/best-practices.html)
#' in the *IAM User Guide*.
#' 
#' The temporary credentials are valid for the specified duration, from 900
#' seconds (15 minutes) up to a maximum of 129,600 seconds (36 hours). The
#' default is 43,200 seconds (12 hours). Temporary credentials that are
#' obtained by using AWS account root user credentials have a maximum
#' duration of 3,600 seconds (1 hour).
#' 
#' The temporary security credentials created by `GetFederationToken` can
#' be used to make API calls to any AWS service with the following
#' exceptions:
#' 
#' -   You cannot use these credentials to call any IAM API operations.
#' 
#' -   You cannot call any STS API operations except `GetCallerIdentity`.
#' 
#' **Permissions**
#' 
#' You must pass an inline or managed [session
#' policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' to this operation. You can pass a single JSON policy document to use as
#' an inline session policy. You can also specify up to 10 managed policies
#' to use as managed session policies. The plain text that you use for both
#' inline and managed session policies shouldn\'t exceed 2048 characters.
#' 
#' Though the session policy parameters are optional, if you do not pass a
#' policy, then the resulting federated user session has no permissions.
#' The only exception is when the credentials are used to access a resource
#' that has a resource-based policy that specifically references the
#' federated user session in the `Principal` element of the policy. When
#' you pass session policies, the session permissions are the intersection
#' of the IAM user policies and the session policies that you pass. This
#' gives you a way to further restrict the permissions for a federated
#' user. You cannot use session policies to grant more permissions than
#' those that are defined in the permissions policy of the IAM user. For
#' more information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*. For information about using
#' `GetFederationToken` to create temporary security credentials, see
#' [GetFederationToken---Federation Through a Custom Identity
#' Broker](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#api_getfederationtoken).
#'
#' @usage
#' sts_get_federation_token(Name, Policy, PolicyArns, DurationSeconds)
#'
#' @param Name &#91;required&#93; The name of the federated user. The name is used as an identifier for
#' the temporary security credentials (such as `Bob`). For example, you can
#' reference the federated user name in a resource-based policy, such as in
#' an Amazon S3 bucket policy.
#' 
#' The regex used to validate this parameter is a string of characters
#' consisting of upper- and lower-case alphanumeric characters with no
#' spaces. You can also include underscores or any of the following
#' characters: =,.@-
#' @param Policy An IAM policy in JSON format that you want to use as an inline session
#' policy.
#' 
#' You must pass an inline or managed [session
#' policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' to this operation. You can pass a single JSON policy document to use as
#' an inline session policy. You can also specify up to 10 managed policies
#' to use as managed session policies.
#' 
#' This parameter is optional. However, if you do not pass any session
#' policies, then the resulting federated user session has no permissions.
#' The only exception is when the credentials are used to access a resource
#' that has a resource-based policy that specifically references the
#' federated user session in the `Principal` element of the policy.
#' 
#' When you pass session policies, the session permissions are the
#' intersection of the IAM user policies and the session policies that you
#' pass. This gives you a way to further restrict the permissions for a
#' federated user. You cannot use session policies to grant more
#' permissions than those that are defined in the permissions policy of the
#' IAM user. For more information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' 
#' The plain text that you use for both inline and managed session policies
#' shouldn\'t exceed 2048 characters. The JSON policy characters can be any
#' ASCII character from the space character to the end of the valid
#' character list (`U+0020` through `U+00FF`). It can also include the tab
#' (`U+0009`), linefeed (`U+000A`), and carriage return (`U+000D`) characters.
#' 
#' The characters in this parameter count towards the 2048 character
#' session policy guideline. However, an AWS conversion compresses the
#' session policies into a packed binary format that has a separate limit.
#' This is the enforced limit. The `PackedPolicySize` response element
#' indicates by percentage how close the policy is to the upper size limit.
#' @param PolicyArns The Amazon Resource Names (ARNs) of the IAM managed policies that you
#' want to use as a managed session policy. The policies must exist in the
#' same account as the IAM user that is requesting federated access.
#' 
#' You must pass an inline or managed [session
#' policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' to this operation. You can pass a single JSON policy document to use as
#' an inline session policy. You can also specify up to 10 managed policies
#' to use as managed session policies. The plain text that you use for both
#' inline and managed session policies shouldn\'t exceed 2048 characters.
#' You can provide up to 10 managed policy ARNs. For more information about
#' ARNs, see [Amazon Resource Names (ARNs) and AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' in the AWS General Reference.
#' 
#' This parameter is optional. However, if you do not pass any session
#' policies, then the resulting federated user session has no permissions.
#' The only exception is when the credentials are used to access a resource
#' that has a resource-based policy that specifically references the
#' federated user session in the `Principal` element of the policy.
#' 
#' When you pass session policies, the session permissions are the
#' intersection of the IAM user policies and the session policies that you
#' pass. This gives you a way to further restrict the permissions for a
#' federated user. You cannot use session policies to grant more
#' permissions than those that are defined in the permissions policy of the
#' IAM user. For more information, see [Session
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session)
#' in the *IAM User Guide*.
#' 
#' The characters in this parameter count towards the 2048 character
#' session policy guideline. However, an AWS conversion compresses the
#' session policies into a packed binary format that has a separate limit.
#' This is the enforced limit. The `PackedPolicySize` response element
#' indicates by percentage how close the policy is to the upper size limit.
#' @param DurationSeconds The duration, in seconds, that the session should last. Acceptable
#' durations for federation sessions range from 900 seconds (15 minutes) to
#' 129,600 seconds (36 hours), with 43,200 seconds (12 hours) as the
#' default. Sessions obtained using AWS account root user credentials are
#' restricted to a maximum of 3,600 seconds (one hour). If the specified
#' duration is longer than one hour, the session obtained by using root
#' user credentials defaults to one hour.
#'
#' @section Request syntax:
#' ```
#' svc$get_federation_token(
#'   Name = "string",
#'   Policy = "string",
#'   PolicyArns = list(
#'     list(
#'       arn = "string"
#'     )
#'   ),
#'   DurationSeconds = 123
#' )
#' ```
#'
#' @examples
#' # 
#' \donttest{svc$get_federation_token(
#'   DurationSeconds = 3600L,
#'   Name = "Bob",
#'   Policy = "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Sid\":\"Stmt1\",\"Effect\":..."
#' )}
#'
#' @keywords internal
#'
#' @rdname sts_get_federation_token
sts_get_federation_token <- function(Name, Policy = NULL, PolicyArns = NULL, DurationSeconds = NULL) {
  op <- new_operation(
    name = "GetFederationToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sts$get_federation_token_input(Name = Name, Policy = Policy, PolicyArns = PolicyArns, DurationSeconds = DurationSeconds)
  output <- .sts$get_federation_token_output()
  config <- get_config()
  svc <- .sts$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$get_federation_token <- sts_get_federation_token

#' Returns a set of temporary credentials for an AWS account or IAM user
#'
#' Returns a set of temporary credentials for an AWS account or IAM user.
#' The credentials consist of an access key ID, a secret access key, and a
#' security token. Typically, you use `GetSessionToken` if you want to use
#' MFA to protect programmatic calls to specific AWS API operations like
#' Amazon EC2 `StopInstances`. MFA-enabled IAM users would need to call
#' `GetSessionToken` and submit an MFA code that is associated with their
#' MFA device. Using the temporary security credentials that are returned
#' from the call, IAM users can then make programmatic calls to API
#' operations that require MFA authentication. If you do not supply a
#' correct MFA code, then the API returns an access denied error. For a
#' comparison of `GetSessionToken` with the other API operations that
#' produce temporary credentials, see [Requesting Temporary Security
#' Credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html)
#' and [Comparing the AWS STS API
#' operations](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison)
#' in the *IAM User Guide*.
#' 
#' The `GetSessionToken` operation must be called by using the long-term
#' AWS security credentials of the AWS account root user or an IAM user.
#' Credentials that are created by IAM users are valid for the duration
#' that you specify. This duration can range from 900 seconds (15 minutes)
#' up to a maximum of 129,600 seconds (36 hours), with a default of 43,200
#' seconds (12 hours). Credentials based on account credentials can range
#' from 900 seconds (15 minutes) up to 3,600 seconds (1 hour), with a
#' default of 1 hour.
#' 
#' The temporary security credentials created by `GetSessionToken` can be
#' used to make API calls to any AWS service with the following exceptions:
#' 
#' -   You cannot call any IAM API operations unless MFA authentication
#'     information is included in the request.
#' 
#' -   You cannot call any STS API *except* `AssumeRole` or
#'     `GetCallerIdentity`.
#' 
#' We recommend that you do not call `GetSessionToken` with AWS account
#' root user credentials. Instead, follow our [best
#' practices](https://docs.aws.amazon.com/IAM/latest/UserGuide/best-practices.html#create-iam-users)
#' by creating one or more IAM users, giving them the necessary
#' permissions, and using IAM users for everyday interaction with AWS.
#' 
#' The credentials that are returned by `GetSessionToken` are based on
#' permissions associated with the user whose credentials were used to call
#' the operation. If `GetSessionToken` is called using AWS account root
#' user credentials, the temporary credentials have root user permissions.
#' Similarly, if `GetSessionToken` is called using the credentials of an
#' IAM user, the temporary credentials have the same permissions as the IAM
#' user.
#' 
#' For more information about using `GetSessionToken` to create temporary
#' credentials, go to [Temporary Credentials for Users in Untrusted
#' Environments](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#api_getsessiontoken)
#' in the *IAM User Guide*.
#'
#' @usage
#' sts_get_session_token(DurationSeconds, SerialNumber, TokenCode)
#'
#' @param DurationSeconds The duration, in seconds, that the credentials should remain valid.
#' Acceptable durations for IAM user sessions range from 900 seconds (15
#' minutes) to 129,600 seconds (36 hours), with 43,200 seconds (12 hours)
#' as the default. Sessions for AWS account owners are restricted to a
#' maximum of 3,600 seconds (one hour). If the duration is longer than one
#' hour, the session for AWS account owners defaults to one hour.
#' @param SerialNumber The identification number of the MFA device that is associated with the
#' IAM user who is making the `GetSessionToken` call. Specify this value if
#' the IAM user has a policy that requires MFA authentication. The value is
#' either the serial number for a hardware device (such as `GAHT12345678`)
#' or an Amazon Resource Name (ARN) for a virtual device (such as
#' `arn:aws:iam::123456789012:mfa/user`). You can find the device for an
#' IAM user by going to the AWS Management Console and viewing the user\'s
#' security credentials.
#' 
#' The regex used to validate this parameter is a string of characters
#' consisting of upper- and lower-case alphanumeric characters with no
#' spaces. You can also include underscores or any of the following
#' characters: =,.@:/-
#' @param TokenCode The value provided by the MFA device, if MFA is required. If any policy
#' requires the IAM user to submit an MFA code, specify this value. If MFA
#' authentication is required, the user must provide a code when requesting
#' a set of temporary security credentials. A user who fails to provide the
#' code receives an \"access denied\" response when requesting resources
#' that require MFA authentication.
#' 
#' The format for this parameter, as described by its regex pattern, is a
#' sequence of six numeric digits.
#'
#' @section Request syntax:
#' ```
#' svc$get_session_token(
#'   DurationSeconds = 123,
#'   SerialNumber = "string",
#'   TokenCode = "string"
#' )
#' ```
#'
#' @examples
#' # 
#' \donttest{svc$get_session_token(
#'   DurationSeconds = 3600L,
#'   SerialNumber = "YourMFASerialNumber",
#'   TokenCode = "123456"
#' )}
#'
#' @keywords internal
#'
#' @rdname sts_get_session_token
sts_get_session_token <- function(DurationSeconds = NULL, SerialNumber = NULL, TokenCode = NULL) {
  op <- new_operation(
    name = "GetSessionToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sts$get_session_token_input(DurationSeconds = DurationSeconds, SerialNumber = SerialNumber, TokenCode = TokenCode)
  output <- .sts$get_session_token_output()
  config <- get_config()
  svc <- .sts$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sts$operations$get_session_token <- sts_get_session_token
