# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include acm_service.R
NULL

#' Adds one or more tags to an ACM certificate
#'
#' Adds one or more tags to an ACM certificate. Tags are labels that you
#' can use to identify and organize your AWS resources. Each tag consists
#' of a `key` and an optional `value`. You specify the certificate on input
#' by its Amazon Resource Name (ARN). You specify the tag by using a
#' key-value pair.
#' 
#' You can apply a tag to just one certificate if you want to identify a
#' specific characteristic of that certificate, or you can apply the same
#' tag to multiple certificates if you want to filter for a common
#' relationship among those certificates. Similarly, you can apply the same
#' tag to multiple resources if you want to specify a relationship among
#' those resources. For example, you can add the same tag to an ACM
#' certificate and an Elastic Load Balancing load balancer to indicate that
#' they are both used by the same website. For more information, see
#' [Tagging ACM
#' certificates](https://docs.aws.amazon.com/acm/latest/userguide/tags.html).
#' 
#' To remove one or more tags, use the RemoveTagsFromCertificate action. To
#' view all of the tags that have been applied to the certificate, use the
#' ListTagsForCertificate action.
#'
#' @usage
#' acm_add_tags_to_certificate(CertificateArn, Tags)
#'
#' @param CertificateArn &#91;required&#93; String that contains the ARN of the ACM certificate to which the tag is
#' to be applied. This must be of the form:
#' 
#' `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#' @param Tags &#91;required&#93; The key-value pair that defines the tag. The tag value is optional.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags_to_certificate(
#'   CertificateArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acm_add_tags_to_certificate
acm_add_tags_to_certificate <- function(CertificateArn, Tags) {
  op <- new_operation(
    name = "AddTagsToCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acm$add_tags_to_certificate_input(CertificateArn = CertificateArn, Tags = Tags)
  output <- .acm$add_tags_to_certificate_output()
  config <- get_config()
  svc <- .acm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$add_tags_to_certificate <- acm_add_tags_to_certificate

#' Deletes a certificate and its associated private key
#'
#' Deletes a certificate and its associated private key. If this action
#' succeeds, the certificate no longer appears in the list that can be
#' displayed by calling the ListCertificates action or be retrieved by
#' calling the GetCertificate action. The certificate will not be available
#' for use by AWS services integrated with ACM.
#' 
#' You cannot delete an ACM certificate that is being used by another AWS
#' service. To delete a certificate that is in use, the certificate
#' association must first be removed.
#'
#' @usage
#' acm_delete_certificate(CertificateArn)
#'
#' @param CertificateArn &#91;required&#93; String that contains the ARN of the ACM certificate to be deleted. This
#' must be of the form:
#' 
#' `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#'
#' @section Request syntax:
#' ```
#' svc$delete_certificate(
#'   CertificateArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acm_delete_certificate
acm_delete_certificate <- function(CertificateArn) {
  op <- new_operation(
    name = "DeleteCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acm$delete_certificate_input(CertificateArn = CertificateArn)
  output <- .acm$delete_certificate_output()
  config <- get_config()
  svc <- .acm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$delete_certificate <- acm_delete_certificate

#' Returns detailed metadata about the specified ACM certificate
#'
#' Returns detailed metadata about the specified ACM certificate.
#'
#' @usage
#' acm_describe_certificate(CertificateArn)
#'
#' @param CertificateArn &#91;required&#93; The Amazon Resource Name (ARN) of the ACM certificate. The ARN must have
#' the following form:
#' 
#' `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#'
#' @section Request syntax:
#' ```
#' svc$describe_certificate(
#'   CertificateArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acm_describe_certificate
acm_describe_certificate <- function(CertificateArn) {
  op <- new_operation(
    name = "DescribeCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acm$describe_certificate_input(CertificateArn = CertificateArn)
  output <- .acm$describe_certificate_output()
  config <- get_config()
  svc <- .acm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$describe_certificate <- acm_describe_certificate

#' Exports a private certificate issued by a private certificate authority
#' (CA) for use anywhere
#'
#' Exports a private certificate issued by a private certificate authority
#' (CA) for use anywhere. The exported file contains the certificate, the
#' certificate chain, and the encrypted private 2048-bit RSA key associated
#' with the public key that is embedded in the certificate. For security,
#' you must assign a passphrase for the private key when exporting it.
#' 
#' For information about exporting and formatting a certificate using the
#' ACM console or CLI, see [Export a Private
#' Certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-export-private.html).
#'
#' @usage
#' acm_export_certificate(CertificateArn, Passphrase)
#'
#' @param CertificateArn &#91;required&#93; An Amazon Resource Name (ARN) of the issued certificate. This must be of
#' the form:
#' 
#' `arn:aws:acm:region:account:certificate/12345678-1234-1234-1234-123456789012`
#' @param Passphrase &#91;required&#93; Passphrase to associate with the encrypted exported private key. If you
#' want to later decrypt the private key, you must have the passphrase. You
#' can use the following OpenSSL command to decrypt a private key:
#' 
#' `openssl rsa -in encrypted_key.pem -out decrypted_key.pem`
#'
#' @section Request syntax:
#' ```
#' svc$export_certificate(
#'   CertificateArn = "string",
#'   Passphrase = raw
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acm_export_certificate
acm_export_certificate <- function(CertificateArn, Passphrase) {
  op <- new_operation(
    name = "ExportCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acm$export_certificate_input(CertificateArn = CertificateArn, Passphrase = Passphrase)
  output <- .acm$export_certificate_output()
  config <- get_config()
  svc <- .acm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$export_certificate <- acm_export_certificate

#' Retrieves a certificate specified by an ARN and its certificate chain
#'
#' Retrieves a certificate specified by an ARN and its certificate chain .
#' The chain is an ordered list of certificates that contains the end
#' entity certificate, intermediate certificates of subordinate CAs, and
#' the root certificate in that order. The certificate and certificate
#' chain are base64 encoded. If you want to decode the certificate to see
#' the individual fields, you can use OpenSSL.
#'
#' @usage
#' acm_get_certificate(CertificateArn)
#'
#' @param CertificateArn &#91;required&#93; String that contains a certificate ARN in the following format:
#' 
#' `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#'
#' @section Request syntax:
#' ```
#' svc$get_certificate(
#'   CertificateArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acm_get_certificate
acm_get_certificate <- function(CertificateArn) {
  op <- new_operation(
    name = "GetCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acm$get_certificate_input(CertificateArn = CertificateArn)
  output <- .acm$get_certificate_output()
  config <- get_config()
  svc <- .acm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$get_certificate <- acm_get_certificate

#' Imports a certificate into AWS Certificate Manager (ACM) to use with
#' services that are integrated with ACM
#'
#' Imports a certificate into AWS Certificate Manager (ACM) to use with
#' services that are integrated with ACM. Note that [integrated
#' services](https://docs.aws.amazon.com/acm/latest/userguide/acm-services.html)
#' allow only certificate types and keys they support to be associated with
#' their resources. Further, their support differs depending on whether the
#' certificate is imported into IAM or into ACM. For more information, see
#' the documentation for each service. For more information about importing
#' certificates into ACM, see [Importing
#' Certificates](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html)
#' in the *AWS Certificate Manager User Guide*.
#' 
#' ACM does not provide [managed
#' renewal](https://docs.aws.amazon.com/acm/latest/userguide/acm-renewal.html)
#' for certificates that you import.
#' 
#' Note the following guidelines when importing third party certificates:
#' 
#' -   You must enter the private key that matches the certificate you are
#'     importing.
#' 
#' -   The private key must be unencrypted. You cannot import a private key
#'     that is protected by a password or a passphrase.
#' 
#' -   If the certificate you are importing is not self-signed, you must
#'     enter its certificate chain.
#' 
#' -   If a certificate chain is included, the issuer must be the subject
#'     of one of the certificates in the chain.
#' 
#' -   The certificate, private key, and certificate chain must be
#'     PEM-encoded.
#' 
#' -   The current time must be between the `Not Before` and `Not After`
#'     certificate fields.
#' 
#' -   The `Issuer` field must not be empty.
#' 
#' -   The OCSP authority URL, if present, must not exceed 1000 characters.
#' 
#' -   To import a new certificate, omit the `CertificateArn` argument.
#'     Include this argument only when you want to replace a previously
#'     imported certifica
#' 
#' -   When you import a certificate by using the CLI, you must specify the
#'     certificate, the certificate chain, and the private key by their
#'     file names preceded by `file://`. For example, you can specify a
#'     certificate saved in the `C:\\temp` folder as
#'     `file://C:\\temp\\certificate_to_import.pem`. If you are making an
#'     HTTP or HTTPS Query request, include these arguments as BLOBs.
#' 
#' -   When you import a certificate by using an SDK, you must specify the
#'     certificate, the certificate chain, and the private key files in the
#'     manner required by the programming language you\'re using.
#' 
#' -   The cryptographic algorithm of an imported certificate must match
#'     the algorithm of the signing CA. For example, if the signing CA key
#'     type is RSA, then the certificate key type must also be RSA.
#' 
#' This operation returns the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of the imported certificate.
#'
#' @usage
#' acm_import_certificate(CertificateArn, Certificate, PrivateKey,
#'   CertificateChain, Tags)
#'
#' @param CertificateArn The [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of an imported certificate to replace. To import a new certificate, omit
#' this field.
#' @param Certificate &#91;required&#93; The certificate to import.
#' @param PrivateKey &#91;required&#93; The private key that matches the public key in the certificate.
#' @param CertificateChain The PEM encoded certificate chain.
#' @param Tags One or more resource tags to associate with the imported certificate.
#' 
#' Note: You cannot apply tags when reimporting a certificate.
#'
#' @section Request syntax:
#' ```
#' svc$import_certificate(
#'   CertificateArn = "string",
#'   Certificate = raw,
#'   PrivateKey = raw,
#'   CertificateChain = raw,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acm_import_certificate
acm_import_certificate <- function(CertificateArn = NULL, Certificate, PrivateKey, CertificateChain = NULL, Tags = NULL) {
  op <- new_operation(
    name = "ImportCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acm$import_certificate_input(CertificateArn = CertificateArn, Certificate = Certificate, PrivateKey = PrivateKey, CertificateChain = CertificateChain, Tags = Tags)
  output <- .acm$import_certificate_output()
  config <- get_config()
  svc <- .acm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$import_certificate <- acm_import_certificate

#' Retrieves a list of certificate ARNs and domain names
#'
#' Retrieves a list of certificate ARNs and domain names. You can request
#' that only certificates that match a specific status be listed. You can
#' also filter by specific attributes of the certificate. Default filtering
#' returns only `RSA_2048` certificates. For more information, see Filters.
#'
#' @usage
#' acm_list_certificates(CertificateStatuses, Includes, NextToken,
#'   MaxItems)
#'
#' @param CertificateStatuses Filter the certificate list by status value.
#' @param Includes Filter the certificate list. For more information, see the Filters
#' structure.
#' @param NextToken Use this parameter only when paginating results and only in a subsequent
#' request after you receive a response with truncated results. Set it to
#' the value of `NextToken` from the response you just received.
#' @param MaxItems Use this parameter when paginating results to specify the maximum number
#' of items to return in the response. If additional items exist beyond the
#' number you specify, the `NextToken` element is sent in the response. Use
#' this `NextToken` value in a subsequent request to retrieve additional
#' items.
#'
#' @section Request syntax:
#' ```
#' svc$list_certificates(
#'   CertificateStatuses = list(
#'     "PENDING_VALIDATION"|"ISSUED"|"INACTIVE"|"EXPIRED"|"VALIDATION_TIMED_OUT"|"REVOKED"|"FAILED"
#'   ),
#'   Includes = list(
#'     extendedKeyUsage = list(
#'       "TLS_WEB_SERVER_AUTHENTICATION"|"TLS_WEB_CLIENT_AUTHENTICATION"|"CODE_SIGNING"|"EMAIL_PROTECTION"|"TIME_STAMPING"|"OCSP_SIGNING"|"IPSEC_END_SYSTEM"|"IPSEC_TUNNEL"|"IPSEC_USER"|"ANY"|"NONE"|"CUSTOM"
#'     ),
#'     keyUsage = list(
#'       "DIGITAL_SIGNATURE"|"NON_REPUDIATION"|"KEY_ENCIPHERMENT"|"DATA_ENCIPHERMENT"|"KEY_AGREEMENT"|"CERTIFICATE_SIGNING"|"CRL_SIGNING"|"ENCIPHER_ONLY"|"DECIPHER_ONLY"|"ANY"|"CUSTOM"
#'     ),
#'     keyTypes = list(
#'       "RSA_2048"|"RSA_1024"|"RSA_4096"|"EC_prime256v1"|"EC_secp384r1"|"EC_secp521r1"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acm_list_certificates
acm_list_certificates <- function(CertificateStatuses = NULL, Includes = NULL, NextToken = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acm$list_certificates_input(CertificateStatuses = CertificateStatuses, Includes = Includes, NextToken = NextToken, MaxItems = MaxItems)
  output <- .acm$list_certificates_output()
  config <- get_config()
  svc <- .acm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$list_certificates <- acm_list_certificates

#' Lists the tags that have been applied to the ACM certificate
#'
#' Lists the tags that have been applied to the ACM certificate. Use the
#' certificate\'s Amazon Resource Name (ARN) to specify the certificate. To
#' add a tag to an ACM certificate, use the AddTagsToCertificate action. To
#' delete a tag, use the RemoveTagsFromCertificate action.
#'
#' @usage
#' acm_list_tags_for_certificate(CertificateArn)
#'
#' @param CertificateArn &#91;required&#93; String that contains the ARN of the ACM certificate for which you want
#' to list the tags. This must have the following form:
#' 
#' `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_certificate(
#'   CertificateArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acm_list_tags_for_certificate
acm_list_tags_for_certificate <- function(CertificateArn) {
  op <- new_operation(
    name = "ListTagsForCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acm$list_tags_for_certificate_input(CertificateArn = CertificateArn)
  output <- .acm$list_tags_for_certificate_output()
  config <- get_config()
  svc <- .acm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$list_tags_for_certificate <- acm_list_tags_for_certificate

#' Remove one or more tags from an ACM certificate
#'
#' Remove one or more tags from an ACM certificate. A tag consists of a
#' key-value pair. If you do not specify the value portion of the tag when
#' calling this function, the tag will be removed regardless of value. If
#' you specify a value, the tag is removed only if it is associated with
#' the specified value.
#' 
#' To add tags to a certificate, use the AddTagsToCertificate action. To
#' view all of the tags that have been applied to a specific ACM
#' certificate, use the ListTagsForCertificate action.
#'
#' @usage
#' acm_remove_tags_from_certificate(CertificateArn, Tags)
#'
#' @param CertificateArn &#91;required&#93; String that contains the ARN of the ACM Certificate with one or more
#' tags that you want to remove. This must be of the form:
#' 
#' `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#' @param Tags &#91;required&#93; The key-value pair that defines the tag to remove.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags_from_certificate(
#'   CertificateArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acm_remove_tags_from_certificate
acm_remove_tags_from_certificate <- function(CertificateArn, Tags) {
  op <- new_operation(
    name = "RemoveTagsFromCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acm$remove_tags_from_certificate_input(CertificateArn = CertificateArn, Tags = Tags)
  output <- .acm$remove_tags_from_certificate_output()
  config <- get_config()
  svc <- .acm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$remove_tags_from_certificate <- acm_remove_tags_from_certificate

#' Renews an eligable ACM certificate
#'
#' Renews an eligable ACM certificate. At this time, only exported private
#' certificates can be renewed with this operation. In order to renew your
#' ACM PCA certificates with ACM, you must first [grant the ACM service
#' principal permission to do
#' so](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaPermissions.html).
#' For more information, see [Testing Managed
#' Renewal](https://docs.aws.amazon.com/acm/latest/userguide/manual-renewal.html)
#' in the ACM User Guide.
#'
#' @usage
#' acm_renew_certificate(CertificateArn)
#'
#' @param CertificateArn &#91;required&#93; String that contains the ARN of the ACM certificate to be renewed. This
#' must be of the form:
#' 
#' `arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' 
#' For more information about ARNs, see [Amazon Resource Names (ARNs) and
#' AWS Service
#' Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
#'
#' @section Request syntax:
#' ```
#' svc$renew_certificate(
#'   CertificateArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acm_renew_certificate
acm_renew_certificate <- function(CertificateArn) {
  op <- new_operation(
    name = "RenewCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acm$renew_certificate_input(CertificateArn = CertificateArn)
  output <- .acm$renew_certificate_output()
  config <- get_config()
  svc <- .acm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$renew_certificate <- acm_renew_certificate

#' Requests an ACM certificate for use with other AWS services
#'
#' Requests an ACM certificate for use with other AWS services. To request
#' an ACM certificate, you must specify a fully qualified domain name
#' (FQDN) in the `DomainName` parameter. You can also specify additional
#' FQDNs in the `SubjectAlternativeNames` parameter.
#' 
#' If you are requesting a private certificate, domain validation is not
#' required. If you are requesting a public certificate, each domain name
#' that you specify must be validated to verify that you own or control the
#' domain. You can use [DNS
#' validation](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html)
#' or [email
#' validation](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html).
#' We recommend that you use DNS validation. ACM issues public certificates
#' after receiving approval from the domain owner.
#'
#' @usage
#' acm_request_certificate(DomainName, ValidationMethod,
#'   SubjectAlternativeNames, IdempotencyToken, DomainValidationOptions,
#'   Options, CertificateAuthorityArn, Tags)
#'
#' @param DomainName &#91;required&#93; Fully qualified domain name (FQDN), such as www.example.com, that you
#' want to secure with an ACM certificate. Use an asterisk (*) to create a
#' wildcard certificate that protects several sites in the same domain. For
#' example, *.example.com protects www.example.com, site.example.com, and
#' images.example.com.
#' 
#' The first domain name you enter cannot exceed 64 octets, including
#' periods. Each subsequent Subject Alternative Name (SAN), however, can be
#' up to 253 octets in length.
#' @param ValidationMethod The method you want to use if you are requesting a public certificate to
#' validate that you own or control domain. You can [validate with
#' DNS](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-dns.html)
#' or [validate with
#' email](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-validate-email.html).
#' We recommend that you use DNS validation.
#' @param SubjectAlternativeNames Additional FQDNs to be included in the Subject Alternative Name
#' extension of the ACM certificate. For example, add the name
#' www.example.net to a certificate for which the `DomainName` field is
#' www.example.com if users can reach your site by using either name. The
#' maximum number of domain names that you can add to an ACM certificate is
#' 100. However, the initial limit is 10 domain names. If you need more
#' than 10 names, you must request a limit increase. For more information,
#' see
#' [Limits](https://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html).
#' 
#' The maximum length of a SAN DNS name is 253 octets. The name is made up
#' of multiple labels separated by periods. No label can be longer than 63
#' octets. Consider the following examples:
#' 
#' -   `(63 octets).(63 octets).(63 octets).(61 octets)` is legal because
#'     the total length is 253 octets (63+1+63+1+63+1+61) and no label
#'     exceeds 63 octets.
#' 
#' -   `(64 octets).(63 octets).(63 octets).(61 octets)` is not legal
#'     because the total length exceeds 253 octets (64+1+63+1+63+1+61) and
#'     the first label exceeds 63 octets.
#' 
#' -   `(63 octets).(63 octets).(63 octets).(62 octets)` is not legal
#'     because the total length of the DNS name (63+1+63+1+63+1+62) exceeds
#'     253 octets.
#' @param IdempotencyToken Customer chosen string that can be used to distinguish between calls to
#' `RequestCertificate`. Idempotency tokens time out after one hour.
#' Therefore, if you call `RequestCertificate` multiple times with the same
#' idempotency token within one hour, ACM recognizes that you are
#' requesting only one certificate and will issue only one. If you change
#' the idempotency token for each call, ACM recognizes that you are
#' requesting multiple certificates.
#' @param DomainValidationOptions The domain name that you want ACM to use to send you emails so that you
#' can validate domain ownership.
#' @param Options Currently, you can use this parameter to specify whether to add the
#' certificate to a certificate transparency log. Certificate transparency
#' makes it possible to detect SSL/TLS certificates that have been
#' mistakenly or maliciously issued. Certificates that have not been logged
#' typically produce an error message in a browser. For more information,
#' see [Opting Out of Certificate Transparency
#' Logging](https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency).
#' @param CertificateAuthorityArn The Amazon Resource Name (ARN) of the private certificate authority (CA)
#' that will be used to issue the certificate. If you do not provide an ARN
#' and you are trying to request a private certificate, ACM will attempt to
#' issue a public certificate. For more information about private CAs, see
#' the [AWS Certificate Manager Private Certificate Authority
#' (PCA)](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaWelcome.html)
#' user guide. The ARN must have the following form:
#' 
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012`
#' @param Tags One or more resource tags to associate with the certificate.
#'
#' @section Request syntax:
#' ```
#' svc$request_certificate(
#'   DomainName = "string",
#'   ValidationMethod = "EMAIL"|"DNS",
#'   SubjectAlternativeNames = list(
#'     "string"
#'   ),
#'   IdempotencyToken = "string",
#'   DomainValidationOptions = list(
#'     list(
#'       DomainName = "string",
#'       ValidationDomain = "string"
#'     )
#'   ),
#'   Options = list(
#'     CertificateTransparencyLoggingPreference = "ENABLED"|"DISABLED"
#'   ),
#'   CertificateAuthorityArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acm_request_certificate
acm_request_certificate <- function(DomainName, ValidationMethod = NULL, SubjectAlternativeNames = NULL, IdempotencyToken = NULL, DomainValidationOptions = NULL, Options = NULL, CertificateAuthorityArn = NULL, Tags = NULL) {
  op <- new_operation(
    name = "RequestCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acm$request_certificate_input(DomainName = DomainName, ValidationMethod = ValidationMethod, SubjectAlternativeNames = SubjectAlternativeNames, IdempotencyToken = IdempotencyToken, DomainValidationOptions = DomainValidationOptions, Options = Options, CertificateAuthorityArn = CertificateAuthorityArn, Tags = Tags)
  output <- .acm$request_certificate_output()
  config <- get_config()
  svc <- .acm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$request_certificate <- acm_request_certificate

#' Resends the email that requests domain ownership validation
#'
#' Resends the email that requests domain ownership validation. The domain
#' owner or an authorized representative must approve the ACM certificate
#' before it can be issued. The certificate can be approved by clicking a
#' link in the mail to navigate to the Amazon certificate approval website
#' and then clicking **I Approve**. However, the validation email can be
#' blocked by spam filters. Therefore, if you do not receive the original
#' mail, you can request that the mail be resent within 72 hours of
#' requesting the ACM certificate. If more than 72 hours have elapsed since
#' your original request or since your last attempt to resend validation
#' mail, you must request a new certificate. For more information about
#' setting up your contact email addresses, see [Configure Email for your
#' Domain](https://docs.aws.amazon.com/acm/latest/userguide/setup-email.html).
#'
#' @usage
#' acm_resend_validation_email(CertificateArn, Domain, ValidationDomain)
#'
#' @param CertificateArn &#91;required&#93; String that contains the ARN of the requested certificate. The
#' certificate ARN is generated and returned by the RequestCertificate
#' action as soon as the request is made. By default, using this parameter
#' causes email to be sent to all top-level domains you specified in the
#' certificate request. The ARN must be of the form:
#' 
#' `arn:aws:acm:us-east-1:123456789012:certificate/12345678-1234-1234-1234-123456789012`
#' @param Domain &#91;required&#93; The fully qualified domain name (FQDN) of the certificate that needs to
#' be validated.
#' @param ValidationDomain &#91;required&#93; The base validation domain that will act as the suffix of the email
#' addresses that are used to send the emails. This must be the same as the
#' `Domain` value or a superdomain of the `Domain` value. For example, if
#' you requested a certificate for `site.subdomain.example.com` and specify
#' a **ValidationDomain** of `subdomain.example.com`, ACM sends email to
#' the domain registrant, technical contact, and administrative contact in
#' WHOIS and the following five addresses:
#' 
#' -   admin\\@subdomain.example.com
#' 
#' -   administrator\\@subdomain.example.com
#' 
#' -   hostmaster\\@subdomain.example.com
#' 
#' -   postmaster\\@subdomain.example.com
#' 
#' -   webmaster\\@subdomain.example.com
#'
#' @section Request syntax:
#' ```
#' svc$resend_validation_email(
#'   CertificateArn = "string",
#'   Domain = "string",
#'   ValidationDomain = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acm_resend_validation_email
acm_resend_validation_email <- function(CertificateArn, Domain, ValidationDomain) {
  op <- new_operation(
    name = "ResendValidationEmail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acm$resend_validation_email_input(CertificateArn = CertificateArn, Domain = Domain, ValidationDomain = ValidationDomain)
  output <- .acm$resend_validation_email_output()
  config <- get_config()
  svc <- .acm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$resend_validation_email <- acm_resend_validation_email

#' Updates a certificate
#'
#' Updates a certificate. Currently, you can use this function to specify
#' whether to opt in to or out of recording your certificate in a
#' certificate transparency log. For more information, see [Opting Out of
#' Certificate Transparency
#' Logging](https://docs.aws.amazon.com/acm/latest/userguide/acm-bestpractices.html#best-practices-transparency).
#'
#' @usage
#' acm_update_certificate_options(CertificateArn, Options)
#'
#' @param CertificateArn &#91;required&#93; ARN of the requested certificate to update. This must be of the form:
#' 
#' `arn:aws:acm:us-east-1:<i>account</i>:certificate/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param Options &#91;required&#93; Use to update the options for your certificate. Currently, you can
#' specify whether to add your certificate to a transparency log.
#' Certificate transparency makes it possible to detect SSL/TLS
#' certificates that have been mistakenly or maliciously issued.
#' Certificates that have not been logged typically produce an error
#' message in a browser.
#'
#' @section Request syntax:
#' ```
#' svc$update_certificate_options(
#'   CertificateArn = "string",
#'   Options = list(
#'     CertificateTransparencyLoggingPreference = "ENABLED"|"DISABLED"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acm_update_certificate_options
acm_update_certificate_options <- function(CertificateArn, Options) {
  op <- new_operation(
    name = "UpdateCertificateOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acm$update_certificate_options_input(CertificateArn = CertificateArn, Options = Options)
  output <- .acm$update_certificate_options_output()
  config <- get_config()
  svc <- .acm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acm$operations$update_certificate_options <- acm_update_certificate_options
