% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_update_link_attributes}
\alias{clouddirectory_update_link_attributes}
\title{Updates a given typed linkâ€™s attributes}
\usage{
clouddirectory_update_link_attributes(DirectoryArn, TypedLinkSpecifier,
  AttributeUpdates)
}
\arguments{
\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) that is associated with the Directory
where the updated typed link resides. For more information, see arns or
\href{https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink}{Typed Links}.}

\item{TypedLinkSpecifier}{[required] Allows a typed link specifier to be accepted as input.}

\item{AttributeUpdates}{[required] The attributes update structure.}
}
\description{
Updates a given typed link's attributes. Attributes to be updated must
not contribute to the typed link's identity, as defined by its
\code{IdentityAttributeOrder}.
}
\section{Request syntax}{
\preformatted{svc$update_link_attributes(
  DirectoryArn = "string",
  TypedLinkSpecifier = list(
    TypedLinkFacet = list(
      SchemaArn = "string",
      TypedLinkName = "string"
    ),
    SourceObjectReference = list(
      Selector = "string"
    ),
    TargetObjectReference = list(
      Selector = "string"
    ),
    IdentityAttributeValues = list(
      list(
        AttributeName = "string",
        Value = list(
          StringValue = "string",
          BinaryValue = raw,
          BooleanValue = TRUE|FALSE,
          NumberValue = "string",
          DatetimeValue = as.POSIXct(
            "2015-01-01"
          )
        )
      )
    )
  ),
  AttributeUpdates = list(
    list(
      AttributeKey = list(
        SchemaArn = "string",
        FacetName = "string",
        Name = "string"
      ),
      AttributeAction = list(
        AttributeActionType = "CREATE_OR_UPDATE"|"DELETE",
        AttributeUpdateValue = list(
          StringValue = "string",
          BinaryValue = raw,
          BooleanValue = TRUE|FALSE,
          NumberValue = "string",
          DatetimeValue = as.POSIXct(
            "2015-01-01"
          )
        )
      )
    )
  )
)
}
}

\keyword{internal}
