% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_create_detector}
\alias{guardduty_create_detector}
\title{Creates a single Amazon GuardDuty detector}
\usage{
guardduty_create_detector(Enable, ClientToken,
  FindingPublishingFrequency, Tags)
}
\arguments{
\item{Enable}{[required] A boolean value that specifies whether the detector is to be enabled.}

\item{ClientToken}{The idempotency token for the create request.}

\item{FindingPublishingFrequency}{A enum value that specifies how frequently customer got Finding updates
published.}

\item{Tags}{The tags to be added to a new detector resource.}
}
\description{
Creates a single Amazon GuardDuty detector. A detector is a resource
that represents the GuardDuty service. To start using GuardDuty, you
must create a detector in each region that you enable the service. You
can have only one detector per account per region.
}
\section{Request syntax}{
\preformatted{svc$create_detector(
  Enable = TRUE|FALSE,
  ClientToken = "string",
  FindingPublishingFrequency = "FIFTEEN_MINUTES"|"ONE_HOUR"|"SIX_HOURS",
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
