# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include inspector2_service.R
NULL

#' Associates an Amazon Web Services account with an Amazon Inspector
#' delegated administrator
#'
#' @description
#' Associates an Amazon Web Services account with an Amazon Inspector delegated administrator.
#'
#' See [https://paws-r.github.io/docs/inspector2/associate_member.html](https://paws-r.github.io/docs/inspector2/associate_member.html) for full documentation.
#'
#' @param accountId &#91;required&#93; The Amazon Web Services account ID of the member account to be
#' associated.
#'
#' @keywords internal
#'
#' @rdname inspector2_associate_member
inspector2_associate_member <- function(accountId) {
  op <- new_operation(
    name = "AssociateMember",
    http_method = "POST",
    http_path = "/members/associate",
    paginator = list()
  )
  input <- .inspector2$associate_member_input(accountId = accountId)
  output <- .inspector2$associate_member_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$associate_member <- inspector2_associate_member

#' Retrieves the Amazon Inspector status of multiple Amazon Web Services
#' accounts within your environment
#'
#' @description
#' Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.
#'
#' See [https://paws-r.github.io/docs/inspector2/batch_get_account_status.html](https://paws-r.github.io/docs/inspector2/batch_get_account_status.html) for full documentation.
#'
#' @param accountIds The 12-digit Amazon Web Services account IDs of the accounts to retrieve
#' Amazon Inspector status for.
#'
#' @keywords internal
#'
#' @rdname inspector2_batch_get_account_status
inspector2_batch_get_account_status <- function(accountIds = NULL) {
  op <- new_operation(
    name = "BatchGetAccountStatus",
    http_method = "POST",
    http_path = "/status/batch/get",
    paginator = list()
  )
  input <- .inspector2$batch_get_account_status_input(accountIds = accountIds)
  output <- .inspector2$batch_get_account_status_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$batch_get_account_status <- inspector2_batch_get_account_status

#' Gets free trial status for multiple Amazon Web Services accounts
#'
#' @description
#' Gets free trial status for multiple Amazon Web Services accounts.
#'
#' See [https://paws-r.github.io/docs/inspector2/batch_get_free_trial_info.html](https://paws-r.github.io/docs/inspector2/batch_get_free_trial_info.html) for full documentation.
#'
#' @param accountIds &#91;required&#93; The account IDs to get free trial status for.
#'
#' @keywords internal
#'
#' @rdname inspector2_batch_get_free_trial_info
inspector2_batch_get_free_trial_info <- function(accountIds) {
  op <- new_operation(
    name = "BatchGetFreeTrialInfo",
    http_method = "POST",
    http_path = "/freetrialinfo/batchget",
    paginator = list()
  )
  input <- .inspector2$batch_get_free_trial_info_input(accountIds = accountIds)
  output <- .inspector2$batch_get_free_trial_info_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$batch_get_free_trial_info <- inspector2_batch_get_free_trial_info

#' Cancels the given findings report
#'
#' @description
#' Cancels the given findings report.
#'
#' See [https://paws-r.github.io/docs/inspector2/cancel_findings_report.html](https://paws-r.github.io/docs/inspector2/cancel_findings_report.html) for full documentation.
#'
#' @param reportId &#91;required&#93; The ID of the report to be canceled.
#'
#' @keywords internal
#'
#' @rdname inspector2_cancel_findings_report
inspector2_cancel_findings_report <- function(reportId) {
  op <- new_operation(
    name = "CancelFindingsReport",
    http_method = "POST",
    http_path = "/reporting/cancel",
    paginator = list()
  )
  input <- .inspector2$cancel_findings_report_input(reportId = reportId)
  output <- .inspector2$cancel_findings_report_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$cancel_findings_report <- inspector2_cancel_findings_report

#' Creates a filter resource using specified filter criteria
#'
#' @description
#' Creates a filter resource using specified filter criteria.
#'
#' See [https://paws-r.github.io/docs/inspector2/create_filter.html](https://paws-r.github.io/docs/inspector2/create_filter.html) for full documentation.
#'
#' @param action &#91;required&#93; Defines the action that is to be applied to the findings that match the
#' filter.
#' @param description A description of the filter.
#' @param filterCriteria &#91;required&#93; Defines the criteria to be used in the filter for querying findings.
#' @param name &#91;required&#93; The name of the filter. Minimum length of 3. Maximum length of 64. Valid
#' characters include alphanumeric characters, dot (.), underscore (_),
#' and dash (-). Spaces are not allowed.
#' @param reason The reason for creating the filter.
#' @param tags A list of tags for the filter.
#'
#' @keywords internal
#'
#' @rdname inspector2_create_filter
inspector2_create_filter <- function(action, description = NULL, filterCriteria, name, reason = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateFilter",
    http_method = "POST",
    http_path = "/filters/create",
    paginator = list()
  )
  input <- .inspector2$create_filter_input(action = action, description = description, filterCriteria = filterCriteria, name = name, reason = reason, tags = tags)
  output <- .inspector2$create_filter_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$create_filter <- inspector2_create_filter

#' Creates a finding report
#'
#' @description
#' Creates a finding report.
#'
#' See [https://paws-r.github.io/docs/inspector2/create_findings_report.html](https://paws-r.github.io/docs/inspector2/create_findings_report.html) for full documentation.
#'
#' @param filterCriteria The filter criteria to apply to the results of the finding report.
#' @param reportFormat &#91;required&#93; The format to generate the report in.
#' @param s3Destination &#91;required&#93; The Amazon S3 export destination for the report.
#'
#' @keywords internal
#'
#' @rdname inspector2_create_findings_report
inspector2_create_findings_report <- function(filterCriteria = NULL, reportFormat, s3Destination) {
  op <- new_operation(
    name = "CreateFindingsReport",
    http_method = "POST",
    http_path = "/reporting/create",
    paginator = list()
  )
  input <- .inspector2$create_findings_report_input(filterCriteria = filterCriteria, reportFormat = reportFormat, s3Destination = s3Destination)
  output <- .inspector2$create_findings_report_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$create_findings_report <- inspector2_create_findings_report

#' Deletes a filter resource
#'
#' @description
#' Deletes a filter resource.
#'
#' See [https://paws-r.github.io/docs/inspector2/delete_filter.html](https://paws-r.github.io/docs/inspector2/delete_filter.html) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Number (ARN) of the filter to be deleted.
#'
#' @keywords internal
#'
#' @rdname inspector2_delete_filter
inspector2_delete_filter <- function(arn) {
  op <- new_operation(
    name = "DeleteFilter",
    http_method = "POST",
    http_path = "/filters/delete",
    paginator = list()
  )
  input <- .inspector2$delete_filter_input(arn = arn)
  output <- .inspector2$delete_filter_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$delete_filter <- inspector2_delete_filter

#' Describe Amazon Inspector configuration settings for an Amazon Web
#' Services organization
#'
#' @description
#' Describe Amazon Inspector configuration settings for an Amazon Web Services organization
#'
#' See [https://paws-r.github.io/docs/inspector2/describe_organization_configuration.html](https://paws-r.github.io/docs/inspector2/describe_organization_configuration.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname inspector2_describe_organization_configuration
inspector2_describe_organization_configuration <- function() {
  op <- new_operation(
    name = "DescribeOrganizationConfiguration",
    http_method = "POST",
    http_path = "/organizationconfiguration/describe",
    paginator = list()
  )
  input <- .inspector2$describe_organization_configuration_input()
  output <- .inspector2$describe_organization_configuration_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$describe_organization_configuration <- inspector2_describe_organization_configuration

#' Disables Amazon Inspector scans for one or more Amazon Web Services
#' accounts
#'
#' @description
#' Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an account disables the Amazon Inspector service.
#'
#' See [https://paws-r.github.io/docs/inspector2/disable.html](https://paws-r.github.io/docs/inspector2/disable.html) for full documentation.
#'
#' @param accountIds An array of account IDs you want to disable Amazon Inspector scans for.
#' @param resourceTypes The resource scan types you want to disable.
#'
#' @keywords internal
#'
#' @rdname inspector2_disable
inspector2_disable <- function(accountIds = NULL, resourceTypes = NULL) {
  op <- new_operation(
    name = "Disable",
    http_method = "POST",
    http_path = "/disable",
    paginator = list()
  )
  input <- .inspector2$disable_input(accountIds = accountIds, resourceTypes = resourceTypes)
  output <- .inspector2$disable_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$disable <- inspector2_disable

#' Disables the Amazon Inspector delegated administrator for your
#' organization
#'
#' @description
#' Disables the Amazon Inspector delegated administrator for your organization.
#'
#' See [https://paws-r.github.io/docs/inspector2/disable_delegated_admin_account.html](https://paws-r.github.io/docs/inspector2/disable_delegated_admin_account.html) for full documentation.
#'
#' @param delegatedAdminAccountId &#91;required&#93; The Amazon Web Services account ID of the current Amazon Inspector
#' delegated administrator.
#'
#' @keywords internal
#'
#' @rdname inspector2_disable_delegated_admin_account
inspector2_disable_delegated_admin_account <- function(delegatedAdminAccountId) {
  op <- new_operation(
    name = "DisableDelegatedAdminAccount",
    http_method = "POST",
    http_path = "/delegatedadminaccounts/disable",
    paginator = list()
  )
  input <- .inspector2$disable_delegated_admin_account_input(delegatedAdminAccountId = delegatedAdminAccountId)
  output <- .inspector2$disable_delegated_admin_account_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$disable_delegated_admin_account <- inspector2_disable_delegated_admin_account

#' Disassociates a member account from an Amazon Inspector delegated
#' administrator
#'
#' @description
#' Disassociates a member account from an Amazon Inspector delegated administrator.
#'
#' See [https://paws-r.github.io/docs/inspector2/disassociate_member.html](https://paws-r.github.io/docs/inspector2/disassociate_member.html) for full documentation.
#'
#' @param accountId &#91;required&#93; The Amazon Web Services account ID of the member account to
#' disassociate.
#'
#' @keywords internal
#'
#' @rdname inspector2_disassociate_member
inspector2_disassociate_member <- function(accountId) {
  op <- new_operation(
    name = "DisassociateMember",
    http_method = "POST",
    http_path = "/members/disassociate",
    paginator = list()
  )
  input <- .inspector2$disassociate_member_input(accountId = accountId)
  output <- .inspector2$disassociate_member_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$disassociate_member <- inspector2_disassociate_member

#' Enables Amazon Inspector scans for one or more Amazon Web Services
#' accounts
#'
#' @description
#' Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
#'
#' See [https://paws-r.github.io/docs/inspector2/enable.html](https://paws-r.github.io/docs/inspector2/enable.html) for full documentation.
#'
#' @param accountIds A list of account IDs you want to enable Amazon Inspector scans for.
#' @param clientToken The idempotency token for the request.
#' @param resourceTypes &#91;required&#93; The resource scan types you want to enable.
#'
#' @keywords internal
#'
#' @rdname inspector2_enable
inspector2_enable <- function(accountIds = NULL, clientToken = NULL, resourceTypes) {
  op <- new_operation(
    name = "Enable",
    http_method = "POST",
    http_path = "/enable",
    paginator = list()
  )
  input <- .inspector2$enable_input(accountIds = accountIds, clientToken = clientToken, resourceTypes = resourceTypes)
  output <- .inspector2$enable_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$enable <- inspector2_enable

#' Enables the Amazon Inspector delegated administrator for your
#' Organizations organization
#'
#' @description
#' Enables the Amazon Inspector delegated administrator for your Organizations organization.
#'
#' See [https://paws-r.github.io/docs/inspector2/enable_delegated_admin_account.html](https://paws-r.github.io/docs/inspector2/enable_delegated_admin_account.html) for full documentation.
#'
#' @param clientToken The idempotency token for the request.
#' @param delegatedAdminAccountId &#91;required&#93; The Amazon Web Services account ID of the Amazon Inspector delegated
#' administrator.
#'
#' @keywords internal
#'
#' @rdname inspector2_enable_delegated_admin_account
inspector2_enable_delegated_admin_account <- function(clientToken = NULL, delegatedAdminAccountId) {
  op <- new_operation(
    name = "EnableDelegatedAdminAccount",
    http_method = "POST",
    http_path = "/delegatedadminaccounts/enable",
    paginator = list()
  )
  input <- .inspector2$enable_delegated_admin_account_input(clientToken = clientToken, delegatedAdminAccountId = delegatedAdminAccountId)
  output <- .inspector2$enable_delegated_admin_account_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$enable_delegated_admin_account <- inspector2_enable_delegated_admin_account

#' Retrieves setting configurations for Inspector scans
#'
#' @description
#' Retrieves setting configurations for Inspector scans.
#'
#' See [https://paws-r.github.io/docs/inspector2/get_configuration.html](https://paws-r.github.io/docs/inspector2/get_configuration.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname inspector2_get_configuration
inspector2_get_configuration <- function() {
  op <- new_operation(
    name = "GetConfiguration",
    http_method = "POST",
    http_path = "/configuration/get",
    paginator = list()
  )
  input <- .inspector2$get_configuration_input()
  output <- .inspector2$get_configuration_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$get_configuration <- inspector2_get_configuration

#' Retrieves information about the Amazon Inspector delegated administrator
#' for your organization
#'
#' @description
#' Retrieves information about the Amazon Inspector delegated administrator for your organization.
#'
#' See [https://paws-r.github.io/docs/inspector2/get_delegated_admin_account.html](https://paws-r.github.io/docs/inspector2/get_delegated_admin_account.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname inspector2_get_delegated_admin_account
inspector2_get_delegated_admin_account <- function() {
  op <- new_operation(
    name = "GetDelegatedAdminAccount",
    http_method = "POST",
    http_path = "/delegatedadminaccounts/get",
    paginator = list()
  )
  input <- .inspector2$get_delegated_admin_account_input()
  output <- .inspector2$get_delegated_admin_account_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$get_delegated_admin_account <- inspector2_get_delegated_admin_account

#' Gets the status of a findings report
#'
#' @description
#' Gets the status of a findings report.
#'
#' See [https://paws-r.github.io/docs/inspector2/get_findings_report_status.html](https://paws-r.github.io/docs/inspector2/get_findings_report_status.html) for full documentation.
#'
#' @param reportId The ID of the report to retrieve the status of.
#'
#' @keywords internal
#'
#' @rdname inspector2_get_findings_report_status
inspector2_get_findings_report_status <- function(reportId = NULL) {
  op <- new_operation(
    name = "GetFindingsReportStatus",
    http_method = "POST",
    http_path = "/reporting/status/get",
    paginator = list()
  )
  input <- .inspector2$get_findings_report_status_input(reportId = reportId)
  output <- .inspector2$get_findings_report_status_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$get_findings_report_status <- inspector2_get_findings_report_status

#' Gets member information for your organization
#'
#' @description
#' Gets member information for your organization.
#'
#' See [https://paws-r.github.io/docs/inspector2/get_member.html](https://paws-r.github.io/docs/inspector2/get_member.html) for full documentation.
#'
#' @param accountId &#91;required&#93; The Amazon Web Services account ID of the member account to retrieve
#' information on.
#'
#' @keywords internal
#'
#' @rdname inspector2_get_member
inspector2_get_member <- function(accountId) {
  op <- new_operation(
    name = "GetMember",
    http_method = "POST",
    http_path = "/members/get",
    paginator = list()
  )
  input <- .inspector2$get_member_input(accountId = accountId)
  output <- .inspector2$get_member_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$get_member <- inspector2_get_member

#' Lists the permissions an account has to configure Amazon Inspector
#'
#' @description
#' Lists the permissions an account has to configure Amazon Inspector.
#'
#' See [https://paws-r.github.io/docs/inspector2/list_account_permissions.html](https://paws-r.github.io/docs/inspector2/list_account_permissions.html) for full documentation.
#'
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#' @param service The service scan type to check permissions for.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_account_permissions
inspector2_list_account_permissions <- function(maxResults = NULL, nextToken = NULL, service = NULL) {
  op <- new_operation(
    name = "ListAccountPermissions",
    http_method = "POST",
    http_path = "/accountpermissions/list",
    paginator = list()
  )
  input <- .inspector2$list_account_permissions_input(maxResults = maxResults, nextToken = nextToken, service = service)
  output <- .inspector2$list_account_permissions_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_account_permissions <- inspector2_list_account_permissions

#' Lists coverage details for you environment
#'
#' @description
#' Lists coverage details for you environment.
#'
#' See [https://paws-r.github.io/docs/inspector2/list_coverage.html](https://paws-r.github.io/docs/inspector2/list_coverage.html) for full documentation.
#'
#' @param filterCriteria An object that contains details on the filters to apply to the coverage
#' data for your environment.
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_coverage
inspector2_list_coverage <- function(filterCriteria = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListCoverage",
    http_method = "POST",
    http_path = "/coverage/list",
    paginator = list()
  )
  input <- .inspector2$list_coverage_input(filterCriteria = filterCriteria, maxResults = maxResults, nextToken = nextToken)
  output <- .inspector2$list_coverage_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_coverage <- inspector2_list_coverage

#' Lists Amazon Inspector coverage statistics for your environment
#'
#' @description
#' Lists Amazon Inspector coverage statistics for your environment.
#'
#' See [https://paws-r.github.io/docs/inspector2/list_coverage_statistics.html](https://paws-r.github.io/docs/inspector2/list_coverage_statistics.html) for full documentation.
#'
#' @param filterCriteria An object that contains details on the filters to apply to the coverage
#' data for your environment.
#' @param groupBy The value to group the results by.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_coverage_statistics
inspector2_list_coverage_statistics <- function(filterCriteria = NULL, groupBy = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListCoverageStatistics",
    http_method = "POST",
    http_path = "/coverage/statistics/list",
    paginator = list()
  )
  input <- .inspector2$list_coverage_statistics_input(filterCriteria = filterCriteria, groupBy = groupBy, nextToken = nextToken)
  output <- .inspector2$list_coverage_statistics_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_coverage_statistics <- inspector2_list_coverage_statistics

#' Lists information about the Amazon Inspector delegated administrator of
#' your organization
#'
#' @description
#' Lists information about the Amazon Inspector delegated administrator of your organization.
#'
#' See [https://paws-r.github.io/docs/inspector2/list_delegated_admin_accounts.html](https://paws-r.github.io/docs/inspector2/list_delegated_admin_accounts.html) for full documentation.
#'
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_delegated_admin_accounts
inspector2_list_delegated_admin_accounts <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListDelegatedAdminAccounts",
    http_method = "POST",
    http_path = "/delegatedadminaccounts/list",
    paginator = list()
  )
  input <- .inspector2$list_delegated_admin_accounts_input(maxResults = maxResults, nextToken = nextToken)
  output <- .inspector2$list_delegated_admin_accounts_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_delegated_admin_accounts <- inspector2_list_delegated_admin_accounts

#' Lists the filters associated with your account
#'
#' @description
#' Lists the filters associated with your account.
#'
#' See [https://paws-r.github.io/docs/inspector2/list_filters.html](https://paws-r.github.io/docs/inspector2/list_filters.html) for full documentation.
#'
#' @param action The action the filter applies to matched findings.
#' @param arns The Amazon resource number (ARN) of the filter.
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_filters
inspector2_list_filters <- function(action = NULL, arns = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListFilters",
    http_method = "POST",
    http_path = "/filters/list",
    paginator = list()
  )
  input <- .inspector2$list_filters_input(action = action, arns = arns, maxResults = maxResults, nextToken = nextToken)
  output <- .inspector2$list_filters_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_filters <- inspector2_list_filters

#' Lists aggregated finding data for your environment based on specific
#' criteria
#'
#' @description
#' Lists aggregated finding data for your environment based on specific criteria.
#'
#' See [https://paws-r.github.io/docs/inspector2/list_finding_aggregations.html](https://paws-r.github.io/docs/inspector2/list_finding_aggregations.html) for full documentation.
#'
#' @param accountIds The Amazon Web Services account IDs to retrieve finding aggregation data
#' for.
#' @param aggregationRequest Details of the aggregation request that is used to filter your
#' aggregation results.
#' @param aggregationType &#91;required&#93; The type of the aggregation request.
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_finding_aggregations
inspector2_list_finding_aggregations <- function(accountIds = NULL, aggregationRequest = NULL, aggregationType, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListFindingAggregations",
    http_method = "POST",
    http_path = "/findings/aggregation/list",
    paginator = list()
  )
  input <- .inspector2$list_finding_aggregations_input(accountIds = accountIds, aggregationRequest = aggregationRequest, aggregationType = aggregationType, maxResults = maxResults, nextToken = nextToken)
  output <- .inspector2$list_finding_aggregations_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_finding_aggregations <- inspector2_list_finding_aggregations

#' Lists findings for your environment
#'
#' @description
#' Lists findings for your environment.
#'
#' See [https://paws-r.github.io/docs/inspector2/list_findings.html](https://paws-r.github.io/docs/inspector2/list_findings.html) for full documentation.
#'
#' @param filterCriteria Details on the filters to apply to your finding results.
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#' @param sortCriteria Details on the sort criteria to apply to your finding results.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_findings
inspector2_list_findings <- function(filterCriteria = NULL, maxResults = NULL, nextToken = NULL, sortCriteria = NULL) {
  op <- new_operation(
    name = "ListFindings",
    http_method = "POST",
    http_path = "/findings/list",
    paginator = list()
  )
  input <- .inspector2$list_findings_input(filterCriteria = filterCriteria, maxResults = maxResults, nextToken = nextToken, sortCriteria = sortCriteria)
  output <- .inspector2$list_findings_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_findings <- inspector2_list_findings

#' List members associated with the Amazon Inspector delegated
#' administrator for your organization
#'
#' @description
#' List members associated with the Amazon Inspector delegated administrator for your organization.
#'
#' See [https://paws-r.github.io/docs/inspector2/list_members.html](https://paws-r.github.io/docs/inspector2/list_members.html) for full documentation.
#'
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#' @param onlyAssociated Specifies whether to list only currently associated members if `True` or
#' to list all members within the organization if `False`.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_members
inspector2_list_members <- function(maxResults = NULL, nextToken = NULL, onlyAssociated = NULL) {
  op <- new_operation(
    name = "ListMembers",
    http_method = "POST",
    http_path = "/members/list",
    paginator = list()
  )
  input <- .inspector2$list_members_input(maxResults = maxResults, nextToken = nextToken, onlyAssociated = onlyAssociated)
  output <- .inspector2$list_members_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_members <- inspector2_list_members

#' Lists all tags attached to a given resource
#'
#' @description
#' Lists all tags attached to a given resource.
#'
#' See [https://paws-r.github.io/docs/inspector2/list_tags_for_resource.html](https://paws-r.github.io/docs/inspector2/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon resource number (ARN) of the resource to list tags of.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_tags_for_resource
inspector2_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .inspector2$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .inspector2$list_tags_for_resource_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_tags_for_resource <- inspector2_list_tags_for_resource

#' Lists the Amazon Inspector usage totals over the last 30 days
#'
#' @description
#' Lists the Amazon Inspector usage totals over the last 30 days.
#'
#' See [https://paws-r.github.io/docs/inspector2/list_usage_totals.html](https://paws-r.github.io/docs/inspector2/list_usage_totals.html) for full documentation.
#'
#' @param accountIds The Amazon Web Services account IDs to retrieve usage totals for.
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request to a list
#' action. For subsequent calls, use the `NextToken` value returned from
#' the previous request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname inspector2_list_usage_totals
inspector2_list_usage_totals <- function(accountIds = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListUsageTotals",
    http_method = "POST",
    http_path = "/usage/list",
    paginator = list()
  )
  input <- .inspector2$list_usage_totals_input(accountIds = accountIds, maxResults = maxResults, nextToken = nextToken)
  output <- .inspector2$list_usage_totals_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$list_usage_totals <- inspector2_list_usage_totals

#' Adds tags to a resource
#'
#' @description
#' Adds tags to a resource.
#'
#' See [https://paws-r.github.io/docs/inspector2/tag_resource.html](https://paws-r.github.io/docs/inspector2/tag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to apply a tag to.
#' @param tags &#91;required&#93; The tags to be added to a resource.
#'
#' @keywords internal
#'
#' @rdname inspector2_tag_resource
inspector2_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .inspector2$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .inspector2$tag_resource_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$tag_resource <- inspector2_tag_resource

#' Removes tags from a resource
#'
#' @description
#' Removes tags from a resource.
#'
#' See [https://paws-r.github.io/docs/inspector2/untag_resource.html](https://paws-r.github.io/docs/inspector2/untag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource to remove tags from.
#' @param tagKeys &#91;required&#93; The tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname inspector2_untag_resource
inspector2_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .inspector2$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .inspector2$untag_resource_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$untag_resource <- inspector2_untag_resource

#' Updates setting configurations for your Amazon Inspector account
#'
#' @description
#' Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization cannot update this setting.
#'
#' See [https://paws-r.github.io/docs/inspector2/update_configuration.html](https://paws-r.github.io/docs/inspector2/update_configuration.html) for full documentation.
#'
#' @param ecrConfiguration &#91;required&#93; Specifies how the ECR automated re-scan will be updated for your
#' environment.
#'
#' @keywords internal
#'
#' @rdname inspector2_update_configuration
inspector2_update_configuration <- function(ecrConfiguration) {
  op <- new_operation(
    name = "UpdateConfiguration",
    http_method = "POST",
    http_path = "/configuration/update",
    paginator = list()
  )
  input <- .inspector2$update_configuration_input(ecrConfiguration = ecrConfiguration)
  output <- .inspector2$update_configuration_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$update_configuration <- inspector2_update_configuration

#' Specifies the action that is to be applied to the findings that match
#' the filter
#'
#' @description
#' Specifies the action that is to be applied to the findings that match the filter.
#'
#' See [https://paws-r.github.io/docs/inspector2/update_filter.html](https://paws-r.github.io/docs/inspector2/update_filter.html) for full documentation.
#'
#' @param action Specifies the action that is to be applied to the findings that match
#' the filter.
#' @param description A description of the filter.
#' @param filterArn &#91;required&#93; The Amazon Resource Number (ARN) of the filter to update.
#' @param filterCriteria Defines the criteria to be update in the filter.
#' @param name The name of the filter.
#' @param reason The reason the filter was updated.
#'
#' @keywords internal
#'
#' @rdname inspector2_update_filter
inspector2_update_filter <- function(action = NULL, description = NULL, filterArn, filterCriteria = NULL, name = NULL, reason = NULL) {
  op <- new_operation(
    name = "UpdateFilter",
    http_method = "POST",
    http_path = "/filters/update",
    paginator = list()
  )
  input <- .inspector2$update_filter_input(action = action, description = description, filterArn = filterArn, filterCriteria = filterCriteria, name = name, reason = reason)
  output <- .inspector2$update_filter_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$update_filter <- inspector2_update_filter

#' Updates the configurations for your Amazon Inspector organization
#'
#' @description
#' Updates the configurations for your Amazon Inspector organization.
#'
#' See [https://paws-r.github.io/docs/inspector2/update_organization_configuration.html](https://paws-r.github.io/docs/inspector2/update_organization_configuration.html) for full documentation.
#'
#' @param autoEnable &#91;required&#93; Defines which scan types are enabled automatically for new members of
#' your Amazon Inspector organization.
#'
#' @keywords internal
#'
#' @rdname inspector2_update_organization_configuration
inspector2_update_organization_configuration <- function(autoEnable) {
  op <- new_operation(
    name = "UpdateOrganizationConfiguration",
    http_method = "POST",
    http_path = "/organizationconfiguration/update",
    paginator = list()
  )
  input <- .inspector2$update_organization_configuration_input(autoEnable = autoEnable)
  output <- .inspector2$update_organization_configuration_output()
  config <- get_config()
  svc <- .inspector2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector2$operations$update_organization_configuration <- inspector2_update_organization_configuration
