% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iamrolesanywhere_operations.R
\name{iamrolesanywhere_create_profile}
\alias{iamrolesanywhere_create_profile}
\title{Creates a profile}
\usage{
iamrolesanywhere_create_profile(
  durationSeconds = NULL,
  enabled = NULL,
  managedPolicyArns = NULL,
  name,
  requireInstanceProperties = NULL,
  roleArns,
  sessionPolicy = NULL,
  tags = NULL
)
}
\arguments{
\item{durationSeconds}{The number of seconds the vended session credentials are valid for.}

\item{enabled}{Specifies whether the profile is enabled.}

\item{managedPolicyArns}{A list of managed policy ARNs that apply to the vended session
credentials.}

\item{name}{[required] The name of the profile.}

\item{requireInstanceProperties}{Specifies whether instance properties are required in
\href{https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/}{CreateSession}
requests with this profile.}

\item{roleArns}{[required] A list of IAM roles that this profile can assume in a
\href{https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/}{CreateSession}
operation.}

\item{sessionPolicy}{A session policy that applies to the trust boundary of the vended
session credentials.}

\item{tags}{The tags to attach to the profile.}
}
\description{
Creates a profile. A profile is configuration resource to list the roles that RolesAnywhere service is trusted to assume. In addition, by applying a profile you can intersect permissions with IAM managed policies.

See \url{https://paws-r.github.io/docs/iamrolesanywhere/create_profile.html} for full documentation.
}
\keyword{internal}
