# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include securityhub_service.R
NULL

#' Accepts the invitation to be a member account and be monitored by the
#' Security Hub administrator account that the invitation was sent from
#'
#' @description
#' Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the invitation was sent from.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_accept_administrator_invitation/](https://www.paws-r-sdk.com/docs/securityhub_accept_administrator_invitation/) for full documentation.
#'
#' @param AdministratorId &#91;required&#93; The account ID of the Security Hub administrator account that sent the
#' invitation.
#' @param InvitationId &#91;required&#93; The identifier of the invitation sent from the Security Hub
#' administrator account.
#'
#' @keywords internal
#'
#' @rdname securityhub_accept_administrator_invitation
securityhub_accept_administrator_invitation <- function(AdministratorId, InvitationId) {
  op <- new_operation(
    name = "AcceptAdministratorInvitation",
    http_method = "POST",
    http_path = "/administrator",
    paginator = list()
  )
  input <- .securityhub$accept_administrator_invitation_input(AdministratorId = AdministratorId, InvitationId = InvitationId)
  output <- .securityhub$accept_administrator_invitation_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$accept_administrator_invitation <- securityhub_accept_administrator_invitation

#' This method is deprecated
#'
#' @description
#' This method is deprecated. Instead, use [`accept_administrator_invitation`][securityhub_accept_administrator_invitation].
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_accept_invitation/](https://www.paws-r-sdk.com/docs/securityhub_accept_invitation/) for full documentation.
#'
#' @param MasterId &#91;required&#93; The account ID of the Security Hub administrator account that sent the
#' invitation.
#' @param InvitationId &#91;required&#93; The identifier of the invitation sent from the Security Hub
#' administrator account.
#'
#' @keywords internal
#'
#' @rdname securityhub_accept_invitation
securityhub_accept_invitation <- function(MasterId, InvitationId) {
  op <- new_operation(
    name = "AcceptInvitation",
    http_method = "POST",
    http_path = "/master",
    paginator = list()
  )
  input <- .securityhub$accept_invitation_input(MasterId = MasterId, InvitationId = InvitationId)
  output <- .securityhub$accept_invitation_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$accept_invitation <- securityhub_accept_invitation

#' Deletes one or more automation rules
#'
#' @description
#' Deletes one or more automation rules.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_batch_delete_automation_rules/](https://www.paws-r-sdk.com/docs/securityhub_batch_delete_automation_rules/) for full documentation.
#'
#' @param AutomationRulesArns &#91;required&#93; A list of Amazon Resource Names (ARNs) for the rules that are to be
#' deleted.
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_delete_automation_rules
securityhub_batch_delete_automation_rules <- function(AutomationRulesArns) {
  op <- new_operation(
    name = "BatchDeleteAutomationRules",
    http_method = "POST",
    http_path = "/automationrules/delete",
    paginator = list()
  )
  input <- .securityhub$batch_delete_automation_rules_input(AutomationRulesArns = AutomationRulesArns)
  output <- .securityhub$batch_delete_automation_rules_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_delete_automation_rules <- securityhub_batch_delete_automation_rules

#' Disables the standards specified by the provided
#' StandardsSubscriptionArns
#'
#' @description
#' Disables the standards specified by the provided `StandardsSubscriptionArns`.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_batch_disable_standards/](https://www.paws-r-sdk.com/docs/securityhub_batch_disable_standards/) for full documentation.
#'
#' @param StandardsSubscriptionArns &#91;required&#93; The ARNs of the standards subscriptions to disable.
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_disable_standards
securityhub_batch_disable_standards <- function(StandardsSubscriptionArns) {
  op <- new_operation(
    name = "BatchDisableStandards",
    http_method = "POST",
    http_path = "/standards/deregister",
    paginator = list()
  )
  input <- .securityhub$batch_disable_standards_input(StandardsSubscriptionArns = StandardsSubscriptionArns)
  output <- .securityhub$batch_disable_standards_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_disable_standards <- securityhub_batch_disable_standards

#' Enables the standards specified by the provided StandardsArn
#'
#' @description
#' Enables the standards specified by the provided `StandardsArn`. To obtain the ARN for a standard, use the [`describe_standards`][securityhub_describe_standards] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_batch_enable_standards/](https://www.paws-r-sdk.com/docs/securityhub_batch_enable_standards/) for full documentation.
#'
#' @param StandardsSubscriptionRequests &#91;required&#93; The list of standards checks to enable.
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_enable_standards
securityhub_batch_enable_standards <- function(StandardsSubscriptionRequests) {
  op <- new_operation(
    name = "BatchEnableStandards",
    http_method = "POST",
    http_path = "/standards/register",
    paginator = list()
  )
  input <- .securityhub$batch_enable_standards_input(StandardsSubscriptionRequests = StandardsSubscriptionRequests)
  output <- .securityhub$batch_enable_standards_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_enable_standards <- securityhub_batch_enable_standards

#' Retrieves a list of details for automation rules based on rule Amazon
#' Resource Names (ARNs)
#'
#' @description
#' Retrieves a list of details for automation rules based on rule Amazon Resource Names (ARNs).
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_batch_get_automation_rules/](https://www.paws-r-sdk.com/docs/securityhub_batch_get_automation_rules/) for full documentation.
#'
#' @param AutomationRulesArns &#91;required&#93; A list of rule ARNs to get details for.
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_get_automation_rules
securityhub_batch_get_automation_rules <- function(AutomationRulesArns) {
  op <- new_operation(
    name = "BatchGetAutomationRules",
    http_method = "POST",
    http_path = "/automationrules/get",
    paginator = list()
  )
  input <- .securityhub$batch_get_automation_rules_input(AutomationRulesArns = AutomationRulesArns)
  output <- .securityhub$batch_get_automation_rules_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_get_automation_rules <- securityhub_batch_get_automation_rules

#' Provides details about a batch of security controls for the current
#' Amazon Web Services account and Amazon Web Services Region
#'
#' @description
#' Provides details about a batch of security controls for the current Amazon Web Services account and Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_batch_get_security_controls/](https://www.paws-r-sdk.com/docs/securityhub_batch_get_security_controls/) for full documentation.
#'
#' @param SecurityControlIds &#91;required&#93; A list of security controls (identified with `SecurityControlId`,
#' `SecurityControlArn`, or a mix of both parameters). The security control
#' ID or Amazon Resource Name (ARN) is the same across standards.
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_get_security_controls
securityhub_batch_get_security_controls <- function(SecurityControlIds) {
  op <- new_operation(
    name = "BatchGetSecurityControls",
    http_method = "POST",
    http_path = "/securityControls/batchGet",
    paginator = list()
  )
  input <- .securityhub$batch_get_security_controls_input(SecurityControlIds = SecurityControlIds)
  output <- .securityhub$batch_get_security_controls_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_get_security_controls <- securityhub_batch_get_security_controls

#' For a batch of security controls and standards, identifies whether each
#' control is currently enabled or disabled in a standard
#'
#' @description
#' For a batch of security controls and standards, identifies whether each control is currently enabled or disabled in a standard.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_batch_get_standards_control_associations/](https://www.paws-r-sdk.com/docs/securityhub_batch_get_standards_control_associations/) for full documentation.
#'
#' @param StandardsControlAssociationIds &#91;required&#93; An array with one or more objects that includes a security control
#' (identified with `SecurityControlId`, `SecurityControlArn`, or a mix of
#' both parameters) and the Amazon Resource Name (ARN) of a standard. This
#' field is used to query the enablement status of a control in a specified
#' standard. The security control ID or ARN is the same across standards.
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_get_standards_control_associations
securityhub_batch_get_standards_control_associations <- function(StandardsControlAssociationIds) {
  op <- new_operation(
    name = "BatchGetStandardsControlAssociations",
    http_method = "POST",
    http_path = "/associations/batchGet",
    paginator = list()
  )
  input <- .securityhub$batch_get_standards_control_associations_input(StandardsControlAssociationIds = StandardsControlAssociationIds)
  output <- .securityhub$batch_get_standards_control_associations_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_get_standards_control_associations <- securityhub_batch_get_standards_control_associations

#' Imports security findings generated by a finding provider into Security
#' Hub
#'
#' @description
#' Imports security findings generated by a finding provider into Security Hub. This action is requested by the finding provider to import its findings into Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_batch_import_findings/](https://www.paws-r-sdk.com/docs/securityhub_batch_import_findings/) for full documentation.
#'
#' @param Findings &#91;required&#93; A list of findings to import. To successfully import a finding, it must
#' follow the [Amazon Web Services Security Finding
#' Format](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html).
#' Maximum of 100 findings per request.
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_import_findings
securityhub_batch_import_findings <- function(Findings) {
  op <- new_operation(
    name = "BatchImportFindings",
    http_method = "POST",
    http_path = "/findings/import",
    paginator = list()
  )
  input <- .securityhub$batch_import_findings_input(Findings = Findings)
  output <- .securityhub$batch_import_findings_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_import_findings <- securityhub_batch_import_findings

#' Updates one or more automation rules based on rule Amazon Resource Names
#' (ARNs) and input parameters
#'
#' @description
#' Updates one or more automation rules based on rule Amazon Resource Names (ARNs) and input parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_batch_update_automation_rules/](https://www.paws-r-sdk.com/docs/securityhub_batch_update_automation_rules/) for full documentation.
#'
#' @param UpdateAutomationRulesRequestItems &#91;required&#93; An array of ARNs for the rules that are to be updated. Optionally, you
#' can also include `RuleStatus` and `RuleOrder`.
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_update_automation_rules
securityhub_batch_update_automation_rules <- function(UpdateAutomationRulesRequestItems) {
  op <- new_operation(
    name = "BatchUpdateAutomationRules",
    http_method = "PATCH",
    http_path = "/automationrules/update",
    paginator = list()
  )
  input <- .securityhub$batch_update_automation_rules_input(UpdateAutomationRulesRequestItems = UpdateAutomationRulesRequestItems)
  output <- .securityhub$batch_update_automation_rules_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_update_automation_rules <- securityhub_batch_update_automation_rules

#' Used by Security Hub customers to update information about their
#' investigation into a finding
#'
#' @description
#' Used by Security Hub customers to update information about their investigation into a finding. Requested by administrator accounts or member accounts. Administrator accounts can update findings for their account and their member accounts. Member accounts can update findings for their account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_batch_update_findings/](https://www.paws-r-sdk.com/docs/securityhub_batch_update_findings/) for full documentation.
#'
#' @param FindingIdentifiers &#91;required&#93; The list of findings to update.
#' [`batch_update_findings`][securityhub_batch_update_findings] can be used
#' to update up to 100 findings at a time.
#' 
#' For each finding, the list provides the finding identifier and the ARN
#' of the finding provider.
#' @param Note 
#' @param Severity Used to update the finding severity.
#' @param VerificationState Indicates the veracity of a finding.
#' 
#' The available values for `VerificationState` are as follows.
#' 
#' -   `UNKNOWN` – The default disposition of a security finding
#' 
#' -   `TRUE_POSITIVE` – The security finding is confirmed
#' 
#' -   `FALSE_POSITIVE` – The security finding was determined to be a false
#'     alarm
#' 
#' -   `BENIGN_POSITIVE` – A special case of `TRUE_POSITIVE` where the
#'     finding doesn't pose any threat, is expected, or both
#' @param Confidence The updated value for the finding confidence. Confidence is defined as
#' the likelihood that a finding accurately identifies the behavior or
#' issue that it was intended to identify.
#' 
#' Confidence is scored on a 0-100 basis using a ratio scale, where 0 means
#' zero percent confidence and 100 means 100 percent confidence.
#' @param Criticality The updated value for the level of importance assigned to the resources
#' associated with the findings.
#' 
#' A score of 0 means that the underlying resources have no criticality,
#' and a score of 100 is reserved for the most critical resources.
#' @param Types One or more finding types in the format of namespace/category/classifier
#' that classify a finding.
#' 
#' Valid namespace values are as follows.
#' 
#' -   Software and Configuration Checks
#' 
#' -   TTPs
#' 
#' -   Effects
#' 
#' -   Unusual Behaviors
#' 
#' -   Sensitive Data Identifications
#' @param UserDefinedFields A list of name/value string pairs associated with the finding. These are
#' custom, user-defined fields added to a finding.
#' @param Workflow Used to update the workflow status of a finding.
#' 
#' The workflow status indicates the progress of the investigation into the
#' finding.
#' @param RelatedFindings A list of findings that are related to the updated findings.
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_update_findings
securityhub_batch_update_findings <- function(FindingIdentifiers, Note = NULL, Severity = NULL, VerificationState = NULL, Confidence = NULL, Criticality = NULL, Types = NULL, UserDefinedFields = NULL, Workflow = NULL, RelatedFindings = NULL) {
  op <- new_operation(
    name = "BatchUpdateFindings",
    http_method = "PATCH",
    http_path = "/findings/batchupdate",
    paginator = list()
  )
  input <- .securityhub$batch_update_findings_input(FindingIdentifiers = FindingIdentifiers, Note = Note, Severity = Severity, VerificationState = VerificationState, Confidence = Confidence, Criticality = Criticality, Types = Types, UserDefinedFields = UserDefinedFields, Workflow = Workflow, RelatedFindings = RelatedFindings)
  output <- .securityhub$batch_update_findings_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_update_findings <- securityhub_batch_update_findings

#' For a batch of security controls and standards, this operation updates
#' the enablement status of a control in a standard
#'
#' @description
#' For a batch of security controls and standards, this operation updates the enablement status of a control in a standard.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_batch_update_standards_control_associations/](https://www.paws-r-sdk.com/docs/securityhub_batch_update_standards_control_associations/) for full documentation.
#'
#' @param StandardsControlAssociationUpdates &#91;required&#93; Updates the enablement status of a security control in a specified
#' standard.
#'
#' @keywords internal
#'
#' @rdname securityhub_batch_update_standards_control_associations
securityhub_batch_update_standards_control_associations <- function(StandardsControlAssociationUpdates) {
  op <- new_operation(
    name = "BatchUpdateStandardsControlAssociations",
    http_method = "PATCH",
    http_path = "/associations",
    paginator = list()
  )
  input <- .securityhub$batch_update_standards_control_associations_input(StandardsControlAssociationUpdates = StandardsControlAssociationUpdates)
  output <- .securityhub$batch_update_standards_control_associations_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$batch_update_standards_control_associations <- securityhub_batch_update_standards_control_associations

#' Creates a custom action target in Security Hub
#'
#' @description
#' Creates a custom action target in Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_create_action_target/](https://www.paws-r-sdk.com/docs/securityhub_create_action_target/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the custom action target. Can contain up to 20 characters.
#' @param Description &#91;required&#93; The description for the custom action target.
#' @param Id &#91;required&#93; The ID for the custom action target. Can contain up to 20 alphanumeric
#' characters.
#'
#' @keywords internal
#'
#' @rdname securityhub_create_action_target
securityhub_create_action_target <- function(Name, Description, Id) {
  op <- new_operation(
    name = "CreateActionTarget",
    http_method = "POST",
    http_path = "/actionTargets",
    paginator = list()
  )
  input <- .securityhub$create_action_target_input(Name = Name, Description = Description, Id = Id)
  output <- .securityhub$create_action_target_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$create_action_target <- securityhub_create_action_target

#' Creates an automation rule based on input parameters
#'
#' @description
#' Creates an automation rule based on input parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_create_automation_rule/](https://www.paws-r-sdk.com/docs/securityhub_create_automation_rule/) for full documentation.
#'
#' @param Tags User-defined tags that help you label the purpose of a rule.
#' @param RuleStatus Whether the rule is active after it is created. If this parameter is
#' equal to `Enabled`, Security Hub will apply the rule to findings and
#' finding updates after the rule is created. To change the value of this
#' parameter after creating a rule, use
#' [`batch_update_automation_rules`][securityhub_batch_update_automation_rules].
#' @param RuleOrder &#91;required&#93; An integer ranging from 1 to 1000 that represents the order in which the
#' rule action is applied to findings. Security Hub applies rules with
#' lower values for this parameter first.
#' @param RuleName &#91;required&#93; The name of the rule.
#' @param Description &#91;required&#93; A description of the rule.
#' @param IsTerminal Specifies whether a rule is the last to be applied with respect to a
#' finding that matches the rule criteria. This is useful when a finding
#' matches the criteria for multiple rules, and each rule has different
#' actions. If the value of this field is set to `true` for a rule,
#' Security Hub applies the rule action to a finding that matches the rule
#' criteria and won't evaluate other rules for the finding. The default
#' value of this field is `false`.
#' @param Criteria &#91;required&#93; A set of ASFF finding field attributes and corresponding expected values
#' that Security Hub uses to filter findings. If a finding matches the
#' conditions specified in this parameter, Security Hub applies the rule
#' action to the finding.
#' @param Actions &#91;required&#93; One or more actions to update finding fields if a finding matches the
#' conditions specified in `Criteria`.
#'
#' @keywords internal
#'
#' @rdname securityhub_create_automation_rule
securityhub_create_automation_rule <- function(Tags = NULL, RuleStatus = NULL, RuleOrder, RuleName, Description, IsTerminal = NULL, Criteria, Actions) {
  op <- new_operation(
    name = "CreateAutomationRule",
    http_method = "POST",
    http_path = "/automationrules/create",
    paginator = list()
  )
  input <- .securityhub$create_automation_rule_input(Tags = Tags, RuleStatus = RuleStatus, RuleOrder = RuleOrder, RuleName = RuleName, Description = Description, IsTerminal = IsTerminal, Criteria = Criteria, Actions = Actions)
  output <- .securityhub$create_automation_rule_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$create_automation_rule <- securityhub_create_automation_rule

#' Used to enable finding aggregation
#'
#' @description
#' Used to enable finding aggregation. Must be called from the aggregation Region.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_create_finding_aggregator/](https://www.paws-r-sdk.com/docs/securityhub_create_finding_aggregator/) for full documentation.
#'
#' @param RegionLinkingMode &#91;required&#93; Indicates whether to aggregate findings from all of the available
#' Regions in the current partition. Also determines whether to
#' automatically aggregate findings from new Regions as Security Hub
#' supports them and you opt into them.
#' 
#' The selected option also determines how to use the Regions provided in
#' the Regions list.
#' 
#' The options are as follows:
#' 
#' -   `ALL_REGIONS` - Indicates to aggregate findings from all of the
#'     Regions where Security Hub is enabled. When you choose this option,
#'     Security Hub also automatically aggregates findings from new Regions
#'     as Security Hub supports them and you opt into them.
#' 
#' -   `ALL_REGIONS_EXCEPT_SPECIFIED` - Indicates to aggregate findings
#'     from all of the Regions where Security Hub is enabled, except for
#'     the Regions listed in the `Regions` parameter. When you choose this
#'     option, Security Hub also automatically aggregates findings from new
#'     Regions as Security Hub supports them and you opt into them.
#' 
#' -   `SPECIFIED_REGIONS` - Indicates to aggregate findings only from the
#'     Regions listed in the `Regions` parameter. Security Hub does not
#'     automatically aggregate findings from new Regions.
#' @param Regions If `RegionLinkingMode` is `ALL_REGIONS_EXCEPT_SPECIFIED`, then this is a
#' space-separated list of Regions that do not aggregate findings to the
#' aggregation Region.
#' 
#' If `RegionLinkingMode` is `SPECIFIED_REGIONS`, then this is a
#' space-separated list of Regions that do aggregate findings to the
#' aggregation Region.
#'
#' @keywords internal
#'
#' @rdname securityhub_create_finding_aggregator
securityhub_create_finding_aggregator <- function(RegionLinkingMode, Regions = NULL) {
  op <- new_operation(
    name = "CreateFindingAggregator",
    http_method = "POST",
    http_path = "/findingAggregator/create",
    paginator = list()
  )
  input <- .securityhub$create_finding_aggregator_input(RegionLinkingMode = RegionLinkingMode, Regions = Regions)
  output <- .securityhub$create_finding_aggregator_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$create_finding_aggregator <- securityhub_create_finding_aggregator

#' Creates a custom insight in Security Hub
#'
#' @description
#' Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security issue that requires attention or remediation.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_create_insight/](https://www.paws-r-sdk.com/docs/securityhub_create_insight/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the custom insight to create.
#' @param Filters &#91;required&#93; One or more attributes used to filter the findings included in the
#' insight. The insight only includes findings that match the criteria
#' defined in the filters.
#' @param GroupByAttribute &#91;required&#93; The attribute used to group the findings for the insight. The grouping
#' attribute identifies the type of item that the insight applies to. For
#' example, if an insight is grouped by resource identifier, then the
#' insight produces a list of resource identifiers.
#'
#' @keywords internal
#'
#' @rdname securityhub_create_insight
securityhub_create_insight <- function(Name, Filters, GroupByAttribute) {
  op <- new_operation(
    name = "CreateInsight",
    http_method = "POST",
    http_path = "/insights",
    paginator = list()
  )
  input <- .securityhub$create_insight_input(Name = Name, Filters = Filters, GroupByAttribute = GroupByAttribute)
  output <- .securityhub$create_insight_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$create_insight <- securityhub_create_insight

#' Creates a member association in Security Hub between the specified
#' accounts and the account used to make the request, which is the
#' administrator account
#'
#' @description
#' Creates a member association in Security Hub between the specified accounts and the account used to make the request, which is the administrator account. If you are integrated with Organizations, then the administrator account is designated by the organization management account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_create_members/](https://www.paws-r-sdk.com/docs/securityhub_create_members/) for full documentation.
#'
#' @param AccountDetails &#91;required&#93; The list of accounts to associate with the Security Hub administrator
#' account. For each account, the list includes the account ID and
#' optionally the email address.
#'
#' @keywords internal
#'
#' @rdname securityhub_create_members
securityhub_create_members <- function(AccountDetails) {
  op <- new_operation(
    name = "CreateMembers",
    http_method = "POST",
    http_path = "/members",
    paginator = list()
  )
  input <- .securityhub$create_members_input(AccountDetails = AccountDetails)
  output <- .securityhub$create_members_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$create_members <- securityhub_create_members

#' Declines invitations to become a member account
#'
#' @description
#' Declines invitations to become a member account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_decline_invitations/](https://www.paws-r-sdk.com/docs/securityhub_decline_invitations/) for full documentation.
#'
#' @param AccountIds &#91;required&#93; The list of prospective member account IDs for which to decline an
#' invitation.
#'
#' @keywords internal
#'
#' @rdname securityhub_decline_invitations
securityhub_decline_invitations <- function(AccountIds) {
  op <- new_operation(
    name = "DeclineInvitations",
    http_method = "POST",
    http_path = "/invitations/decline",
    paginator = list()
  )
  input <- .securityhub$decline_invitations_input(AccountIds = AccountIds)
  output <- .securityhub$decline_invitations_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$decline_invitations <- securityhub_decline_invitations

#' Deletes a custom action target from Security Hub
#'
#' @description
#' Deletes a custom action target from Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_delete_action_target/](https://www.paws-r-sdk.com/docs/securityhub_delete_action_target/) for full documentation.
#'
#' @param ActionTargetArn &#91;required&#93; The Amazon Resource Name (ARN) of the custom action target to delete.
#'
#' @keywords internal
#'
#' @rdname securityhub_delete_action_target
securityhub_delete_action_target <- function(ActionTargetArn) {
  op <- new_operation(
    name = "DeleteActionTarget",
    http_method = "DELETE",
    http_path = "/actionTargets/{ActionTargetArn+}",
    paginator = list()
  )
  input <- .securityhub$delete_action_target_input(ActionTargetArn = ActionTargetArn)
  output <- .securityhub$delete_action_target_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$delete_action_target <- securityhub_delete_action_target

#' Deletes a finding aggregator
#'
#' @description
#' Deletes a finding aggregator. When you delete the finding aggregator, you stop finding aggregation.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_delete_finding_aggregator/](https://www.paws-r-sdk.com/docs/securityhub_delete_finding_aggregator/) for full documentation.
#'
#' @param FindingAggregatorArn &#91;required&#93; The ARN of the finding aggregator to delete. To obtain the ARN, use
#' [`list_finding_aggregators`][securityhub_list_finding_aggregators].
#'
#' @keywords internal
#'
#' @rdname securityhub_delete_finding_aggregator
securityhub_delete_finding_aggregator <- function(FindingAggregatorArn) {
  op <- new_operation(
    name = "DeleteFindingAggregator",
    http_method = "DELETE",
    http_path = "/findingAggregator/delete/{FindingAggregatorArn+}",
    paginator = list()
  )
  input <- .securityhub$delete_finding_aggregator_input(FindingAggregatorArn = FindingAggregatorArn)
  output <- .securityhub$delete_finding_aggregator_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$delete_finding_aggregator <- securityhub_delete_finding_aggregator

#' Deletes the insight specified by the InsightArn
#'
#' @description
#' Deletes the insight specified by the `InsightArn`.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_delete_insight/](https://www.paws-r-sdk.com/docs/securityhub_delete_insight/) for full documentation.
#'
#' @param InsightArn &#91;required&#93; The ARN of the insight to delete.
#'
#' @keywords internal
#'
#' @rdname securityhub_delete_insight
securityhub_delete_insight <- function(InsightArn) {
  op <- new_operation(
    name = "DeleteInsight",
    http_method = "DELETE",
    http_path = "/insights/{InsightArn+}",
    paginator = list()
  )
  input <- .securityhub$delete_insight_input(InsightArn = InsightArn)
  output <- .securityhub$delete_insight_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$delete_insight <- securityhub_delete_insight

#' Deletes invitations received by the Amazon Web Services account to
#' become a member account
#'
#' @description
#' Deletes invitations received by the Amazon Web Services account to become a member account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_delete_invitations/](https://www.paws-r-sdk.com/docs/securityhub_delete_invitations/) for full documentation.
#'
#' @param AccountIds &#91;required&#93; The list of member account IDs that received the invitations you want to
#' delete.
#'
#' @keywords internal
#'
#' @rdname securityhub_delete_invitations
securityhub_delete_invitations <- function(AccountIds) {
  op <- new_operation(
    name = "DeleteInvitations",
    http_method = "POST",
    http_path = "/invitations/delete",
    paginator = list()
  )
  input <- .securityhub$delete_invitations_input(AccountIds = AccountIds)
  output <- .securityhub$delete_invitations_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$delete_invitations <- securityhub_delete_invitations

#' Deletes the specified member accounts from Security Hub
#'
#' @description
#' Deletes the specified member accounts from Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_delete_members/](https://www.paws-r-sdk.com/docs/securityhub_delete_members/) for full documentation.
#'
#' @param AccountIds &#91;required&#93; The list of account IDs for the member accounts to delete.
#'
#' @keywords internal
#'
#' @rdname securityhub_delete_members
securityhub_delete_members <- function(AccountIds) {
  op <- new_operation(
    name = "DeleteMembers",
    http_method = "POST",
    http_path = "/members/delete",
    paginator = list()
  )
  input <- .securityhub$delete_members_input(AccountIds = AccountIds)
  output <- .securityhub$delete_members_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$delete_members <- securityhub_delete_members

#' Returns a list of the custom action targets in Security Hub in your
#' account
#'
#' @description
#' Returns a list of the custom action targets in Security Hub in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_describe_action_targets/](https://www.paws-r-sdk.com/docs/securityhub_describe_action_targets/) for full documentation.
#'
#' @param ActionTargetArns A list of custom action target ARNs for the custom action targets to
#' retrieve.
#' @param NextToken The token that is required for pagination. On your first call to the
#' [`describe_action_targets`][securityhub_describe_action_targets]
#' operation, set the value of this parameter to `NULL`.
#' 
#' For subsequent calls to the operation, to continue listing data, set the
#' value of this parameter to the value returned from the previous
#' response.
#' @param MaxResults The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname securityhub_describe_action_targets
securityhub_describe_action_targets <- function(ActionTargetArns = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeActionTargets",
    http_method = "POST",
    http_path = "/actionTargets/get",
    paginator = list()
  )
  input <- .securityhub$describe_action_targets_input(ActionTargetArns = ActionTargetArns, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$describe_action_targets_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$describe_action_targets <- securityhub_describe_action_targets

#' Returns details about the Hub resource in your account, including the
#' HubArn and the time when you enabled Security Hub
#'
#' @description
#' Returns details about the Hub resource in your account, including the `HubArn` and the time when you enabled Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_describe_hub/](https://www.paws-r-sdk.com/docs/securityhub_describe_hub/) for full documentation.
#'
#' @param HubArn The ARN of the Hub resource to retrieve.
#'
#' @keywords internal
#'
#' @rdname securityhub_describe_hub
securityhub_describe_hub <- function(HubArn = NULL) {
  op <- new_operation(
    name = "DescribeHub",
    http_method = "GET",
    http_path = "/accounts",
    paginator = list()
  )
  input <- .securityhub$describe_hub_input(HubArn = HubArn)
  output <- .securityhub$describe_hub_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$describe_hub <- securityhub_describe_hub

#' Returns information about the Organizations configuration for Security
#' Hub
#'
#' @description
#' Returns information about the Organizations configuration for Security Hub. Can only be called from a Security Hub administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_describe_organization_configuration/](https://www.paws-r-sdk.com/docs/securityhub_describe_organization_configuration/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname securityhub_describe_organization_configuration
securityhub_describe_organization_configuration <- function() {
  op <- new_operation(
    name = "DescribeOrganizationConfiguration",
    http_method = "GET",
    http_path = "/organization/configuration",
    paginator = list()
  )
  input <- .securityhub$describe_organization_configuration_input()
  output <- .securityhub$describe_organization_configuration_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$describe_organization_configuration <- securityhub_describe_organization_configuration

#' Returns information about product integrations in Security Hub
#'
#' @description
#' Returns information about product integrations in Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_describe_products/](https://www.paws-r-sdk.com/docs/securityhub_describe_products/) for full documentation.
#'
#' @param NextToken The token that is required for pagination. On your first call to the
#' [`describe_products`][securityhub_describe_products] operation, set the
#' value of this parameter to `NULL`.
#' 
#' For subsequent calls to the operation, to continue listing data, set the
#' value of this parameter to the value returned from the previous
#' response.
#' @param MaxResults The maximum number of results to return.
#' @param ProductArn The ARN of the integration to return.
#'
#' @keywords internal
#'
#' @rdname securityhub_describe_products
securityhub_describe_products <- function(NextToken = NULL, MaxResults = NULL, ProductArn = NULL) {
  op <- new_operation(
    name = "DescribeProducts",
    http_method = "GET",
    http_path = "/products",
    paginator = list()
  )
  input <- .securityhub$describe_products_input(NextToken = NextToken, MaxResults = MaxResults, ProductArn = ProductArn)
  output <- .securityhub$describe_products_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$describe_products <- securityhub_describe_products

#' Returns a list of the available standards in Security Hub
#'
#' @description
#' Returns a list of the available standards in Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_describe_standards/](https://www.paws-r-sdk.com/docs/securityhub_describe_standards/) for full documentation.
#'
#' @param NextToken The token that is required for pagination. On your first call to the
#' [`describe_standards`][securityhub_describe_standards] operation, set
#' the value of this parameter to `NULL`.
#' 
#' For subsequent calls to the operation, to continue listing data, set the
#' value of this parameter to the value returned from the previous
#' response.
#' @param MaxResults The maximum number of standards to return.
#'
#' @keywords internal
#'
#' @rdname securityhub_describe_standards
securityhub_describe_standards <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeStandards",
    http_method = "GET",
    http_path = "/standards",
    paginator = list()
  )
  input <- .securityhub$describe_standards_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$describe_standards_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$describe_standards <- securityhub_describe_standards

#' Returns a list of security standards controls
#'
#' @description
#' Returns a list of security standards controls.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_describe_standards_controls/](https://www.paws-r-sdk.com/docs/securityhub_describe_standards_controls/) for full documentation.
#'
#' @param StandardsSubscriptionArn &#91;required&#93; The ARN of a resource that represents your subscription to a supported
#' standard. To get the subscription ARNs of the standards you have
#' enabled, use the
#' [`get_enabled_standards`][securityhub_get_enabled_standards] operation.
#' @param NextToken The token that is required for pagination. On your first call to the
#' [`describe_standards_controls`][securityhub_describe_standards_controls]
#' operation, set the value of this parameter to `NULL`.
#' 
#' For subsequent calls to the operation, to continue listing data, set the
#' value of this parameter to the value returned from the previous
#' response.
#' @param MaxResults The maximum number of security standard controls to return.
#'
#' @keywords internal
#'
#' @rdname securityhub_describe_standards_controls
securityhub_describe_standards_controls <- function(StandardsSubscriptionArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeStandardsControls",
    http_method = "GET",
    http_path = "/standards/controls/{StandardsSubscriptionArn+}",
    paginator = list()
  )
  input <- .securityhub$describe_standards_controls_input(StandardsSubscriptionArn = StandardsSubscriptionArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$describe_standards_controls_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$describe_standards_controls <- securityhub_describe_standards_controls

#' Disables the integration of the specified product with Security Hub
#'
#' @description
#' Disables the integration of the specified product with Security Hub. After the integration is disabled, findings from that product are no longer sent to Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_disable_import_findings_for_product/](https://www.paws-r-sdk.com/docs/securityhub_disable_import_findings_for_product/) for full documentation.
#'
#' @param ProductSubscriptionArn &#91;required&#93; The ARN of the integrated product to disable the integration for.
#'
#' @keywords internal
#'
#' @rdname securityhub_disable_import_findings_for_product
securityhub_disable_import_findings_for_product <- function(ProductSubscriptionArn) {
  op <- new_operation(
    name = "DisableImportFindingsForProduct",
    http_method = "DELETE",
    http_path = "/productSubscriptions/{ProductSubscriptionArn+}",
    paginator = list()
  )
  input <- .securityhub$disable_import_findings_for_product_input(ProductSubscriptionArn = ProductSubscriptionArn)
  output <- .securityhub$disable_import_findings_for_product_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$disable_import_findings_for_product <- securityhub_disable_import_findings_for_product

#' Disables a Security Hub administrator account
#'
#' @description
#' Disables a Security Hub administrator account. Can only be called by the organization management account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_disable_organization_admin_account/](https://www.paws-r-sdk.com/docs/securityhub_disable_organization_admin_account/) for full documentation.
#'
#' @param AdminAccountId &#91;required&#93; The Amazon Web Services account identifier of the Security Hub
#' administrator account.
#'
#' @keywords internal
#'
#' @rdname securityhub_disable_organization_admin_account
securityhub_disable_organization_admin_account <- function(AdminAccountId) {
  op <- new_operation(
    name = "DisableOrganizationAdminAccount",
    http_method = "POST",
    http_path = "/organization/admin/disable",
    paginator = list()
  )
  input <- .securityhub$disable_organization_admin_account_input(AdminAccountId = AdminAccountId)
  output <- .securityhub$disable_organization_admin_account_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$disable_organization_admin_account <- securityhub_disable_organization_admin_account

#' Disables Security Hub in your account only in the current Region
#'
#' @description
#' Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you must submit one request per Region where you have enabled Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_disable_security_hub/](https://www.paws-r-sdk.com/docs/securityhub_disable_security_hub/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname securityhub_disable_security_hub
securityhub_disable_security_hub <- function() {
  op <- new_operation(
    name = "DisableSecurityHub",
    http_method = "DELETE",
    http_path = "/accounts",
    paginator = list()
  )
  input <- .securityhub$disable_security_hub_input()
  output <- .securityhub$disable_security_hub_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$disable_security_hub <- securityhub_disable_security_hub

#' Disassociates the current Security Hub member account from the
#' associated administrator account
#'
#' @description
#' Disassociates the current Security Hub member account from the associated administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_disassociate_from_administrator_account/](https://www.paws-r-sdk.com/docs/securityhub_disassociate_from_administrator_account/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname securityhub_disassociate_from_administrator_account
securityhub_disassociate_from_administrator_account <- function() {
  op <- new_operation(
    name = "DisassociateFromAdministratorAccount",
    http_method = "POST",
    http_path = "/administrator/disassociate",
    paginator = list()
  )
  input <- .securityhub$disassociate_from_administrator_account_input()
  output <- .securityhub$disassociate_from_administrator_account_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$disassociate_from_administrator_account <- securityhub_disassociate_from_administrator_account

#' This method is deprecated
#'
#' @description
#' This method is deprecated. Instead, use [`disassociate_from_administrator_account`][securityhub_disassociate_from_administrator_account].
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_disassociate_from_master_account/](https://www.paws-r-sdk.com/docs/securityhub_disassociate_from_master_account/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname securityhub_disassociate_from_master_account
securityhub_disassociate_from_master_account <- function() {
  op <- new_operation(
    name = "DisassociateFromMasterAccount",
    http_method = "POST",
    http_path = "/master/disassociate",
    paginator = list()
  )
  input <- .securityhub$disassociate_from_master_account_input()
  output <- .securityhub$disassociate_from_master_account_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$disassociate_from_master_account <- securityhub_disassociate_from_master_account

#' Disassociates the specified member accounts from the associated
#' administrator account
#'
#' @description
#' Disassociates the specified member accounts from the associated administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_disassociate_members/](https://www.paws-r-sdk.com/docs/securityhub_disassociate_members/) for full documentation.
#'
#' @param AccountIds &#91;required&#93; The account IDs of the member accounts to disassociate from the
#' administrator account.
#'
#' @keywords internal
#'
#' @rdname securityhub_disassociate_members
securityhub_disassociate_members <- function(AccountIds) {
  op <- new_operation(
    name = "DisassociateMembers",
    http_method = "POST",
    http_path = "/members/disassociate",
    paginator = list()
  )
  input <- .securityhub$disassociate_members_input(AccountIds = AccountIds)
  output <- .securityhub$disassociate_members_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$disassociate_members <- securityhub_disassociate_members

#' Enables the integration of a partner product with Security Hub
#'
#' @description
#' Enables the integration of a partner product with Security Hub. Integrated products send findings to Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_enable_import_findings_for_product/](https://www.paws-r-sdk.com/docs/securityhub_enable_import_findings_for_product/) for full documentation.
#'
#' @param ProductArn &#91;required&#93; The ARN of the product to enable the integration for.
#'
#' @keywords internal
#'
#' @rdname securityhub_enable_import_findings_for_product
securityhub_enable_import_findings_for_product <- function(ProductArn) {
  op <- new_operation(
    name = "EnableImportFindingsForProduct",
    http_method = "POST",
    http_path = "/productSubscriptions",
    paginator = list()
  )
  input <- .securityhub$enable_import_findings_for_product_input(ProductArn = ProductArn)
  output <- .securityhub$enable_import_findings_for_product_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$enable_import_findings_for_product <- securityhub_enable_import_findings_for_product

#' Designates the Security Hub administrator account for an organization
#'
#' @description
#' Designates the Security Hub administrator account for an organization. Can only be called by the organization management account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_enable_organization_admin_account/](https://www.paws-r-sdk.com/docs/securityhub_enable_organization_admin_account/) for full documentation.
#'
#' @param AdminAccountId &#91;required&#93; The Amazon Web Services account identifier of the account to designate
#' as the Security Hub administrator account.
#'
#' @keywords internal
#'
#' @rdname securityhub_enable_organization_admin_account
securityhub_enable_organization_admin_account <- function(AdminAccountId) {
  op <- new_operation(
    name = "EnableOrganizationAdminAccount",
    http_method = "POST",
    http_path = "/organization/admin/enable",
    paginator = list()
  )
  input <- .securityhub$enable_organization_admin_account_input(AdminAccountId = AdminAccountId)
  output <- .securityhub$enable_organization_admin_account_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$enable_organization_admin_account <- securityhub_enable_organization_admin_account

#' Enables Security Hub for your account in the current Region or the
#' Region you specify in the request
#'
#' @description
#' Enables Security Hub for your account in the current Region or the Region you specify in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_enable_security_hub/](https://www.paws-r-sdk.com/docs/securityhub_enable_security_hub/) for full documentation.
#'
#' @param Tags The tags to add to the hub resource when you enable Security Hub.
#' @param EnableDefaultStandards Whether to enable the security standards that Security Hub has
#' designated as automatically enabled. If you do not provide a value for
#' `EnableDefaultStandards`, it is set to `true`. To not enable the
#' automatically enabled standards, set `EnableDefaultStandards` to
#' `false`.
#' @param ControlFindingGenerator This field, used when enabling Security Hub, specifies whether the
#' calling account has consolidated control findings turned on. If the
#' value for this field is set to `SECURITY_CONTROL`, Security Hub
#' generates a single finding for a control check even when the check
#' applies to multiple enabled standards.
#' 
#' If the value for this field is set to `STANDARD_CONTROL`, Security Hub
#' generates separate findings for a control check when the check applies
#' to multiple enabled standards.
#' 
#' The value for this field in a member account matches the value in the
#' administrator account. For accounts that aren't part of an organization,
#' the default value of this field is `SECURITY_CONTROL` if you enabled
#' Security Hub on or after February 23, 2023.
#'
#' @keywords internal
#'
#' @rdname securityhub_enable_security_hub
securityhub_enable_security_hub <- function(Tags = NULL, EnableDefaultStandards = NULL, ControlFindingGenerator = NULL) {
  op <- new_operation(
    name = "EnableSecurityHub",
    http_method = "POST",
    http_path = "/accounts",
    paginator = list()
  )
  input <- .securityhub$enable_security_hub_input(Tags = Tags, EnableDefaultStandards = EnableDefaultStandards, ControlFindingGenerator = ControlFindingGenerator)
  output <- .securityhub$enable_security_hub_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$enable_security_hub <- securityhub_enable_security_hub

#' Provides the details for the Security Hub administrator account for the
#' current member account
#'
#' @description
#' Provides the details for the Security Hub administrator account for the current member account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_get_administrator_account/](https://www.paws-r-sdk.com/docs/securityhub_get_administrator_account/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname securityhub_get_administrator_account
securityhub_get_administrator_account <- function() {
  op <- new_operation(
    name = "GetAdministratorAccount",
    http_method = "GET",
    http_path = "/administrator",
    paginator = list()
  )
  input <- .securityhub$get_administrator_account_input()
  output <- .securityhub$get_administrator_account_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_administrator_account <- securityhub_get_administrator_account

#' Returns a list of the standards that are currently enabled
#'
#' @description
#' Returns a list of the standards that are currently enabled.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_get_enabled_standards/](https://www.paws-r-sdk.com/docs/securityhub_get_enabled_standards/) for full documentation.
#'
#' @param StandardsSubscriptionArns The list of the standards subscription ARNs for the standards to
#' retrieve.
#' @param NextToken The token that is required for pagination. On your first call to the
#' [`get_enabled_standards`][securityhub_get_enabled_standards] operation,
#' set the value of this parameter to `NULL`.
#' 
#' For subsequent calls to the operation, to continue listing data, set the
#' value of this parameter to the value returned from the previous
#' response.
#' @param MaxResults The maximum number of results to return in the response.
#'
#' @keywords internal
#'
#' @rdname securityhub_get_enabled_standards
securityhub_get_enabled_standards <- function(StandardsSubscriptionArns = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetEnabledStandards",
    http_method = "POST",
    http_path = "/standards/get",
    paginator = list()
  )
  input <- .securityhub$get_enabled_standards_input(StandardsSubscriptionArns = StandardsSubscriptionArns, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$get_enabled_standards_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_enabled_standards <- securityhub_get_enabled_standards

#' Returns the current finding aggregation configuration
#'
#' @description
#' Returns the current finding aggregation configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_get_finding_aggregator/](https://www.paws-r-sdk.com/docs/securityhub_get_finding_aggregator/) for full documentation.
#'
#' @param FindingAggregatorArn &#91;required&#93; The ARN of the finding aggregator to return details for. To obtain the
#' ARN, use
#' [`list_finding_aggregators`][securityhub_list_finding_aggregators].
#'
#' @keywords internal
#'
#' @rdname securityhub_get_finding_aggregator
securityhub_get_finding_aggregator <- function(FindingAggregatorArn) {
  op <- new_operation(
    name = "GetFindingAggregator",
    http_method = "GET",
    http_path = "/findingAggregator/get/{FindingAggregatorArn+}",
    paginator = list()
  )
  input <- .securityhub$get_finding_aggregator_input(FindingAggregatorArn = FindingAggregatorArn)
  output <- .securityhub$get_finding_aggregator_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_finding_aggregator <- securityhub_get_finding_aggregator

#' Returns history for a Security Hub finding in the last 90 days
#'
#' @description
#' Returns history for a Security Hub finding in the last 90 days. The history includes changes made to any fields in the Amazon Web Services Security Finding Format (ASFF).
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_get_finding_history/](https://www.paws-r-sdk.com/docs/securityhub_get_finding_history/) for full documentation.
#'
#' @param FindingIdentifier &#91;required&#93; 
#' @param StartTime An ISO 8601-formatted timestamp that indicates the start time of the
#' requested finding history. A correctly formatted example is
#' `2020-05-21T20:16:34.724Z`. The value cannot contain spaces, and date
#' and time should be separated by `T`. For more information, see [RFC 3339
#' section 5.6, Internet Date/Time
#' Format](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
#' 
#' If you provide values for both `StartTime` and `EndTime`, Security Hub
#' returns finding history for the specified time period. If you provide a
#' value for `StartTime` but not for `EndTime`, Security Hub returns
#' finding history from the `StartTime` to the time at which the API is
#' called. If you provide a value for `EndTime` but not for `StartTime`,
#' Security Hub returns finding history from the
#' [CreatedAt](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt)
#' timestamp of the finding to the `EndTime`. If you provide neither
#' `StartTime` nor `EndTime`, Security Hub returns finding history from the
#' CreatedAt timestamp of the finding to the time at which the API is
#' called. In all of these scenarios, the response is limited to 100
#' results, and the maximum time period is limited to 90 days.
#' @param EndTime An ISO 8601-formatted timestamp that indicates the end time of the
#' requested finding history. A correctly formatted example is
#' `2020-05-21T20:16:34.724Z`. The value cannot contain spaces, and date
#' and time should be separated by `T`. For more information, see [RFC 3339
#' section 5.6, Internet Date/Time
#' Format](https://www.rfc-editor.org/rfc/rfc3339#section-5.6).
#' 
#' If you provide values for both `StartTime` and `EndTime`, Security Hub
#' returns finding history for the specified time period. If you provide a
#' value for `StartTime` but not for `EndTime`, Security Hub returns
#' finding history from the `StartTime` to the time at which the API is
#' called. If you provide a value for `EndTime` but not for `StartTime`,
#' Security Hub returns finding history from the
#' [CreatedAt](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt)
#' timestamp of the finding to the `EndTime`. If you provide neither
#' `StartTime` nor `EndTime`, Security Hub returns finding history from the
#' CreatedAt timestamp of the finding to the time at which the API is
#' called. In all of these scenarios, the response is limited to 100
#' results, and the maximum time period is limited to 90 days.
#' @param NextToken A token for pagination purposes. Provide `NULL` as the initial value. In
#' subsequent requests, provide the token included in the response to get
#' up to an additional 100 results of finding history. If you don’t provide
#' `NextToken`, Security Hub returns up to 100 results of finding history
#' for each request.
#' @param MaxResults The maximum number of results to be returned. If you don’t provide it,
#' Security Hub returns up to 100 results of finding history.
#'
#' @keywords internal
#'
#' @rdname securityhub_get_finding_history
securityhub_get_finding_history <- function(FindingIdentifier, StartTime = NULL, EndTime = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetFindingHistory",
    http_method = "POST",
    http_path = "/findingHistory/get",
    paginator = list()
  )
  input <- .securityhub$get_finding_history_input(FindingIdentifier = FindingIdentifier, StartTime = StartTime, EndTime = EndTime, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$get_finding_history_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_finding_history <- securityhub_get_finding_history

#' Returns a list of findings that match the specified criteria
#'
#' @description
#' Returns a list of findings that match the specified criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_get_findings/](https://www.paws-r-sdk.com/docs/securityhub_get_findings/) for full documentation.
#'
#' @param Filters The finding attributes used to define a condition to filter the returned
#' findings.
#' 
#' You can filter by up to 10 finding attributes. For each attribute, you
#' can provide up to 20 filter values.
#' 
#' Note that in the available filter fields, `WorkflowState` is deprecated.
#' To search for a finding based on its workflow status, use
#' `WorkflowStatus`.
#' @param SortCriteria The finding attributes used to sort the list of returned findings.
#' @param NextToken The token that is required for pagination. On your first call to the
#' [`get_findings`][securityhub_get_findings] operation, set the value of
#' this parameter to `NULL`.
#' 
#' For subsequent calls to the operation, to continue listing data, set the
#' value of this parameter to the value returned from the previous
#' response.
#' @param MaxResults The maximum number of findings to return.
#'
#' @keywords internal
#'
#' @rdname securityhub_get_findings
securityhub_get_findings <- function(Filters = NULL, SortCriteria = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetFindings",
    http_method = "POST",
    http_path = "/findings",
    paginator = list()
  )
  input <- .securityhub$get_findings_input(Filters = Filters, SortCriteria = SortCriteria, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$get_findings_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_findings <- securityhub_get_findings

#' Lists the results of the Security Hub insight specified by the insight
#' ARN
#'
#' @description
#' Lists the results of the Security Hub insight specified by the insight ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_get_insight_results/](https://www.paws-r-sdk.com/docs/securityhub_get_insight_results/) for full documentation.
#'
#' @param InsightArn &#91;required&#93; The ARN of the insight for which to return results.
#'
#' @keywords internal
#'
#' @rdname securityhub_get_insight_results
securityhub_get_insight_results <- function(InsightArn) {
  op <- new_operation(
    name = "GetInsightResults",
    http_method = "GET",
    http_path = "/insights/results/{InsightArn+}",
    paginator = list()
  )
  input <- .securityhub$get_insight_results_input(InsightArn = InsightArn)
  output <- .securityhub$get_insight_results_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_insight_results <- securityhub_get_insight_results

#' Lists and describes insights for the specified insight ARNs
#'
#' @description
#' Lists and describes insights for the specified insight ARNs.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_get_insights/](https://www.paws-r-sdk.com/docs/securityhub_get_insights/) for full documentation.
#'
#' @param InsightArns The ARNs of the insights to describe. If you do not provide any insight
#' ARNs, then [`get_insights`][securityhub_get_insights] returns all of
#' your custom insights. It does not return any managed insights.
#' @param NextToken The token that is required for pagination. On your first call to the
#' [`get_insights`][securityhub_get_insights] operation, set the value of
#' this parameter to `NULL`.
#' 
#' For subsequent calls to the operation, to continue listing data, set the
#' value of this parameter to the value returned from the previous
#' response.
#' @param MaxResults The maximum number of items to return in the response.
#'
#' @keywords internal
#'
#' @rdname securityhub_get_insights
securityhub_get_insights <- function(InsightArns = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetInsights",
    http_method = "POST",
    http_path = "/insights/get",
    paginator = list()
  )
  input <- .securityhub$get_insights_input(InsightArns = InsightArns, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$get_insights_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_insights <- securityhub_get_insights

#' Returns the count of all Security Hub membership invitations that were
#' sent to the current member account, not including the currently accepted
#' invitation
#'
#' @description
#' Returns the count of all Security Hub membership invitations that were sent to the current member account, not including the currently accepted invitation.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_get_invitations_count/](https://www.paws-r-sdk.com/docs/securityhub_get_invitations_count/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname securityhub_get_invitations_count
securityhub_get_invitations_count <- function() {
  op <- new_operation(
    name = "GetInvitationsCount",
    http_method = "GET",
    http_path = "/invitations/count",
    paginator = list()
  )
  input <- .securityhub$get_invitations_count_input()
  output <- .securityhub$get_invitations_count_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_invitations_count <- securityhub_get_invitations_count

#' This method is deprecated
#'
#' @description
#' This method is deprecated. Instead, use [`get_administrator_account`][securityhub_get_administrator_account].
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_get_master_account/](https://www.paws-r-sdk.com/docs/securityhub_get_master_account/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname securityhub_get_master_account
securityhub_get_master_account <- function() {
  op <- new_operation(
    name = "GetMasterAccount",
    http_method = "GET",
    http_path = "/master",
    paginator = list()
  )
  input <- .securityhub$get_master_account_input()
  output <- .securityhub$get_master_account_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_master_account <- securityhub_get_master_account

#' Returns the details for the Security Hub member accounts for the
#' specified account IDs
#'
#' @description
#' Returns the details for the Security Hub member accounts for the specified account IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_get_members/](https://www.paws-r-sdk.com/docs/securityhub_get_members/) for full documentation.
#'
#' @param AccountIds &#91;required&#93; The list of account IDs for the Security Hub member accounts to return
#' the details for.
#'
#' @keywords internal
#'
#' @rdname securityhub_get_members
securityhub_get_members <- function(AccountIds) {
  op <- new_operation(
    name = "GetMembers",
    http_method = "POST",
    http_path = "/members/get",
    paginator = list()
  )
  input <- .securityhub$get_members_input(AccountIds = AccountIds)
  output <- .securityhub$get_members_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$get_members <- securityhub_get_members

#' Invites other Amazon Web Services accounts to become member accounts for
#' the Security Hub administrator account that the invitation is sent from
#'
#' @description
#' Invites other Amazon Web Services accounts to become member accounts for the Security Hub administrator account that the invitation is sent from.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_invite_members/](https://www.paws-r-sdk.com/docs/securityhub_invite_members/) for full documentation.
#'
#' @param AccountIds &#91;required&#93; The list of account IDs of the Amazon Web Services accounts to invite to
#' Security Hub as members.
#'
#' @keywords internal
#'
#' @rdname securityhub_invite_members
securityhub_invite_members <- function(AccountIds) {
  op <- new_operation(
    name = "InviteMembers",
    http_method = "POST",
    http_path = "/members/invite",
    paginator = list()
  )
  input <- .securityhub$invite_members_input(AccountIds = AccountIds)
  output <- .securityhub$invite_members_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$invite_members <- securityhub_invite_members

#' A list of automation rules and their metadata for the calling account
#'
#' @description
#' A list of automation rules and their metadata for the calling account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_list_automation_rules/](https://www.paws-r-sdk.com/docs/securityhub_list_automation_rules/) for full documentation.
#'
#' @param NextToken A token to specify where to start paginating the response. This is the
#' `NextToken` from a previously truncated response. On your first call to
#' the [`list_automation_rules`][securityhub_list_automation_rules] API,
#' set the value of this parameter to `NULL`.
#' @param MaxResults The maximum number of rules to return in the response. This currently
#' ranges from 1 to 100.
#'
#' @keywords internal
#'
#' @rdname securityhub_list_automation_rules
securityhub_list_automation_rules <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAutomationRules",
    http_method = "GET",
    http_path = "/automationrules/list",
    paginator = list()
  )
  input <- .securityhub$list_automation_rules_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$list_automation_rules_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_automation_rules <- securityhub_list_automation_rules

#' Lists all findings-generating solutions (products) that you are
#' subscribed to receive findings from in Security Hub
#'
#' @description
#' Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_list_enabled_products_for_import/](https://www.paws-r-sdk.com/docs/securityhub_list_enabled_products_for_import/) for full documentation.
#'
#' @param NextToken The token that is required for pagination. On your first call to the
#' [`list_enabled_products_for_import`][securityhub_list_enabled_products_for_import]
#' operation, set the value of this parameter to `NULL`.
#' 
#' For subsequent calls to the operation, to continue listing data, set the
#' value of this parameter to the value returned from the previous
#' response.
#' @param MaxResults The maximum number of items to return in the response.
#'
#' @keywords internal
#'
#' @rdname securityhub_list_enabled_products_for_import
securityhub_list_enabled_products_for_import <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEnabledProductsForImport",
    http_method = "GET",
    http_path = "/productSubscriptions",
    paginator = list()
  )
  input <- .securityhub$list_enabled_products_for_import_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$list_enabled_products_for_import_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_enabled_products_for_import <- securityhub_list_enabled_products_for_import

#' If finding aggregation is enabled, then ListFindingAggregators returns
#' the ARN of the finding aggregator
#'
#' @description
#' If finding aggregation is enabled, then [`list_finding_aggregators`][securityhub_list_finding_aggregators] returns the ARN of the finding aggregator. You can run this operation from any Region.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_list_finding_aggregators/](https://www.paws-r-sdk.com/docs/securityhub_list_finding_aggregators/) for full documentation.
#'
#' @param NextToken The token returned with the previous set of results. Identifies the next
#' set of results to return.
#' @param MaxResults The maximum number of results to return. This operation currently only
#' returns a single result.
#'
#' @keywords internal
#'
#' @rdname securityhub_list_finding_aggregators
securityhub_list_finding_aggregators <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFindingAggregators",
    http_method = "GET",
    http_path = "/findingAggregator/list",
    paginator = list()
  )
  input <- .securityhub$list_finding_aggregators_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$list_finding_aggregators_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_finding_aggregators <- securityhub_list_finding_aggregators

#' Lists all Security Hub membership invitations that were sent to the
#' current Amazon Web Services account
#'
#' @description
#' Lists all Security Hub membership invitations that were sent to the current Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_list_invitations/](https://www.paws-r-sdk.com/docs/securityhub_list_invitations/) for full documentation.
#'
#' @param MaxResults The maximum number of items to return in the response.
#' @param NextToken The token that is required for pagination. On your first call to the
#' [`list_invitations`][securityhub_list_invitations] operation, set the
#' value of this parameter to `NULL`.
#' 
#' For subsequent calls to the operation, to continue listing data, set the
#' value of this parameter to the value returned from the previous
#' response.
#'
#' @keywords internal
#'
#' @rdname securityhub_list_invitations
securityhub_list_invitations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListInvitations",
    http_method = "GET",
    http_path = "/invitations",
    paginator = list()
  )
  input <- .securityhub$list_invitations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .securityhub$list_invitations_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_invitations <- securityhub_list_invitations

#' Lists details about all member accounts for the current Security Hub
#' administrator account
#'
#' @description
#' Lists details about all member accounts for the current Security Hub administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_list_members/](https://www.paws-r-sdk.com/docs/securityhub_list_members/) for full documentation.
#'
#' @param OnlyAssociated Specifies which member accounts to include in the response based on
#' their relationship status with the administrator account. The default
#' value is `TRUE`.
#' 
#' If `OnlyAssociated` is set to `TRUE`, the response includes member
#' accounts whose relationship status with the administrator account is set
#' to `ENABLED`.
#' 
#' If `OnlyAssociated` is set to `FALSE`, the response includes all
#' existing member accounts.
#' @param MaxResults The maximum number of items to return in the response.
#' @param NextToken The token that is required for pagination. On your first call to the
#' [`list_members`][securityhub_list_members] operation, set the value of
#' this parameter to `NULL`.
#' 
#' For subsequent calls to the operation, to continue listing data, set the
#' value of this parameter to the value returned from the previous
#' response.
#'
#' @keywords internal
#'
#' @rdname securityhub_list_members
securityhub_list_members <- function(OnlyAssociated = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListMembers",
    http_method = "GET",
    http_path = "/members",
    paginator = list()
  )
  input <- .securityhub$list_members_input(OnlyAssociated = OnlyAssociated, MaxResults = MaxResults, NextToken = NextToken)
  output <- .securityhub$list_members_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_members <- securityhub_list_members

#' Lists the Security Hub administrator accounts
#'
#' @description
#' Lists the Security Hub administrator accounts. Can only be called by the organization management account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_list_organization_admin_accounts/](https://www.paws-r-sdk.com/docs/securityhub_list_organization_admin_accounts/) for full documentation.
#'
#' @param MaxResults The maximum number of items to return in the response.
#' @param NextToken The token that is required for pagination. On your first call to the
#' [`list_organization_admin_accounts`][securityhub_list_organization_admin_accounts]
#' operation, set the value of this parameter to `NULL`. For subsequent
#' calls to the operation, to continue listing data, set the value of this
#' parameter to the value returned from the previous response.
#'
#' @keywords internal
#'
#' @rdname securityhub_list_organization_admin_accounts
securityhub_list_organization_admin_accounts <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListOrganizationAdminAccounts",
    http_method = "GET",
    http_path = "/organization/admin",
    paginator = list()
  )
  input <- .securityhub$list_organization_admin_accounts_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .securityhub$list_organization_admin_accounts_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_organization_admin_accounts <- securityhub_list_organization_admin_accounts

#' Lists all of the security controls that apply to a specified standard
#'
#' @description
#' Lists all of the security controls that apply to a specified standard.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_list_security_control_definitions/](https://www.paws-r-sdk.com/docs/securityhub_list_security_control_definitions/) for full documentation.
#'
#' @param StandardsArn The Amazon Resource Name (ARN) of the standard that you want to view
#' controls for.
#' @param NextToken Optional pagination parameter.
#' @param MaxResults An optional parameter that limits the total results of the API response
#' to the specified number. If this parameter isn't provided in the
#' request, the results include the first 25 security controls that apply
#' to the specified standard. The results also include a `NextToken`
#' parameter that you can use in a subsequent API call to get the next 25
#' controls. This repeats until all controls for the standard are returned.
#'
#' @keywords internal
#'
#' @rdname securityhub_list_security_control_definitions
securityhub_list_security_control_definitions <- function(StandardsArn = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListSecurityControlDefinitions",
    http_method = "GET",
    http_path = "/securityControls/definitions",
    paginator = list()
  )
  input <- .securityhub$list_security_control_definitions_input(StandardsArn = StandardsArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$list_security_control_definitions_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_security_control_definitions <- securityhub_list_security_control_definitions

#' Specifies whether a control is currently enabled or disabled in each
#' enabled standard in the calling account
#'
#' @description
#' Specifies whether a control is currently enabled or disabled in each enabled standard in the calling account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_list_standards_control_associations/](https://www.paws-r-sdk.com/docs/securityhub_list_standards_control_associations/) for full documentation.
#'
#' @param SecurityControlId &#91;required&#93; The identifier of the control (identified with `SecurityControlId`,
#' `SecurityControlArn`, or a mix of both parameters) that you want to
#' determine the enablement status of in each enabled standard.
#' @param NextToken Optional pagination parameter.
#' @param MaxResults An optional parameter that limits the total results of the API response
#' to the specified number. If this parameter isn't provided in the
#' request, the results include the first 25 standard and control
#' associations. The results also include a `NextToken` parameter that you
#' can use in a subsequent API call to get the next 25 associations. This
#' repeats until all associations for the specified control are returned.
#' The number of results is limited by the number of supported Security Hub
#' standards that you've enabled in the calling account.
#'
#' @keywords internal
#'
#' @rdname securityhub_list_standards_control_associations
securityhub_list_standards_control_associations <- function(SecurityControlId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListStandardsControlAssociations",
    http_method = "GET",
    http_path = "/associations",
    paginator = list()
  )
  input <- .securityhub$list_standards_control_associations_input(SecurityControlId = SecurityControlId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .securityhub$list_standards_control_associations_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_standards_control_associations <- securityhub_list_standards_control_associations

#' Returns a list of tags associated with a resource
#'
#' @description
#' Returns a list of tags associated with a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/securityhub_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource to retrieve tags for.
#'
#' @keywords internal
#'
#' @rdname securityhub_list_tags_for_resource
securityhub_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .securityhub$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .securityhub$list_tags_for_resource_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$list_tags_for_resource <- securityhub_list_tags_for_resource

#' Adds one or more tags to a resource
#'
#' @description
#' Adds one or more tags to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_tag_resource/](https://www.paws-r-sdk.com/docs/securityhub_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource to apply the tags to.
#' @param Tags &#91;required&#93; The tags to add to the resource. You can add up to 50 tags at a time.
#' The tag keys can be no longer than 128 characters. The tag values can be
#' no longer than 256 characters.
#'
#' @keywords internal
#'
#' @rdname securityhub_tag_resource
securityhub_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .securityhub$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .securityhub$tag_resource_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$tag_resource <- securityhub_tag_resource

#' Removes one or more tags from a resource
#'
#' @description
#' Removes one or more tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_untag_resource/](https://www.paws-r-sdk.com/docs/securityhub_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource to remove the tags from.
#' @param TagKeys &#91;required&#93; The tag keys associated with the tags to remove from the resource. You
#' can remove up to 50 tags at a time.
#'
#' @keywords internal
#'
#' @rdname securityhub_untag_resource
securityhub_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .securityhub$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .securityhub$untag_resource_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$untag_resource <- securityhub_untag_resource

#' Updates the name and description of a custom action target in Security
#' Hub
#'
#' @description
#' Updates the name and description of a custom action target in Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_update_action_target/](https://www.paws-r-sdk.com/docs/securityhub_update_action_target/) for full documentation.
#'
#' @param ActionTargetArn &#91;required&#93; The ARN of the custom action target to update.
#' @param Name The updated name of the custom action target.
#' @param Description The updated description for the custom action target.
#'
#' @keywords internal
#'
#' @rdname securityhub_update_action_target
securityhub_update_action_target <- function(ActionTargetArn, Name = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateActionTarget",
    http_method = "PATCH",
    http_path = "/actionTargets/{ActionTargetArn+}",
    paginator = list()
  )
  input <- .securityhub$update_action_target_input(ActionTargetArn = ActionTargetArn, Name = Name, Description = Description)
  output <- .securityhub$update_action_target_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$update_action_target <- securityhub_update_action_target

#' Updates the finding aggregation configuration
#'
#' @description
#' Updates the finding aggregation configuration. Used to update the Region linking mode and the list of included or excluded Regions. You cannot use [`update_finding_aggregator`][securityhub_update_finding_aggregator] to change the aggregation Region.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_update_finding_aggregator/](https://www.paws-r-sdk.com/docs/securityhub_update_finding_aggregator/) for full documentation.
#'
#' @param FindingAggregatorArn &#91;required&#93; The ARN of the finding aggregator. To obtain the ARN, use
#' [`list_finding_aggregators`][securityhub_list_finding_aggregators].
#' @param RegionLinkingMode &#91;required&#93; Indicates whether to aggregate findings from all of the available
#' Regions in the current partition. Also determines whether to
#' automatically aggregate findings from new Regions as Security Hub
#' supports them and you opt into them.
#' 
#' The selected option also determines how to use the Regions provided in
#' the Regions list.
#' 
#' The options are as follows:
#' 
#' -   `ALL_REGIONS` - Indicates to aggregate findings from all of the
#'     Regions where Security Hub is enabled. When you choose this option,
#'     Security Hub also automatically aggregates findings from new Regions
#'     as Security Hub supports them and you opt into them.
#' 
#' -   `ALL_REGIONS_EXCEPT_SPECIFIED` - Indicates to aggregate findings
#'     from all of the Regions where Security Hub is enabled, except for
#'     the Regions listed in the `Regions` parameter. When you choose this
#'     option, Security Hub also automatically aggregates findings from new
#'     Regions as Security Hub supports them and you opt into them.
#' 
#' -   `SPECIFIED_REGIONS` - Indicates to aggregate findings only from the
#'     Regions listed in the `Regions` parameter. Security Hub does not
#'     automatically aggregate findings from new Regions.
#' @param Regions If `RegionLinkingMode` is `ALL_REGIONS_EXCEPT_SPECIFIED`, then this is a
#' space-separated list of Regions that do not aggregate findings to the
#' aggregation Region.
#' 
#' If `RegionLinkingMode` is `SPECIFIED_REGIONS`, then this is a
#' space-separated list of Regions that do aggregate findings to the
#' aggregation Region.
#'
#' @keywords internal
#'
#' @rdname securityhub_update_finding_aggregator
securityhub_update_finding_aggregator <- function(FindingAggregatorArn, RegionLinkingMode, Regions = NULL) {
  op <- new_operation(
    name = "UpdateFindingAggregator",
    http_method = "PATCH",
    http_path = "/findingAggregator/update",
    paginator = list()
  )
  input <- .securityhub$update_finding_aggregator_input(FindingAggregatorArn = FindingAggregatorArn, RegionLinkingMode = RegionLinkingMode, Regions = Regions)
  output <- .securityhub$update_finding_aggregator_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$update_finding_aggregator <- securityhub_update_finding_aggregator

#' UpdateFindings is deprecated
#'
#' @description
#' [`update_findings`][securityhub_update_findings] is deprecated. Instead of [`update_findings`][securityhub_update_findings], use [`batch_update_findings`][securityhub_batch_update_findings].
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_update_findings/](https://www.paws-r-sdk.com/docs/securityhub_update_findings/) for full documentation.
#'
#' @param Filters &#91;required&#93; A collection of attributes that specify which findings you want to
#' update.
#' @param Note The updated note for the finding.
#' @param RecordState The updated record state for the finding.
#'
#' @keywords internal
#'
#' @rdname securityhub_update_findings
securityhub_update_findings <- function(Filters, Note = NULL, RecordState = NULL) {
  op <- new_operation(
    name = "UpdateFindings",
    http_method = "PATCH",
    http_path = "/findings",
    paginator = list()
  )
  input <- .securityhub$update_findings_input(Filters = Filters, Note = Note, RecordState = RecordState)
  output <- .securityhub$update_findings_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$update_findings <- securityhub_update_findings

#' Updates the Security Hub insight identified by the specified insight ARN
#'
#' @description
#' Updates the Security Hub insight identified by the specified insight ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_update_insight/](https://www.paws-r-sdk.com/docs/securityhub_update_insight/) for full documentation.
#'
#' @param InsightArn &#91;required&#93; The ARN of the insight that you want to update.
#' @param Name The updated name for the insight.
#' @param Filters The updated filters that define this insight.
#' @param GroupByAttribute The updated `GroupBy` attribute that defines this insight.
#'
#' @keywords internal
#'
#' @rdname securityhub_update_insight
securityhub_update_insight <- function(InsightArn, Name = NULL, Filters = NULL, GroupByAttribute = NULL) {
  op <- new_operation(
    name = "UpdateInsight",
    http_method = "PATCH",
    http_path = "/insights/{InsightArn+}",
    paginator = list()
  )
  input <- .securityhub$update_insight_input(InsightArn = InsightArn, Name = Name, Filters = Filters, GroupByAttribute = GroupByAttribute)
  output <- .securityhub$update_insight_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$update_insight <- securityhub_update_insight

#' Used to update the configuration related to Organizations
#'
#' @description
#' Used to update the configuration related to Organizations. Can only be called from a Security Hub administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_update_organization_configuration/](https://www.paws-r-sdk.com/docs/securityhub_update_organization_configuration/) for full documentation.
#'
#' @param AutoEnable &#91;required&#93; Whether to automatically enable Security Hub for new accounts in the
#' organization.
#' 
#' By default, this is `false`, and new accounts are not added
#' automatically.
#' 
#' To automatically enable Security Hub for new accounts, set this to
#' `true`.
#' @param AutoEnableStandards Whether to automatically enable Security Hub [default
#' standards](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards-enable-disable.html)
#' for new member accounts in the organization.
#' 
#' By default, this parameter is equal to `DEFAULT`, and new member
#' accounts are automatically enabled with default Security Hub standards.
#' 
#' To opt out of enabling default standards for new member accounts, set
#' this parameter equal to `NONE`.
#'
#' @keywords internal
#'
#' @rdname securityhub_update_organization_configuration
securityhub_update_organization_configuration <- function(AutoEnable, AutoEnableStandards = NULL) {
  op <- new_operation(
    name = "UpdateOrganizationConfiguration",
    http_method = "POST",
    http_path = "/organization/configuration",
    paginator = list()
  )
  input <- .securityhub$update_organization_configuration_input(AutoEnable = AutoEnable, AutoEnableStandards = AutoEnableStandards)
  output <- .securityhub$update_organization_configuration_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$update_organization_configuration <- securityhub_update_organization_configuration

#' Updates configuration options for Security Hub
#'
#' @description
#' Updates configuration options for Security Hub.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_update_security_hub_configuration/](https://www.paws-r-sdk.com/docs/securityhub_update_security_hub_configuration/) for full documentation.
#'
#' @param AutoEnableControls Whether to automatically enable new controls when they are added to
#' standards that are enabled.
#' 
#' By default, this is set to `true`, and new controls are enabled
#' automatically. To not automatically enable new controls, set this to
#' `false`.
#' @param ControlFindingGenerator Updates whether the calling account has consolidated control findings
#' turned on. If the value for this field is set to `SECURITY_CONTROL`,
#' Security Hub generates a single finding for a control check even when
#' the check applies to multiple enabled standards.
#' 
#' If the value for this field is set to `STANDARD_CONTROL`, Security Hub
#' generates separate findings for a control check when the check applies
#' to multiple enabled standards.
#' 
#' For accounts that are part of an organization, this value can only be
#' updated in the administrator account.
#'
#' @keywords internal
#'
#' @rdname securityhub_update_security_hub_configuration
securityhub_update_security_hub_configuration <- function(AutoEnableControls = NULL, ControlFindingGenerator = NULL) {
  op <- new_operation(
    name = "UpdateSecurityHubConfiguration",
    http_method = "PATCH",
    http_path = "/accounts",
    paginator = list()
  )
  input <- .securityhub$update_security_hub_configuration_input(AutoEnableControls = AutoEnableControls, ControlFindingGenerator = ControlFindingGenerator)
  output <- .securityhub$update_security_hub_configuration_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$update_security_hub_configuration <- securityhub_update_security_hub_configuration

#' Used to control whether an individual security standard control is
#' enabled or disabled
#'
#' @description
#' Used to control whether an individual security standard control is enabled or disabled.
#'
#' See [https://www.paws-r-sdk.com/docs/securityhub_update_standards_control/](https://www.paws-r-sdk.com/docs/securityhub_update_standards_control/) for full documentation.
#'
#' @param StandardsControlArn &#91;required&#93; The ARN of the security standard control to enable or disable.
#' @param ControlStatus The updated status of the security standard control.
#' @param DisabledReason A description of the reason why you are disabling a security standard
#' control. If you are disabling a control, then this is required.
#'
#' @keywords internal
#'
#' @rdname securityhub_update_standards_control
securityhub_update_standards_control <- function(StandardsControlArn, ControlStatus = NULL, DisabledReason = NULL) {
  op <- new_operation(
    name = "UpdateStandardsControl",
    http_method = "PATCH",
    http_path = "/standards/control/{StandardsControlArn+}",
    paginator = list()
  )
  input <- .securityhub$update_standards_control_input(StandardsControlArn = StandardsControlArn, ControlStatus = ControlStatus, DisabledReason = DisabledReason)
  output <- .securityhub$update_standards_control_output()
  config <- get_config()
  svc <- .securityhub$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securityhub$operations$update_standards_control <- securityhub_update_standards_control
