% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verifiedpermissions_operations.R
\name{verifiedpermissions_batch_is_authorized}
\alias{verifiedpermissions_batch_is_authorized}
\title{Makes a series of decisions about multiple authorization requests for
one principal or resource}
\usage{
verifiedpermissions_batch_is_authorized(
  policyStoreId,
  entities = NULL,
  requests
)
}
\arguments{
\item{policyStoreId}{[required] Specifies the ID of the policy store. Policies in this policy store will
be used to make the authorization decisions for the input.}

\item{entities}{Specifies the list of resources and principals and their associated
attributes that Verified Permissions can examine when evaluating the
policies.

You can include only principal and resource entities in this parameter;
you can't include actions. You must specify actions in the schema.}

\item{requests}{[required] An array of up to 30 requests that you want Verified Permissions to
evaluate.}
}
\description{
Makes a series of decisions about multiple authorization requests for one principal or resource. Each request contains the equivalent content of an \code{\link[=verifiedpermissions_is_authorized]{is_authorized}} request: principal, action, resource, and context. Either the \code{principal} or the \code{resource} parameter must be identical across all requests. For example, Verified Permissions won't evaluate a pair of requests where \code{bob} views \code{photo1} and \code{alice} views \code{photo2}. Authorization of \code{bob} to view \code{photo1} and \code{photo2}, or \code{bob} and \code{alice} to view \code{photo1}, are valid batches.

See \url{https://www.paws-r-sdk.com/docs/verifiedpermissions_batch_is_authorized/} for full documentation.
}
\keyword{internal}
