% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_create_file_system_from_backup}
\alias{fsx_create_file_system_from_backup}
\title{Creates a new Amazon FSx for Lustre, Amazon FSx for Windows File Server,
or Amazon FSx for OpenZFS file system from an existing Amazon FSx backup}
\usage{
fsx_create_file_system_from_backup(
  BackupId,
  ClientRequestToken = NULL,
  SubnetIds,
  SecurityGroupIds = NULL,
  Tags = NULL,
  WindowsConfiguration = NULL,
  LustreConfiguration = NULL,
  StorageType = NULL,
  KmsKeyId = NULL,
  FileSystemTypeVersion = NULL,
  OpenZFSConfiguration = NULL,
  StorageCapacity = NULL
)
}
\arguments{
\item{BackupId}{[required]}

\item{ClientRequestToken}{A string of up to 63 ASCII characters that Amazon FSx uses to ensure
idempotent creation. This string is automatically filled on your behalf
when you use the Command Line Interface (CLI) or an Amazon Web Services
SDK.}

\item{SubnetIds}{[required] Specifies the IDs of the subnets that the file system will be accessible
from. For Windows \code{MULTI_AZ_1} file system deployment types, provide
exactly two subnet IDs, one for the preferred file server and one for
the standby file server. You specify one of these subnets as the
preferred subnet using the \code{WindowsConfiguration > PreferredSubnetID}
property.

Windows \code{SINGLE_AZ_1} and \code{SINGLE_AZ_2} file system deployment types,
Lustre file systems, and OpenZFS file systems provide exactly one subnet
ID. The file server is launched in that subnet's Availability Zone.}

\item{SecurityGroupIds}{A list of IDs for the security groups that apply to the specified
network interfaces created for file system access. These security groups
apply to all network interfaces. This value isn't returned in later
\code{DescribeFileSystem} requests.}

\item{Tags}{The tags to be applied to the file system at file system creation. The
key value of the \code{Name} tag appears in the console as the file system
name.}

\item{WindowsConfiguration}{The configuration for this Microsoft Windows file system.}

\item{LustreConfiguration}{}

\item{StorageType}{Sets the storage type for the Windows or OpenZFS file system that you're
creating from a backup. Valid values are \code{SSD} and \code{HDD}.
\itemize{
\item Set to \code{SSD} to use solid state drive storage. SSD is supported on
all Windows and OpenZFS deployment types.
\item Set to \code{HDD} to use hard disk drive storage. HDD is supported on
\code{SINGLE_AZ_2} and \code{MULTI_AZ_1} FSx for Windows File Server file
system deployment types.
}

The default value is \code{SSD}.

HDD and SSD storage types have different minimum storage capacity
requirements. A restored file system's storage capacity is tied to the
file system that was backed up. You can create a file system that uses
HDD storage from a backup of a file system that used SSD storage if the
original SSD file system had a storage capacity of at least 2000 GiB.}

\item{KmsKeyId}{}

\item{FileSystemTypeVersion}{Sets the version for the Amazon FSx for Lustre file system that you're
creating from a backup. Valid values are \code{2.10}, \code{2.12}, and \code{2.15}.

You don't need to specify \code{FileSystemTypeVersion} because it will be
applied using the backup's \code{FileSystemTypeVersion} setting. If you
choose to specify \code{FileSystemTypeVersion} when creating from backup, the
value must match the backup's \code{FileSystemTypeVersion} setting.}

\item{OpenZFSConfiguration}{The OpenZFS configuration for the file system that's being created.}

\item{StorageCapacity}{Sets the storage capacity of the OpenZFS file system that you're
creating from a backup, in gibibytes (GiB). Valid values are from 64 GiB
up to 524,288 GiB (512 TiB). However, the value that you specify must be
equal to or greater than the backup's storage capacity value. If you
don't use the \code{StorageCapacity} parameter, the default is the backup's
\code{StorageCapacity} value.

If used to create a file system other than OpenZFS, you must provide a
value that matches the backup's \code{StorageCapacity} value. If you provide
any other value, Amazon FSx responds with with an HTTP status code 400
Bad Request.}
}
\description{
Creates a new Amazon FSx for Lustre, Amazon FSx for Windows File Server, or Amazon FSx for OpenZFS file system from an existing Amazon FSx backup.

See \url{https://www.paws-r-sdk.com/docs/fsx_create_file_system_from_backup/} for full documentation.
}
\keyword{internal}
