% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_list_caller_access_grants}
\alias{s3control_list_caller_access_grants}
\title{Use this API to list the access grants that grant the caller access to
Amazon S3 data through S3 Access Grants}
\usage{
s3control_list_caller_access_grants(
  AccountId,
  GrantScope = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  AllowedByApplication = NULL
)
}
\arguments{
\item{AccountId}{[required] The Amazon Web Services account ID of the S3 Access Grants instance.}

\item{GrantScope}{The S3 path of the data that you would like to access. Must start with
\verb{s3://}. You can optionally pass only the beginning characters of a
path, and S3 Access Grants will search for all applicable grants for the
path fragment.}

\item{NextToken}{A pagination token to request the next page of results. Pass this value
into a subsequent \verb{List Caller Access Grants} request in order to
retrieve the next page of results.}

\item{MaxResults}{The maximum number of access grants that you would like returned in the
\verb{List Caller Access Grants} response. If the results include the
pagination token \code{NextToken}, make another call using the \code{NextToken} to
determine if there are more results.}

\item{AllowedByApplication}{If this optional parameter is passed in the request, a filter is applied
to the results. The results will include only the access grants for the
caller's Identity Center application or for any other applications
(\code{ALL}).}
}
\description{
Use this API to list the access grants that grant the caller access to Amazon S3 data through S3 Access Grants. The caller (grantee) can be an Identity and Access Management (IAM) identity or Amazon Web Services Identity Center corporate directory identity. You must pass the Amazon Web Services account of the S3 data owner (grantor) in the request. You can, optionally, narrow the results by \code{GrantScope}, using a fragment of the data's S3 path, and S3 Access Grants will return only the grants with a path that contains the path fragment. You can also pass the \code{AllowedByApplication} filter in the request, which returns only the grants authorized for applications, whether the application is the caller's Identity Center application or any other application (\code{ALL}). For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-list-grants.html}{List the caller's access grants} in the \emph{Amazon S3 User Guide}.

See \url{https://www.paws-r-sdk.com/docs/s3control_list_caller_access_grants/} for full documentation.
}
\keyword{internal}
