\name{gmI}
\alias{gmI}
\docType{data}
\title{Graphical Model IDA Data Example}
\description{
This data set contains a matrix containing information on seven gaussian
variables and the corresonding DAG model.
}
\usage{data(gmI)}
\format{
  The format is a list of two components
  \describe{
    \item{x:}{num [1:10000, 1:7] -1.727 1.69 0.504 2.528 0.549 ...}
    \item{g:}{Formal class 'graphNEL' [package "graph"] with 6 slots\cr
      .. ..@ nodes     : chr [1:7] "1" "2" "3" "4" ...\cr
      .. ..@ edgeL     :List of 7\cr
      .........
    }
  }
}
\details{
The data was generated as indicated below. First, a random DAG model was
generated, then 10000 samples were drawn from this model.
}
\source{
  The data set is \code{\link{identical}} to the one generated by
  %\code{
 \preformatted{
   ## Used to generate "gmI"
   set.seed(123)
   p <- 7
   n <- 10000
   myDAG <- randomDAG(p, prob = 0.2) ## true DAG
   datI <- rmvDAG(n, myDAG)
   gmI <- list(x = datI, g = myDAG)
 }
 %}% code
}
% \references{
% %%  ~~ possibly secondary sources and usages ~~
% }
\examples{
data(gmI)
str(gmI, max=3)
pairs(gmI$x, gap = 0,
      panel=function(...) smoothScatter(..., add=TRUE))
}
\keyword{datasets}
