% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ_pval.R
\name{summ_pval}
\alias{summ_pval}
\title{Summarize distribution with p-value}
\usage{
summ_pval(f, obs, method = "both", adjust = "holm")
}
\arguments{
\item{f}{A pdqr-function representing distribution.}

\item{obs}{Numeric vector of observed values to be used as threshold for
p-value. Can have multiple values, in which case output will be adjusted
for multiple comparisons with \link[stats:p.adjust]{p.adjust()}.}

\item{method}{Method representing direction of p-value computation. Should be
one of "both", "right", "left".}

\item{adjust}{Adjustment method as \code{method} argument to \code{p.adjust()}.}
}
\value{
A numeric vector with the same length as \code{obs} representing
corresponding p-values after possible adjustment for multiple comparisons.
}
\description{
\code{summ_pval()} computes p-value(s) based on supplied distribution and observed
value(s). There are several methods of computing p-values ("both", "right",
and "left") as well as several types of multiple comparison adjustments
(using on \code{\link[stats:p.adjust]{stats::p.adjust()}}).
}
\details{
Method "both" for each element in \code{obs} computes two-sided p-value
as \code{min(1, 2 * min(right_p_val, left_p_val))}, where \code{right_p_val} and
\code{left_p_val} are right and left one-sided p-values (ones which are computed
with "right" and "left" methods) of \code{obs}'s elements correspondingly.

Method "right" for each element \code{x} of \code{obs} computes probability of \code{f >= x}
being true (more strictly, of random variable, represented by \code{f}, being not
less than \code{x}). This corresponds to right one-sided p-value.

Method "left" for each element \code{x} of \code{obs} computes probability of \code{f <= x},
which is a left one-sided p-value.

\strong{Note} that by default multiple p-values in output are adjusted with
\verb{p.adjust(*, method = adjust)}. To not do any adjustment, use \code{adjust = "none"}.
}
\examples{
# Type "discrete"
d_dis <- new_d(data.frame(x = 1:5, prob = c(1, 2, 3, 2, 1) / 9), "discrete")
summ_pval(d_dis, 3, method = "both")
summ_pval(d_dis, 3, method = "right")
summ_pval(d_dis, 3, method = "left")

# Type "continuous"
d_norm <- as_d(dnorm)
summ_pval(d_norm, 2, method = "both")
summ_pval(d_norm, 2, method = "right")
summ_pval(d_norm, 2, method = "left")

# Adjustment is made for multiple observed values
summ_pval(d_norm, seq(0, 2, by = 0.1))
  # Use `adjust = "none"` for to not do any adjustment
summ_pval(d_norm, seq(0, 2, by = 0.1), adjust = "none")

}
\seealso{
Other summary functions: 
\code{\link{summ_center}()},
\code{\link{summ_classmetric}()},
\code{\link{summ_distance}()},
\code{\link{summ_entropy}()},
\code{\link{summ_hdr}()},
\code{\link{summ_interval}()},
\code{\link{summ_moment}()},
\code{\link{summ_order}()},
\code{\link{summ_prob_true}()},
\code{\link{summ_quantile}()},
\code{\link{summ_roc}()},
\code{\link{summ_separation}()},
\code{\link{summ_spread}()}
}
\concept{summary functions}
