% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prsp_score.R
\name{prsp_score}
\alias{prsp_score}
\title{Analyze comments with Perspective API}
\usage{
prsp_score(text, text_id = NULL, languages = NULL,
  score_sentences = F, score_model, sleep = 1, doNotStore = F,
  key = NULL)
}
\arguments{
\item{text}{a character string.}

\item{text_id}{a unique ID for the text that you supply (required).}

\item{languages}{A vector of \href{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}{ISO 631-1} two-letter language codes specifying the language(s) that comment is in (for example, "en", "es", "fr", "de", etc). If unspecified, the API will autodetect the comment language. If language detection fails, the API returns an error.}

\item{score_sentences}{A boolean value that indicates if the request should return spans that describe the scores for each part of the text (currently done at per sentence level). Defaults to \code{FALSE}.}

\item{score_model}{Specify what model do you want to use (for example \code{TOXICITY} and/or \code{SEVERE_TOXICITY}). Specify a character vector if you want more than one score. See \code{peRspective::prsp_models}.}

\item{sleep}{how long should \code{prsp_score} wait between each call}

\item{doNotStore}{Whether the API is permitted to store comment from this request. Stored comments will be used for future research and community model building purposes to improve the API over time. Perspective API also plans to provide dashboards and automated analysis of the comments submitted, which will apply only to those stored. Defaults to \code{FALSE} (request data may be stored). Important note: This should be set to true if data being submitted is private (i.e. not publicly accessible), or if the data submitted contains content written by someone under 13 years old.}

\item{key}{Your API key (\href{https://github.com/conversationai/perspectiveapi/blob/master/quickstart.md}{see here} to set up an API key).}
}
\value{
a \code{tibble}
}
\description{
Provide a character string with your text, your API key and what scores you want to obtain.
}
\details{
For more details see \code{?peRspective} or \href{https://github.com/conversationai/perspectiveapi/blob/master/api_reference.md}{Perspective API documentation}
}
\examples{
\dontrun{
## GET TOXICITY SCORES for a comment
prsp_score("Hello, I am a test comment!",
           score_model = "TOXICITY")
           
## GET TOXICITY and SEVERE_TOXICITY Scores for a comment
prsp_score("Hello, I am a test comment!",
           score_model = c("TOXICITY", "SEVERE_TOXICITY"))
  
## GET TOXICITY and SEVERE_TOXICITY Scores for each sentence of a comment
prsp_score("Hello, I am a test comment! 
           I am a second sentence and I will (hopefully) be scored seperately",
           score_model = c("TOXICITY", "SEVERE_TOXICITY"),
           score_sentences = T)
}
}
