% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_stateyears.R
\name{create_stateyears}
\alias{create_stateyears}
\title{Create state-years from state system membership data}
\usage{
create_stateyears(system = "cow", mry = TRUE)
}
\arguments{
\item{system}{a character specifying whether the user wants Correlates of War
state-years ("cow") or Gleditsch-Ward ("gw") state-years. Correlates of War is the
default.}

\item{mry}{optional, defaults to TRUE. If TRUE, the function extends the script
beyond the most recent system membership updates to include observation to the
most recently concluded calendar year. For example, the Gleditsch-Ward data extend
to the end of 2017. When \code{mry == TRUE}, the function returns more recent years
(e.g. 2018, 2019) under the assumption that states alive at the end of 2017 are still alive
today. Use with some care.}
}
\value{
\code{create_stateyears()} takes state system membership data provided
by either Correlates of War or Gleditsch-Ward and returns a simple state-year
data frame.
}
\description{
\code{create_stateyears()} allows you to generate state-year data from
either the Correlates of War (\code{CoW}) state system membership data or the
Gleditsch-Ward (\code{gw}) system membership data. The function leans on internal
data provided in the package.
}
\examples{
\dontrun{
library(peacesciencer)
library(magrittr)

# CoW is default, will include years beyond 2016 (most recent CoW update)
create_stateyears()

# Gleditsch-Ward, include most recent years
create_stateyears(system="gw")

# Gleditsch-Ward, don't include most recent years
create_stateyears(system="gw", mry=FALSE)
}


}
\references{
Miller, Steven V. 2019. ``Create Country-Year and (Non)-Directed Dyad-Year Data With Just a Few Lines in R''
\url{http://svmiller.com/blog/2019/01/create-country-year-dyad-year-from-country-data/}
}
\author{
Steven V. Miller
}
