% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth-standard-charts.R
\name{gs_chart}
\alias{gs_chart}
\title{Pediatric Growth Standard Charts}
\usage{
gs_chart(
  metric,
  male = 0:1,
  source = getOption("pedbp_pgs_source", "CDC"),
  p = c(0.01, 0.05, 0.1, 0.25, 0.5, 0.75, 0.9, 0.95, 0.99)
)
}
\arguments{
\item{metric}{character string, one of the growth standards}

\item{male}{integer value, 1 = male, 0 = female}

\item{source}{a character string denoting the data source providing the
parameters needed for the estimate.  Valid values are "CDC" and "WHO".  This
can be set explicitly, or by using the \code{pedbp_pgs_source} option.}

\item{p}{a numeric vector of the probabilities, provided in values between 0
and 1, to plot}
}
\value{
A \code{ggplot} object
}
\description{
Growth standards based on data from the Centers for Disease Control and the
World Health Organization.
}
\section{Notes}{
 CDC Recommends using WHO growth charts for infants and
children ages 0 to 2 years of age in the U.S. and CDC growth charts to
monitor growth for children age 2 years and older in the U.S.
}

\examples{

gs_chart("bmi_for_age", male = 0)
gs_chart("bmi_for_age", male = 1)
gs_chart("bmi_for_age", male = 0:1)

# add a point for a specific patient
pt <- data.frame(p = 0.82, age = 156, bmi = q_bmi_for_age(p = 0.82, male = 1, age = 156))
gs_chart("bmi_for_age", male = 1) +
  ggplot2::geom_point(data = pt, mapping = ggplot2::aes(x = age, y = bmi))

# select specific percentiles to plot
gs_chart("weight_for_height", male = 0:1, p = c(0.10, 0.80))

}
\references{
\url{https://www.cdc.gov/growthcharts/percentile_data_files.htm},
\url{https://www.who.int/tools/child-growth-standards/standards}
}
\seealso{
\itemize{
\item Distribution functions:
  \itemize{
    \item \code{\link{bmi_for_age}}
    \item \code{\link{head_circumference_for_age}}
    \item \code{\link{height_for_age}}
    \item \code{\link{length_for_age}}
    \item \code{\link{weight_for_age}}
    \item \code{\link{weight_for_length}}
    \item \code{\link{weight_for_height}}
  }
\item Plotting functions:
  \itemize{
    \item \code{\link{gs_chart}}
    \item \code{\link{gs_cdf}}
  }
\item Vignette:
  \itemize{
    \item \code{vignette(topic = "growth-standards", package = "pedbp")}
  }
}
}
