% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-parameters.R
\name{standardized_to_direct}
\alias{standardized_to_direct}
\alias{direct_to_standardized}
\title{Transform Between Parameterizations}
\usage{
standardized_to_direct(par, n_scales, jacobian = FALSE)

direct_to_standardized(par, n_scales)
}
\arguments{
\item{par}{concatenated vector with the fixed effect slopes and the scale
parameters that should be transformed.}

\item{n_scales}{integer with the number of scale parameters.}

\item{jacobian}{logical indicating if the Jacobian matrix of transformation
should be computed.}
}
\value{
\code{standardized_to_direct}:
returns the parameters using the direct parameterizations. See
\code{vignette("pedmod", package = "pedmod")} for the definition. There is
an attribute called 'variance proportions' with the proportion of variance
of each effect assuming that all the scale matrices are correlation matrices.
There is an attribute called jacobian with the Jacobian matrix if
\code{jacobian} is \code{TRUE}.

\code{direct_to_standardized}:
the parameters using the standardized parameterizations. See
\code{vignette("pedmod", package = "pedmod")} for the definition.
}
\description{
Transform the parameters between the parameterizations that are used in the
package.
}
\examples{
# transform backwards and forwards
set.seed(1)
smp <- runif(10, -1, 1)
res <- standardized_to_direct(smp, 2L, jacobian = TRUE)
back_val <- direct_to_standardized(res, 2L)

all.equal(smp, back_val, check.attributes = FALSE)
res

}
