% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pq_opr.R
\name{\%x>\%}
\alias{\%x>\%}
\alias{\%x<\%}
\title{crossover operators}
\usage{
x \%x>\% y

x \%x<\% y
}
\arguments{
\item{x, y}{numeric vectors}
}
\description{
Binary operators which create the upwards or downwards crossover signals.
}
\examples{
library(data.table)
library(pedquant)

data("dt_banks")
boc = md_stock_adjust(setDT(dt_banks)[symbol=='601988.SS'])
bocti = pq_addti(boc, x='close_adj', sma=list(n=200), sma=list(n=50))

dtorders = copy(bocti[[1]])[,.(symbol, name, date, close_adj, sma_50, sma_200)
][sma_50 \%x>\% sma_200, `:=`(
    type = 'buy', prices = close_adj
)][sma_50 \%x<\% sma_200, `:=`(
    type = 'sell', prices = close_adj
)][, (c('type', 'prices')) := lapply(.SD, shift), .SDcols = c('type', 'prices')]
orders = dtorders[!is.na(type)]
head(orders)

e = pq_plot(boc,  y='close_adj', addti = list(sma=list(n=200), sma=list(n=50)), orders = orders)
e[[1]]

}
