% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_convert.R
\name{as.matrix.ped}
\alias{as.matrix.ped}
\alias{restorePed}
\title{Convert \code{ped} to matrix}
\usage{
\method{as.matrix}{ped}(x, include.attrs = TRUE, ...)

restorePed(x, attrs = NULL, validate = TRUE)
}
\arguments{
\item{x}{a \code{ped} object. In \code{restorePed}: A numerical matrix.}

\item{include.attrs}{a logical indicating if marker annotations and other
info should be attached as attributes. See Value.}

\item{\dots}{not used.}

\item{attrs}{a list containing labels and other \code{ped} info compatible with
\code{x}, in the format produced by \code{as.matrix}. If NULL, the attributes of \code{x}
itself are used.}

\item{validate}{a logical, forwarded to \code{\link[=ped]{ped()}}. If FALSE, no checks for
pedigree errors are performed.}
}
\value{
For \code{as.matrix}: A numerical matrix with \code{pedsize(x)} rows. If
\code{include.attrs = TRUE} the following attributes are added to the matrix,
allowing \code{x} to be exactly reproduced by \code{restorePed}:
\itemize{
\item \code{FAMID} the family identifier (a string)
\item \code{LABELS} the ID labels (a character vector)
\item \code{UNBROKEN_LOOPS} a logical indicating whether \code{x} has unbroken loops
\item \code{LOOP_BREAKERS} a numerical matrix, or NULL
\item \code{markerattr} a list of length \code{nMarkers(x)}, containing the attributes of
each marker
}

For \code{restorePed}: A \code{ped} object.
}
\description{
Converts a \code{ped} object to a numeric matrix using internal labels, with
additional info necessary to recreate the original \code{ped} attached as
attributes.
}
\details{
\code{restorePed} is the reverse of \code{as.matrix.ped}.
}
\examples{

x = relabel(nuclearPed(1), letters[1:3])

# To examplify the ped -> matrix -> ped trick, we show how to
# reverse the internal ordering of the pedigree.
m = as.matrix(x, include.attrs = TRUE)
m[] = m[3:1, ]

# Must reverse the labels also:
attrs = attributes(m)
attrs$LABELS = rev(attrs$LABELS)

# Restore ped:
y = restorePed(m, attrs = attrs)

# Of course a simpler way is use reorderPed():
z = reorderPed(x, 3:1)
stopifnot(identical(y, z))

}
\seealso{
\code{\link[=ped]{ped()}}
}
\author{
Magnus Dehli Vigeland
}
