% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XY.R
\name{XY}
\alias{XY}
\title{Permutation Test for Correlation Between Paired Samples}
\usage{
XY(a, b, rand = 9999, seed = 1, method = c("pearson", "kendall", "spearman"))
}
\arguments{
\item{a}{a numeric vector, the first variable.}

\item{b}{a numeric vector, the second variable.}

\item{rand}{an integer, the number of randomization samples. The default value
is 9999.}

\item{seed}{an integer, the seed for random number generation. Setting a seed
ensures the reproducibility of the result. See \code{\link{set.seed}} for
more details.}

\item{method}{correlation coefficient, "pearson", "kendall", or "spearman".}
}
\value{
\code{XY} returns an one-row data frame with 2 columns:
 \item{\code{cor}}{the correlation coefficient.} \item{\code{pval}}{the
 p-value.}
}
\description{
\code{XY} performs permutation test on correlation coefficients.
}
\examples{
with(subset(ctm_Cu, run == "Jan"), XY(sediment, porewater))

}
\seealso{
\code{\link{cor.test}}
}
