% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_helpers.R
\name{add_ui_body}
\alias{add_ui_body}
\title{Add UI elements to dashboard body section}
\usage{
add_ui_body(body_elements = NULL, append = FALSE)
}
\arguments{
\item{body_elements}{List of UI elements to be displayed in application body}

\item{append}{Add elements to current body elements or remove previous body elements (default = FALSE)}
}
\value{
list of both shiny UI elements and html div tags for alert and linking app JS and CSS files
}
\description{
Builds application body with given configurations and elements. It is called within "ui_body.R".
Check example application for detailed example
}
\section{Shiny Usage}{

Call this function from \code{program/ui_body.R} to set body parameters
}

\examples{
  library(shiny)
  library(bs4Dash)
  # Inside ui_body.R
  about_box <- jumbotron(title  = "periscope2: Test Example",
                         lead   = p("periscope2 is a scalable and UI-standardized 'shiny' framework
                         	       including a variety of developer convenience functions"),
                         status = "info",
                         href   = "https://periscopeapps.org/")
  # -- Register Elements in the ORDER SHOWN in the UI
  add_ui_body(list(about_box))

}
\seealso{
\link[bs4Dash:bs4DashBody]{bs4Dash:bs4DashBody()}

\link[periscope2:add_ui_footer]{periscope2:add_ui_footer()}

\link[periscope2:add_ui_left_sidebar]{periscope2:add_ui_left_sidebar()}

\link[periscope2:add_ui_header]{periscope2:add_ui_header()}

\link[periscope2:add_ui_right_sidebar]{periscope2:add_ui_right_sidebar()}

\link[periscope2:ui_tooltip]{periscope2:ui_tooltip()}

\link[periscope2:get_url_parameters]{periscope2:get_url_parameters()}
}
