% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perturbR.R
\name{perturbR}
\alias{perturbR}
\alias{evalClust}
\title{Perturb networks and evaluate subgroup structures.}
\usage{
perturbR(sym.matrix, plot = TRUE, resolution = 0.01, reps = 100,
  errbars = FALSE)
}
\arguments{
\item{sym.matrix}{A symmetric, sparse count matrix object}

\item{plot}{Logical, defaults to TRUE}

\item{resolution}{The percentage of edges to iteratively alter. One percent is default, increase to go quicker.}

\item{reps}{The number of repititions to do for each level of perturbation. Decrease to make it go quicker.}

\item{errbars}{Logical, defaults to FALSE. Option to add error bars of one standard deviation above and below the mean for each point.}
}
\description{
Randomly rewires networks in increasing degrees of
   perturbation to evaluate stability of community solutions obtained from Walktrap.
}
\examples{
perturbR(exampledata, plot=FALSE, resolution=0.10, reps=1, errbars = FALSE)
}
