% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.magic.R
\name{convert.magic}
\alias{convert.magic}
\title{Convert Variable Types.}
\usage{
convert.magic(obj, type)
}
\arguments{
\item{obj}{name of dataframe (object)}

\item{type}{type to convert variables to one of:
\itemize{
  \item \code{"character"}
  \item \code{"numeric"}
  \item \code{"factor"}
}}
}
\value{
Dataframe with columns converted to a particular type.
}
\description{
Converts variable types of multiple columns of a dataframe at once.
}
\details{
Converts variable types of multiple columns of a dataframe at once. Convert
variable types to character, numeric, or factor.
}
\examples{
# Prepare Data
data("USArrests")

# Check if any rows are not NA
convert.magic(USArrests, "character")

}
\seealso{
\url{https://stackoverflow.com/questions/11261399/function-for-converting-dataframe-column-type/11263399#11263399}

Other dataManipulation: 
\code{\link{columnBindFill}()},
\code{\link{dropColsWithAllNA}()},
\code{\link{dropRowsWithAllNA}()}

Other conversion: 
\code{\link{convertHoursAMPM}()},
\code{\link{convertToHours}()},
\code{\link{convertToMinutes}()},
\code{\link{convertToSeconds}()},
\code{\link{percentileToTScore}()},
\code{\link{pom}()}
}
\concept{conversion}
\concept{dataManipulation}
