% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossTimeCorrelations.R
\name{crossTimeCorrelation}
\alias{crossTimeCorrelation}
\title{Cross-Time Correlations.}
\usage{
crossTimeCorrelation(id = "tcid", time = "age", variable, data)
}
\arguments{
\item{id}{Name of variable indicating the participant ID.}

\item{time}{Name of variable indicating the timepoint.}

\item{variable}{Name of variable to estimate the cross-time correlation.}

\item{data}{Dataframe.}
}
\value{
output of \code{cor.test()}
}
\description{
Calculate the association of a variable across multiple time points.
}
\details{
Calculate the association of a variable across multiple time points. It is
especially useful when there are three or more time points.
}
\examples{
# Prepare Data
df <- expand.grid(ID = 1:100, time = c(1, 2, 3))
df <- df[order(df$ID),]
row.names(df) <- NULL
df$score <- rnorm(nrow(df))

# Cross-Time Correlation
crossTimeCorrelation(id = "ID", time = "time", variable = "score", data = df)
}
\seealso{
Other correlations: 
\code{\link{addText}()},
\code{\link{cor.table}()},
\code{\link{crossTimeCorrelationDF}()},
\code{\link{partialcor.table}()},
\code{\link{vwReg}()}
}
\concept{correlations}
