% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropColsWithAllNA.R
\name{dropColsWithAllNA}
\alias{dropColsWithAllNA}
\title{Drop NA columns.}
\usage{
dropColsWithAllNA(data, ignore = NULL)
}
\arguments{
\item{data}{Dataframe to drop columns from.}

\item{ignore}{Names of columns to ignore for determining whether each row had
all missing values.}
}
\value{
A dataframe with columns removed that had all missing values in
non-ignored columns.
}
\description{
Drop columns with all missing (\code{NA}) values.
}
\details{
Drop columns that have no observed values, i.e., all values in the column are
missing (\code{NA}), excluding the ignored columns.
}
\examples{
# Prepare Data
df <- expand.grid(ID = 1:100, time = c(1, 2, 3), rater = c(1, 2),
naCol1 = NA, naCol2 = NA)
df <- df[order(df$ID),]
row.names(df) <- NULL
df$score1 <- rnorm(nrow(df))
df$score2 <- rnorm(nrow(df))
df$score3 <- rnorm(nrow(df))
df[sample(1:nrow(df), size = 100), c("score1","score2","score3")] <- NA

# Drop Rows with All NA in Non-Ignored Columns
dropColsWithAllNA(df)
dropColsWithAllNA(df, ignore = c("naCol2"))
}
\seealso{
Other dataManipulation: 
\code{\link{columnBindFill}()},
\code{\link{convert.magic}()},
\code{\link{dropRowsWithAllNA}()}

Other dataEvaluations: 
\code{\link{dropRowsWithAllNA}()},
\code{\link{is.nan.data.frame}()},
\code{\link{not_all_na}()},
\code{\link{not_any_na}()}
}
\concept{dataEvaluations}
\concept{dataManipulation}
