% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools2.R
\name{INSERT}
\alias{INSERT}
\title{Generate a postgreSQL INSERT statement, optionally execute the statement if con is not NULL.}
\usage{
INSERT(
  x,
  schema = NULL,
  table,
  prepare = TRUE,
  types,
  returning = NULL,
  quote_text = TRUE,
  cast = TRUE,
  con = NULL
)
}
\arguments{
\item{x}{A data.table, column names must match the column names of the destination SQL table.}

\item{schema}{A string, the schema name of the destination SQL table.}

\item{table}{A string, the table name of the destination SQL table.}

\item{prepare}{TRUE/FALSE, if TRUE, creates a postgreSQL prepared statement for inserting the data.}

\item{types}{A vector of character strings specifying the SQL data types of the destination columns, the position of the type should match the position of the column for that type in x. Required if prepare or cast is TRUE.}

\item{returning}{A vector of character strings specifying the SQL column names to be returned by the INSERT statement.}

\item{quote_text}{TRUE/FALSE, if TRUE, calls quoteText() to add single quotes around character strings.}

\item{cast}{TRUE/FALSE, if TRUE, will add SQL to cast the data to be inserted to the specified type.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, postgreSQL INSERT statement; or a string, postgreSQL prepared statement; or the results retrieved by DBI::dbGetQuery after executing the statement.
}
\description{
Generate a postgreSQL INSERT statement, optionally execute the statement if con is not NULL.
}
\examples{
INSERT(
x = as.data.table(list(col1 = c("a", "b", "c"), col2 = c(1, 2, 3))),
schema = "test",
table = "table1",
prepare = TRUE,
types = c("TEXT", "INTEGER"),
returning = NULL,
quote_text = TRUE,
cast = TRUE
)
}
