/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.objects;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorInvalidFont;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectArray;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectInt;
import net.sf.eps2pgf.ps.objects.PSObjectMatrix;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.objects.PSObjectString;
import net.sf.eps2pgf.ps.resources.Encoding;
import net.sf.eps2pgf.ps.resources.fonts.FontManager;
import net.sf.eps2pgf.ps.resources.fonts.PSObjectFontMetrics;
import org.fontbox.afm.AFMParser;
import org.fontbox.afm.CharMetric;
import org.fontbox.afm.FontMetric;
import org.fontbox.util.BoundingBox;

public class PSObjectFont
extends PSObjectDict {
    private static int nextFID = 0;
    private static final Logger LOG = Logger.getLogger("net.sourceforge.eps2pgf");
    public static final String KEY_FONTINFO = "FontInfo";
    public static final String KEY_FONTNAME = "FontName";
    public static final String KEY_ENCODING = "Encoding";
    public static final String KEY_PAINTTYPE = "PaintType";
    public static final String KEY_FONTTYPE = "FontType";
    public static final String KEY_FONTMATRIX = "FontMatrix";
    public static final String KEY_FONTBBOX = "FontBBox";
    public static final String KEY_UNIQUEID = "UniqueID";
    public static final String KEY_METRICS = "Metrics";
    public static final String KEY_STROKEWIDTH = "StrokeWidth";
    public static final String KEY_PRIVATE = "Private";
    public static final String KEY_CHARSTRINGS = "CharStrings";
    public static final String KEY_FID = "FID";
    public static final String KEY_PRV_SUBRS = "Subrs";
    public static final String KEY_LATEXPRECODE = "LatexPreCode";
    public static final String KEY_LATEXPOSTCODE = "LatexPostCode";
    public static final String KEY_AFM = "AFM";
    public static final String KEY_TEXSTRINGS = "TexStrings";
    public static final String KEY_BUILDGLYPH = "BuildGlyph";
    public static final String KEY_BUILDCHAR = "BuildChar";

    public PSObjectFont() {
        this.setFID();
        this.setKey(KEY_FONTTYPE, (PSObject)new PSObjectInt(1));
        this.setKey(KEY_FONTMATRIX, (PSObject)new PSObjectMatrix(0.001, 0.0, 0.0, 0.001, 0.0, 0.0));
    }

    public PSObjectFont(File file, String string) throws PSErrorInvalidFont {
        Properties properties;
        Object object;
        File file2 = new File(file, "fontdescriptions" + File.separator + string + ".font");
        try {
            object = new FileInputStream(file2);
            properties = new Properties();
            properties.loadFromXML((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PSErrorInvalidFont();
        }
        catch (IOException iOException) {
            throw new PSErrorInvalidFont();
        }
        this.setKey(KEY_FONTTYPE, (PSObject)new PSObjectInt(1));
        this.setKey(KEY_FONTMATRIX, (PSObject)new PSObjectMatrix(0.001, 0.0, 0.0, 0.001, 0.0, 0.0));
        this.setKey(KEY_FONTNAME, (PSObject)new PSObjectName(string, true));
        this.setFID();
        object = properties.getProperty("encoding", "Standard");
        if (((String)object).equals("Standard")) {
            this.setKey(KEY_ENCODING, (PSObject)new PSObjectArray(Encoding.getStandardVector()));
        } else if (((String)object).equals("ISOLatin1")) {
            this.setKey(KEY_ENCODING, (PSObject)new PSObjectArray(Encoding.getISOLatin1Vector()));
        } else if (((String)object).equals("Symbol")) {
            this.setKey(KEY_ENCODING, (PSObject)new PSObjectArray(Encoding.getSymbolVector()));
        } else {
            LOG.severe("Unknown encoding: " + (String)object);
            throw new PSErrorInvalidFont();
        }
        this.setKey(KEY_PAINTTYPE, (PSObject)new PSObjectInt(2));
        this.setKey(KEY_LATEXPRECODE, properties.getProperty("latexprecode", ""));
        this.setKey(KEY_LATEXPOSTCODE, properties.getProperty("latexpostcode", ""));
        String string2 = properties.getProperty("texstrings", "default");
        this.setKey(KEY_TEXSTRINGS, (PSObject)FontManager.getTexStringDict(string2));
        FontMetric fontMetric = this.loadAfm(file, string);
        this.setKey(KEY_AFM, (PSObject)new PSObjectFontMetrics(fontMetric));
        List list = fontMetric.getCharMetrics();
        PSObjectDict pSObjectDict = new PSObjectDict();
        for (Object e : list) {
            if (!(e instanceof CharMetric)) continue;
            CharMetric charMetric = (CharMetric)e;
            pSObjectDict.setKey(charMetric.getName(), "");
        }
        this.setKey(KEY_CHARSTRINGS, (PSObject)pSObjectDict);
    }

    public PSObjectFont(PSObjectDict pSObjectDict) {
        super(pSObjectDict);
    }

    public boolean assertValidFont() throws PSError, ProgramError {
        boolean bl = true;
        String string = this.getFontName();
        if (!this.known(KEY_TEXSTRINGS)) {
            this.setKey(KEY_TEXSTRINGS, (PSObject)FontManager.getTexStringDictByFontname(string));
            bl = false;
        }
        if (!this.known(KEY_LATEXPRECODE) || !this.known(KEY_LATEXPOSTCODE)) {
            String[][] stringArrayArray = new String[][]{{"Serif", "\\textrm{", "}"}, {"Roman", "\\textrm{", "}"}, {"Sans", "\\textsf{", "}"}, {"Mono", "\\texttt{", "}"}, {"Monospace", "\\texttt{", "}"}, {"Bold", "\\textbf{", "}"}, {"Oblique", "\\textsl{", "}"}, {"Obli", "\\textsl{", "}"}, {"Slanted", "\\textsl{", "}"}, {"Italic", "\\textit{", "}"}, {"Ital", "\\textit{", "}"}};
            String string2 = "";
            String string3 = "";
            String string4 = string + "X";
            for (int i = 0; i < stringArrayArray.length; ++i) {
                String string5 = ".*" + stringArrayArray[i][0] + "[^a-z].*";
                if (!string4.matches(string5)) continue;
                string2 = string2 + stringArrayArray[i][1];
                string3 = stringArrayArray[i][2] + string3;
            }
            this.setKey(KEY_LATEXPRECODE, string2);
            this.setKey(KEY_LATEXPOSTCODE, string3);
            bl = false;
        }
        if (!this.known(KEY_AFM)) {
            bl = false;
            this.setKey(KEY_AFM, (PSObject)new PSObjectFontMetrics(this));
            LOG.fine("Creating font metrics for font " + this.getFontName());
        }
        return bl;
    }

    public String charNames2texStrings(PSObjectArray pSObjectArray) throws PSError, ProgramError {
        this.assertValidFont();
        StringBuilder stringBuilder = new StringBuilder();
        PSObjectDict pSObjectDict = this.lookup(KEY_TEXSTRINGS).toDict();
        PSObjectString pSObjectString = this.lookup(KEY_LATEXPRECODE).toPSString();
        PSObjectString pSObjectString2 = this.lookup(KEY_LATEXPOSTCODE).toPSString();
        stringBuilder.append(pSObjectString.toString());
        for (int i = 0; i < pSObjectArray.size(); ++i) {
            try {
                PSObjectName pSObjectName = pSObjectArray.get(i).toName();
                PSObject pSObject = pSObjectDict.lookup(pSObjectName);
                if (pSObject == null) {
                    throw new PSErrorUnimplemented("TexString for " + pSObjectArray.get(i).isis() + " is unknown.");
                }
                stringBuilder.append(pSObject.toPSString().toString());
                continue;
            }
            catch (PSErrorRangeCheck pSErrorRangeCheck) {
                // empty catch block
            }
        }
        stringBuilder.append(pSObjectString2.toString());
        return stringBuilder.toString();
    }

    public PSObjectFont clone() {
        PSObjectFont pSObjectFont = (PSObjectFont)super.clone();
        return pSObjectFont;
    }

    public BoundingBox getBBox(PSObjectArray pSObjectArray) throws PSError, ProgramError {
        BoundingBox boundingBox = new BoundingBox();
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        CharMetric charMetric = new CharMetric();
        CharMetric charMetric2 = new CharMetric();
        for (int i = 0; i < pSObjectArray.size(); ++i) {
            try {
                String string = pSObjectArray.get(i).toName().toString();
                CharMetric charMetric3 = this.getCharMetric(string);
                BoundingBox boundingBox2 = charMetric3.getBoundingBox();
                d = Math.min(d, (double)boundingBox2.getLowerLeftY());
                d2 = Math.max(d2, (double)boundingBox2.getUpperRightY());
                if (i == 0) {
                    charMetric = charMetric3;
                }
                if (i != pSObjectArray.size() - 1) continue;
                charMetric2 = charMetric3;
                continue;
            }
            catch (PSErrorRangeCheck pSErrorRangeCheck) {
                // empty catch block
            }
        }
        double d3 = this.getFontMatrix().getMeanScaling();
        double d4 = (double)charMetric.getBoundingBox().getLowerLeftX() * d3;
        double d5 = this.getWidth(pSObjectArray) - (double)charMetric2.getWx() * d3 + (double)charMetric2.getBoundingBox().getUpperRightX() * d3;
        boundingBox.setLowerLeftX((float)d4);
        boundingBox.setLowerLeftY((float)(d * d3));
        boundingBox.setUpperRightX((float)d5);
        boundingBox.setUpperRightY((float)(d2 * d3));
        return boundingBox;
    }

    CharMetric getCharMetric(String string) throws PSError, ProgramError {
        Object object2;
        FontMetric fontMetric = this.getFontMetric();
        List list = fontMetric.getCharMetrics();
        for (Object object2 : list) {
            if (!(object2 instanceof CharMetric)) {
                throw new PSErrorTypeCheck();
            }
            CharMetric charMetric = (CharMetric)object2;
            if (!string.equals(charMetric.getName())) continue;
            return charMetric;
        }
        CharMetric charMetric = new CharMetric();
        object2 = new BoundingBox();
        ((BoundingBox)object2).setLowerLeftX(0.0f);
        ((BoundingBox)object2).setLowerLeftY(0.0f);
        ((BoundingBox)object2).setUpperRightX(0.0f);
        ((BoundingBox)object2).setUpperRightY(0.0f);
        charMetric.setBoundingBox((BoundingBox)object2);
        charMetric.setWx(0.0f);
        return charMetric;
    }

    public PSObjectArray getEncoding() throws PSErrorTypeCheck {
        return this.lookup(KEY_ENCODING).toArray();
    }

    int getFID() {
        try {
            return this.lookup(KEY_FID).toInt();
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
    }

    public PSObjectMatrix getFontMatrix() throws PSErrorTypeCheck, PSErrorRangeCheck {
        return this.lookup(KEY_FONTMATRIX).toMatrix();
    }

    public FontMetric getFontMetric() throws PSError, ProgramError {
        this.assertValidFont();
        return this.lookup(KEY_AFM).toFontMetric();
    }

    String getFontName() {
        if (this.known(KEY_FONTNAME)) {
            PSObject pSObject = this.lookup(KEY_FONTNAME);
            return pSObject.toString();
        }
        if (this.known(FontManager.FONT_DICT_KEY)) {
            PSObject pSObject = this.lookup(FontManager.FONT_DICT_KEY);
            return pSObject.toString();
        }
        return "";
    }

    public double getFontSize() throws PSErrorTypeCheck, PSErrorRangeCheck {
        return this.lookup(KEY_FONTMATRIX).toMatrix().getMeanScaling() * 1000.0;
    }

    public double getWidth(PSObjectArray pSObjectArray) throws PSError, ProgramError {
        double d = 0.0;
        for (int i = 0; i < pSObjectArray.size(); ++i) {
            try {
                String string = pSObjectArray.get(i).toName().toString();
                CharMetric charMetric = this.getCharMetric(string);
                double d2 = this.getFontMatrix().getMeanScaling();
                d += (double)charMetric.getWx() * d2;
                continue;
            }
            catch (PSErrorRangeCheck pSErrorRangeCheck) {
                // empty catch block
            }
        }
        return d;
    }

    public String isis() {
        return "-font " + this.getFontName() + " (FID " + this.getFID() + ")-";
    }

    public FontMetric loadAfm(File file, String string) throws PSErrorInvalidFont {
        FontMetric fontMetric;
        File file2 = new File(file, "afm" + File.separator + string + ".afm");
        try {
            FileInputStream fileInputStream = new FileInputStream(file2);
            AFMParser aFMParser = new AFMParser(fileInputStream);
            aFMParser.parse();
            fontMetric = aFMParser.getResult();
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PSErrorInvalidFont();
        }
        catch (IOException iOException) {
            throw new PSErrorInvalidFont();
        }
        return fontMetric;
    }

    public int setFID() {
        int n = this.getFID();
        if (n < 0) {
            n = nextFID++;
            this.setKey(KEY_FID, (PSObject)new PSObjectInt(n));
        }
        return n;
    }

    public PSObjectFont toFont() {
        return this;
    }
}

