% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguReporter.R
\name{pgu.reporter}
\alias{pgu.reporter}
\title{pgu.reporter}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
Creates a human readable report file of the pguIMP analysis in odf format via rmarkdown and latex.
This object is used by the shiny based gui and is not for use in individual R-scripts!
}
\details{
I run at the end of the analysis.
}
\author{
Sebastian Malkusch, \email{malkusch@med.uni-frankfurt.de}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{filename}}{Returns the instance variable filename
(character)}

\item{\code{setFilename}}{Sets the instance variable filename to name.
(character)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{pgu.reporter$new()}}
\item \href{#method-finalize}{\code{pgu.reporter$finalize()}}
\item \href{#method-print}{\code{pgu.reporter$print()}}
\item \href{#method-write_report}{\code{pgu.reporter$write_report()}}
\item \href{#method-clone}{\code{pgu.reporter$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates and returns a new \code{pgu.reporter} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.reporter$new(name = "character")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Filename of the report pdf.
(character)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{pgu.reporter} object.
(pguIMP::pgu.report)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Clears the heap and
indicates that instance of \code{pgu.reporter} is removed from heap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.reporter$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a \code{pgu.reporter} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.reporter$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write_report"></a>}}
\if{latex}{\out{\hypertarget{method-write_report}{}}}
\subsection{Method \code{write_report()}}{
Writes a report of the pguIMP analysis to a pdf file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.reporter$write_report(obj)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{obj}}{A list of class objects that are passed to the rmarkdown script.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
t.b.a.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.reporter$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
