% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{create_symbol}
\alias{create_symbol}
\title{create_symbol}
\usage{
create_symbol(model, stem, force_numbering = FALSE)
}
\arguments{
\item{model}{(Model) Pharmpy model object}

\item{stem}{(str) First part of the new variable name}

\item{force_numbering}{(logical) Forces addition of number to name even if variable does not exist, e.g.
COVEFF --> COVEFF1}
}
\value{
(Symbol) Created symbol with unique name
}
\description{
Create a new unique variable symbol given a model
}
\examples{
\dontrun{
model <- load_example_model("pheno")
create_symbol(model, "TEMP")
create_symbol(model, "TEMP", force_numbering=TRUE)
create_symbol(model, "CL")
}

}
