% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{get_pk_parameters}
\alias{get_pk_parameters}
\title{get_pk_parameters}
\usage{
get_pk_parameters(model, kind = "all")
}
\arguments{
\item{model}{(Model) Pharmpy model to retrieve the PK parameters from}

\item{kind}{(str) The type of parameter to retrieve: 'absorption', 'distribution',
'elimination', or 'all' (default).}
}
\value{
(Parameters) The PK parameters of the given model
}
\description{
Retrieves PK parameters in :class:\code{pharmpy.model}.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
sorted(get_pk_parameters(model))
get_pk_parameters(model, 'absorption')
get_pk_parameters(model, 'distribution')
get_pk_parameters(model, 'elimination')
}
}
\seealso{
get_individual_parameters
}
