% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{set_iiv_on_ruv}
\alias{set_iiv_on_ruv}
\title{set_iiv_on_ruv}
\usage{
set_iiv_on_ruv(
  model,
  dv = NULL,
  list_of_eps = NULL,
  same_eta = TRUE,
  eta_names = NULL
)
}
\arguments{
\item{model}{(Model) Pharmpy model to apply IIV on epsilons.}

\item{dv}{(str or Expr or numeric (optional)) Name/names of epsilons to multiply with exponential etas. If NULL, all epsilons will
be chosen. NULL is default.}

\item{list_of_eps}{(array(str) or str (optional)) Boolean of whether all RUVs from input should use the same new ETA or if one ETA
should be created for each RUV. TRUE is default.}

\item{same_eta}{(logical) Custom names of new etas. Must be equal to the number epsilons or 1 if same eta.}

\item{eta_names}{(array(str) or str (optional)) Name or DVID of dependent variable. NULL for the default (first or only)}
}
\value{
(Model) Pharmpy model object
}
\description{
Multiplies epsilons with exponential (new) etas.

Initial variance for new etas is 0.09.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- set_iiv_on_ruv(model)
model$statements$find_assignment("Y")
}
}
\seealso{
set_power_on_ruv
}
