% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{plot_dv_vs_pred}
\alias{plot_dv_vs_pred}
\title{plot_dv_vs_pred}
\usage{
plot_dv_vs_pred(model, predictions, stratify_on = NULL, bins = 8)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{predictions}{(data.frame) DataFrame containing the predictions}

\item{stratify_on}{(str) Name of parameter for stratification}

\item{bins}{(numeric) Number of bins for stratification}
}
\value{
(alt.Chart) Plot
}
\description{
Plot DV vs PRED
}
\examples{
\dontrun{
model <- load_example_model("pheno")
res <- load_example_modelfit_results("pheno")
plot_dv_vs_pred(model, res$predictions)
model <- load_example_model("pheno")
res <- load_example_modelfit_results("pheno")
plot_dv_vs_pred(model, res$predictions, 'WGT', bins=4)
}

}
