% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{add_dn}
\alias{add_dn}
\title{Add n-day flag}
\usage{
add_dn(d, days = 8)
}
\arguments{
\item{d}{data.frame or data.table}

\item{days}{Integer number or vector, can't have duplicated value.}
}
\description{
To aggregated data into n-day (e.g. 8-day, 16-day) like MODIS product, a 
n-day flag is need.
}
\examples{
date = seq.Date(as.Date("2010-01-01"), as.Date("2010-12-31"), by = "day")
d <- data.frame(date)
dnew <- add_dn(d, days = c(8, 16))
}
