% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melt_list.R
\name{melt_list}
\alias{melt_list}
\title{melt_list}
\usage{
melt_list(list, var.name, na.rm = TRUE, ...)
}
\arguments{
\item{list}{Data set to melt}

\item{var.name}{list names convert into var.name}

\item{na.rm}{Should NA values be removed from the data set? 
This will convert explicit missings to implicit missings.}

\item{...}{other parameters to melt.}
}
\description{
melt_list
}
\examples{
# data.frame
df <- data.frame(year = 2010, day = 1:3, month = 1, site = "A")
l  <- list(a = df, b = df)
df_new <- melt_list(l, "id")

# data.table
df <- data.table::data.table(year = 2010, day = 1:3, month = 1, site = "A")
l  <- list(a = df, b = df)
df_new <- melt_list(l, "id")
}
