% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_wWHIT_lambda.R
\name{v_curve}
\alias{v_curve}
\title{V-curve theory to optimize Whittaker parameter \code{lambda}.}
\usage{
v_curve(INPUT, lg_lambdas = seq(0, 5, by = 0.005), plot = FALSE, ...)
}
\arguments{
\item{INPUT}{A list object with the elements of \code{t}, \code{y}, \code{w},
\code{Tn} (optional) and \code{ylu}, returned by \code{\link[=check_input]{check_input()}}.}

\item{lg_lambdas}{numeric vector, log10(lambda) candidates. The optimal \code{lambda}
will be optimized from \code{lg_lambda}.}

\item{plot}{logical. If \code{TRUE}, the optimized \code{lambda} will be printed on the
console.}

\item{...}{ignored.}
}
\description{
V-curve is used to optimize Whittaker parameter \code{lambda}.
This function is not for users!!!

Update 20180605 add weights updating to whittaker lambda selecting
}
\examples{
data("CA_NS6"); d = CA_NS6
nptperyear = 23
INPUT <- check_input(d$t, d$y, d$w, nptperyear = nptperyear,
    maxgap = nptperyear/4, alpha = 0.02, wmin = 0.2)

r <- v_curve(INPUT, lg_lambdas = seq(0, 3, 0.1), plot = TRUE)
}
\seealso{
lambda_vcurve
}
\keyword{internal}
