% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_Gratiot.R
\docType{data}
\name{map_Gratiot}
\alias{map_Gratiot}
\title{Likelihood map of Leatherback nest counts}
\format{
A list with Gratiot data and the result of the fit.
}
\usage{
map_Gratiot
}
\description{
Likelihood map of Leatherback nest counts from Gratiot et al. (2006) Figure 1.
A intraseasonal periodic pattern was searched for varying Phi and Delta parameters.
}
\details{
Likelihood map of Leatherback nest counts from Gratiot et al. (2006) Figure 1
}
\examples{
library(phenology)
# Read a file with likelihood map
data(map_Gratiot)
}
\references{
Gratiot, N., Gratiot, J., de Thoisy, B. & Kelle, L. 2006.
Estimation of marine turtles nesting season from incomplete
data ; statistical adjustment of a sinusoidal function. Animal
Conservation, 9, 95-102.
}
\seealso{
Other Phenology model: 
\code{\link{AutoFitPhenology}()},
\code{\link{BE_to_LBLE}()},
\code{\link{Gratiot}},
\code{\link{LBLE_to_BE}()},
\code{\link{LBLE_to_L}()},
\code{\link{L_to_LBLE}()},
\code{\link{MarineTurtles_2002}},
\code{\link{MinBMinE_to_Min}()},
\code{\link{adapt_parameters}()},
\code{\link{add_SE}()},
\code{\link{add_phenology}()},
\code{\link{extract_result}()},
\code{\link{fit_phenology}()},
\code{\link{likelihood_phenology}()},
\code{\link{logLik.phenology}()},
\code{\link{map_phenology}()},
\code{\link{par_init}()},
\code{\link{phenology}()},
\code{\link{phenology2fitRMU}()},
\code{\link{phenology_MHmcmc}()},
\code{\link{phenology_MHmcmc_p}()},
\code{\link{plot.phenology}()},
\code{\link{plot.phenologymap}()},
\code{\link{plot_delta}()},
\code{\link{plot_phi}()},
\code{\link{print.phenology}()},
\code{\link{print.phenologymap}()},
\code{\link{print.phenologyout}()},
\code{\link{remove_site}()},
\code{\link{result_Gratiot}},
\code{\link{result_Gratiot1}},
\code{\link{result_Gratiot2}},
\code{\link{result_Gratiot_Flat}},
\code{\link{result_Gratiot_mcmc}},
\code{\link{summary.phenology}()},
\code{\link{summary.phenologymap}()},
\code{\link{summary.phenologyout}()}
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\concept{Phenology model}
\keyword{datasets}
