#' plot.phenology plots the phenology.
#' @title Plot the phenology from a result.
#' @author Marc Girondot
#' @return Return A list of lists with formated outputs\cr
#' For each site:\cr
#' $site=name of the site\cr
#' $estimate1=Estimation of counts not taking into account the observations\cr
#' $sd1=The SD of estimation1\cr
#' $estimate2=Estimation of counts taking into account the observations\cr
#' $sd2=The SD of estimation2
#' @param x A result file generated by fit_phenology
#' @param ... Parameters used by plot_phenology
#' @param data A dataset generated by add_format
#' @param pdf TRUE or FALSE, indicates if a pdf file is generated.
#' @param parametersfixed Set of fixed parameters
#' @param parameters Set of parameters to be changed
#' @param series Number of series to be analyzed or 'all'
#' @param moon If TRUE, the moon phase is ploted. Default is FALSE
#' @param help If TRUE, an help is displayed
#' @description The function plot.phenology plots the phenology graph from a result.
#' @examples
#' library(phenology)
#' # Read a file with data
#' # Gratiot<-read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", , header=FALSE)
#' data(Gratiot)
#' # Generate a formatted list nammed data_Gratiot 
#' data_Gratiot<-add_format(origin=NULL, add=Gratiot, name="Complete", reference=as.Date("2001-01-01"), format="%d/%m/%Y")
#' # Generate initial points for the optimisation
#' parg<-par_init(data_Gratiot, parametersfixed=NULL)
#' # Run the optimisation
#' # result_Gratiot<-fit_phenology(data=data_Gratiot, parametersfit=parg, parametersfixed=NULL, trace=1)
#' data(result_Gratiot)
#' # Plot the phenology and get some stats
#' output<-plot(result_Gratiot, pdf=FALSE)
#' @method plot phenology
#' @export

#plot.phenology <- function(x, ...) {

plot.phenology <- function(x, ..., data=NULL, parameters=NULL, parametersfixed=NA, pdf=FALSE, series="all", moon=FALSE, help=FALSE) {

# result=NULL, data=NULL, parameters=NULL, parametersfixed=NA, series="all", pdf=FALSE, moon=FALSE, help=FALSE, ...

	es <- c(...)
		
	if (is.null(es)) es <- NA

	out <- plot_phenology(result=x, data=data, parameters=parameters, parametersfixed=parametersfixed, series=series, pdf=pdf, moon=moon, help=help, es)

	return(out)

}
