% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableECFOCF.R
\name{TableECFOCF}
\alias{TableECFOCF}
\title{Format a CMR dataset into a file that fitCF can use.}
\usage{

  TableECFOCF(data = stop("A dataframe with a column 'ID' and a column 'Date'"),
  columnID = "ID", columnDate = "Date", MinimumDaysBetween2Nest = 7,
  MeanDaysBetween2Nest = 9.8, MaxNests = 15, date0 = NULL,
  length_season = floor(365/MeanDaysBetween2Nest) + 1)
}
\arguments{
\item{data}{CMR file.}

\item{columnID}{Name of the column in data for unique identifier of females.}

\item{columnDate}{Name of the column in data for morning date when female has been seen on the beach.}

\item{MinimumDaysBetween2Nest}{Number of minimum days between two nests.}

\item{MeanDaysBetween2Nest}{Average number of days between two nests.}

\item{MaxNests}{Maximum number of nests by a female.}

\item{date0}{Date for the ordinal day 0.}

\item{length_season}{The total length of season based on groups of interclutch intervals.}
}
\value{
Return a matrix with counts for all OCF and ECF combinations.
}
\description{
This function formats a CMR dataset to a file that fitCF can use.\cr
If date0 is not null, a 3D TableECFOCF is generated.\cr
3D table (ECF, OCF, period) has two attributes:\cr
- table with 5 elements:\cr
begin, end are the first and last elements with counts\cr
final is the last period with information\cr
min and max are the first and last period where a nest could have been laid based on MaxNests value\cr
- characteristics with 5 elements:\cr
MinimumDaysBetween2Nest, MeanDaysBetween2Nest MaxNests, date0, length_season\cr
p parameter can be setup to +Inf until begin and after end
}
\details{
TableECFOCF formats a CMR dataset into a file that fitCF can use.
}
\examples{
\dontrun{
library(phenology)
# Example
data(MarineTurtles_2002)
ECFOCF_2002 <- TableECFOCF(MarineTurtles_2002)
plot(ECFOCF_2002)
ECFOCF_2002 <- TableECFOCF(MarineTurtles_2002, date0=as.Date("2002-01-01"))
plot(ECFOCF_2002, period=11)
}
}
\seealso{
Other Model of Clutch Frequency: \code{\link{ECFOCF_f}},
  \code{\link{fitCF}}, \code{\link{lnLCF}},
  \code{\link{logLik.ECFOCF}}, \code{\link{plot.ECFOCF}},
  \code{\link{plot.TableECFOCF}}
}
\author{
Marc Girondot
}
