% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rogerroot.R
\name{rogerroot}
\alias{rogerroot}
\title{Roger Root Name Coding Procedure}
\usage{
rogerroot(word, maxCodeLen = 5)
}
\arguments{
\item{word}{string or vector of strings to encode}

\item{maxCodeLen}{maximum length of the resulting encodings, in characters}
}
\value{
the Roger Root encoded character vector
}
\description{
Provides the Roger Root name coding system
}
\details{
The \code{rogerroot} function phentically encodes the given string
using the Roger Root algorithm.  The variable \code{word} is a string
or vector of strings to encode.

The variable \code{maxCodeLen} is the limit on how long the returned
code should be.  The default is 5.
}
\examples{
rogerroot("William")
rogerroot(c("Peter", "Peady"))
rogerroot("Stevenson")

}
\references{
Robert L. Taft, \emph{Name search techniques}, Bureau of Systems
Development, Albany, New York, 1970.
}
\seealso{
Other phonics: \code{\link{caverphone}},
  \code{\link{lein}}, \code{\link{metaphone}},
  \code{\link{mra_encode}}, \code{\link{nysiis}},
  \code{\link{soundex}}, \code{\link{statcan}}
}

