% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phonex.R
\name{phonex}
\alias{phonex}
\title{Phonex Name Coding}
\usage{
phonex(word, maxCodeLen = 4)
}
\arguments{
\item{word}{string or vector of strings to encode}

\item{maxCodeLen}{maximum length of the resulting encodings, in characters}
}
\value{
the Phonex encoded character vector
}
\description{
The Phonex name coding procedure.
}
\details{
The variable \code{word} is the name to be encoded.  The variable
\code{maxCodeLen} is the limit on how long the returned name code
should be.  The default is 4.
}
\examples{
phonex("William")
phonex(c("Peter", "Peady"))
phonex("Stevenson", maxCodeLen = 8)

}
\references{
A.J. Lait and Brian Randell. "An assessment of name matching
algorithms." Technical Report Series-University of Newcastle Upon
Tyne Computing Science (1996).
}
\seealso{
Other phonics: \code{\link{caverphone}},
  \code{\link{cologne}}, \code{\link{lein}},
  \code{\link{metaphone}}, \code{\link{mra_encode}},
  \code{\link{nysiis}}, \code{\link{onca}},
  \code{\link{rogerroot}}, \code{\link{soundex}},
  \code{\link{statcan}}
}
