% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{rmDerivedSpct}
\alias{rmDerivedSpct}
\title{Remove "generic_spct" and derived class attributes.}
\usage{
rmDerivedSpct(x)
}
\arguments{
\item{x}{an R object.}
}
\value{
A character vector containing the removed class attribute values.
  This is different to the behaviour of function \code{unlist} in base R!
}
\description{
Removes from a spectrum object the class attributes "generic_spct" and any
derived class attribute such as "source_spct". \strong{This operation is done
by reference!}
}
\note{
If \code{x} is an object of any of the spectral classes defined
  in this package, this function changes by reference the spectrum
  object into the underlying data.frame object. Otherwise, it just leaves \code{x}
  unchanged.

This function alters x itself by reference. If x is not a generic_spct object, x is not
  modified.
}
\examples{
my.spct <- sun.spct
removed <- rmDerivedSpct(my.spct)
removed
class(sun.spct)
class(my.spct)

}
\seealso{
Other set and unset spectral class functions: 
\code{\link{setGenericSpct}()}
}
\concept{set and unset spectral class functions}
