% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{setWhenMeasured}
\alias{setWhenMeasured}
\alias{when_measured<-}
\alias{setWhenMeasured.default}
\alias{setWhenMeasured.generic_spct}
\alias{setWhenMeasured.summary_generic_spct}
\alias{setWhenMeasured.generic_mspct}
\title{Set the "when.measured" attribute}
\usage{
setWhenMeasured(x, when.measured, ...)

when_measured(x) <- value

\method{setWhenMeasured}{default}(x, when.measured, ...)

\method{setWhenMeasured}{generic_spct}(x, when.measured = lubridate::now(tzone = "UTC"), ...)

\method{setWhenMeasured}{summary_generic_spct}(x, when.measured = lubridate::now(tzone = "UTC"), ...)

\method{setWhenMeasured}{generic_mspct}(x, when.measured = lubridate::now(tzone = "UTC"), ...)
}
\arguments{
\item{x}{a generic_spct object}

\item{when.measured, value}{POSIXct to add as attribute, or a list of POSIXct.}

\item{...}{Allows use of additional arguments in methods for other classes.}
}
\value{
x
}
\description{
Function to set by reference the "when" attribute  of an existing
generic_spct or an object of a class derived from generic_spct.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default

\item \code{generic_spct}: generic_spct

\item \code{summary_generic_spct}: summary_generic_spct

\item \code{generic_mspct}: generic_mspct
}}

\note{
This method alters x itself by reference and in addition
  returns x invisibly. If x is not a generic_spct or an object of a class derived from
  generic_spct, x is not modified. If \code{when} is not a POSIXct object
  or \code{NULL} an error is triggered. A \code{POSIXct} describes an
  instant in time (date plus time-of-day plus time zone).
}
\examples{
my.spct <- sun.spct
when_measured(my.spct)
when_measured(my.spct) <- lubridate::ymd_hms("2020-01-01 08:00:00")
when_measured(my.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
