% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy.attr.R
\name{get_attributes}
\alias{get_attributes}
\alias{get_attributes.generic_spct}
\alias{get_attributes.source_spct}
\alias{get_attributes.filter_spct}
\alias{get_attributes.reflector_spct}
\alias{get_attributes.object_spct}
\alias{get_attributes.solute_spct}
\alias{get_attributes.waveband}
\title{Get the metadata attributes}
\usage{
get_attributes(x, which, ...)

\method{get_attributes}{generic_spct}(x, which = NULL, allowed = all.attributes, ...)

\method{get_attributes}{source_spct}(x, which = NULL, ...)

\method{get_attributes}{filter_spct}(x, which = NULL, ...)

\method{get_attributes}{reflector_spct}(x, which = NULL, ...)

\method{get_attributes}{object_spct}(x, which = NULL, ...)

\method{get_attributes}{solute_spct}(x, which = NULL, ...)

\method{get_attributes}{waveband}(x, which = NULL, ...)
}
\arguments{
\item{x}{a generic_spct object.}

\item{which}{character vector Names of attributes to retrieve.}

\item{...}{currently ignored}

\item{allowed}{character vector Names of attributes accepted by \code{which}.}
}
\value{
Named \code{list} of attribute values.
}
\description{
Method returning attributes of an object of class generic_spct or derived,
or of class waveband. Only attributes defined and/or set by package
'photobiology' for objects of the corresponding class are returned. Parameter
\code{which} can be used to subset the list of attributes.
}
\details{
Vectors of character strings passed as argument to \code{which} are
  parsed so that if the first member string is \code{"-"} the remaining
  members are removed from the \code{allowed}; and if it is \code{"="} the
  remaining members are used if in \code{allowed}. If the first member is
  none of these three strings, the behaviour is the same as if the first
  string is \code{"="}. If \code{which} is \code{NULL} all the attributes in
  \code{allowed} are used. The string \code{""} means no attributes, and has
  precedence over any other values in the character vector. The order of the
  names of annotations has no meaning: the vector is interpreted as a set
  except for the three possible "operators" at position 1.
}
\section{Methods (by class)}{
\itemize{
\item \code{get_attributes(generic_spct)}: generic_spct

\item \code{get_attributes(source_spct)}: source_spct

\item \code{get_attributes(filter_spct)}: filter_spct

\item \code{get_attributes(reflector_spct)}: reflector_spct

\item \code{get_attributes(object_spct)}: object_spct

\item \code{get_attributes(solute_spct)}: solute_spct

\item \code{get_attributes(waveband)}: waveband

}}
\seealso{
\code{\link{select_spct_attributes}}

Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
